/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.junit.Assert;
import org.junit.Test;

public class FacetSetCatalogManagerTests {
    private static final String ROOT_FACET_SET_NAME = "Bug371367-FacetSetCatalogManagerTests";
    private static final String FIRST_FACET_SET_NAME = "FacetSetCatalogManagerTests_FirstFacetSet";
    private static final String SECOND_FACET_SET_NAME = "FacetSetCatalogManagerTests_SecondFacetSet";

    @Test
    public void testBug371367HierarchicalFacetSets() {
        IFacetSetCatalogManager catalogMgr = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)new ResourceSetImpl());
        FacetSet fsRoot = FacetUtils.getFacetSet((Collection)catalogMgr.getRegisteredFacetSets(), (String)ROOT_FACET_SET_NAME);
        Assert.assertNotNull((String)"The root FacetSet must be found", (Object)fsRoot);
        List fssFirst = FacetUtils.getFacetSetsByPath((Collection)catalogMgr.getRegisteredFacetSets(), (String[])new String[]{ROOT_FACET_SET_NAME, FIRST_FACET_SET_NAME});
        Assert.assertEquals((long)1L, (long)fssFirst.size());
        FacetSet fsFirst = (FacetSet)fssFirst.get(0);
        Assert.assertNotNull((String)"The first FacetSet must be found", (Object)fsFirst);
        List fssSecond = FacetUtils.getFacetSetsByPath((Collection)catalogMgr.getRegisteredFacetSets(), (String[])new String[]{ROOT_FACET_SET_NAME, SECOND_FACET_SET_NAME});
        Assert.assertEquals((long)1L, (long)fssSecond.size());
        FacetSet fsSecond = (FacetSet)fssSecond.get(0);
        Assert.assertNotNull((String)"The second FacetSet must be found", (Object)fsSecond);
        Assert.assertNull((String)"The first FacetSet shouldn't be registered at the root", (Object)FacetUtils.getFacetSet((Collection)catalogMgr.getRegisteredFacetSets(), (String)FIRST_FACET_SET_NAME));
        Assert.assertNull((String)"The second FacetSet shouldn't be registered at the root", (Object)FacetUtils.getFacetSet((Collection)catalogMgr.getRegisteredFacetSets(), (String)SECOND_FACET_SET_NAME));
    }
}

