/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.core.tests.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.CustomFactory;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationsDelegatingListTests {
    private static final int CUSTOM_NUMBER = 5;
    private static final int FACETSET_NUMBER = 5;
    private static final String STATIC_METHOD = "static-method";

    private static List<Customization> createCustomizations(int facetSetNb, int customNb) {
        IFacetManager facetManager = CustomizationsDelegatingListTests.createFacetManager(facetSetNb, customNb);
        return CustomizationsDelegatingListTests.createCustomizations(facetManager);
    }

    private static List<Customization> createCustomizations(IFacetManager facetManager) {
        ICustomizationManager customManager = ICustomizationManagerFactory.DEFAULT.createICustomizationManager(facetManager);
        return customManager.getManagedCustomizations();
    }

    private static IFacetManager createFacetManager(int facetSetNb, int customNb) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager((ResourceSet)resourceSet);
        int facetSetCount = 0;
        int customCount = 0;
        int i = 0;
        while (i < facetSetNb + customNb) {
            if (facetSetCount < facetSetNb) {
                facetManager.getManagedFacetSets().add(EFacetFactory.eINSTANCE.createFacetSet());
                ++facetSetCount;
            }
            if (customCount < customNb) {
                facetManager.getManagedFacetSets().add(CustomFactory.eINSTANCE.createCustomization());
                ++customCount;
            }
            ++i;
        }
        return facetManager;
    }

    @Test
    public void size() {
        List<Customization> managedCustom1 = CustomizationsDelegatingListTests.createCustomizations(5, 5);
        Assert.assertEquals((String)"The size must be 5", (long)5L, (long)managedCustom1.size());
        List<Customization> managedCustom2 = CustomizationsDelegatingListTests.createCustomizations(0, 5);
        Assert.assertEquals((String)"The size must be 5", (long)5L, (long)managedCustom2.size());
        List<Customization> managedCustom3 = CustomizationsDelegatingListTests.createCustomizations(5, 0);
        Assert.assertEquals((String)"The size must be 0", (long)0L, (long)managedCustom3.size());
        List<Customization> managedCustom4 = CustomizationsDelegatingListTests.createCustomizations(0, 0);
        Assert.assertEquals((String)"The size must be 0", (long)0L, (long)managedCustom4.size());
    }

    @Test
    public void isEmpty() {
        List<Customization> managedCustom1 = CustomizationsDelegatingListTests.createCustomizations(5, 5);
        Assert.assertFalse((String)"The list must not be empty", (boolean)managedCustom1.isEmpty());
        List<Customization> managedCustom2 = CustomizationsDelegatingListTests.createCustomizations(0, 5);
        Assert.assertFalse((String)"The list must not be empty", (boolean)managedCustom2.isEmpty());
        List<Customization> managedCustom3 = CustomizationsDelegatingListTests.createCustomizations(5, 0);
        Assert.assertTrue((String)"The list must be empty", (boolean)managedCustom3.isEmpty());
        List<Customization> managedCustom4 = CustomizationsDelegatingListTests.createCustomizations(0, 0);
        Assert.assertTrue((String)"The list must be empty", (boolean)managedCustom4.isEmpty());
    }

    @Test
    public void contains() {
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(5, 5);
        Customization custom = managedCustom.get(2);
        Assert.assertTrue((String)"Can't find custom", (boolean)managedCustom.contains(custom));
        Assert.assertFalse((String)"List must not contain a new custom", (boolean)managedCustom.contains(CustomFactory.eINSTANCE.createCustomization()));
    }

    @Test
    public void iterator() {
        int customCount = 0;
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(5, 5);
        Iterator<Customization> iterator = managedCustom.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++customCount;
        }
        Assert.assertEquals((String)"Iteration doesn't return 5 elements", (long)5L, (long)customCount);
    }

    @Test
    public void toArray() {
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(5, 5);
        Object[] array = managedCustom.toArray();
        Assert.assertEquals((String)"Array size must be 5", (long)5L, (long)array.length);
        Matcher instanceOf = IsInstanceOf.instanceOf(Customization.class);
        int i = 0;
        while (i < array.length) {
            Object custom = array[i];
            Assert.assertThat((Object)custom, (Matcher)instanceOf);
            ++i;
        }
    }

    @Test
    public void toArrayWithType() {
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(5, 5);
        Customization[] array = managedCustom.toArray(new Customization[managedCustom.size()]);
        Assert.assertEquals((String)"Array size must be 5", (long)5L, (long)array.length);
        Matcher instanceOf = IsInstanceOf.instanceOf(Customization.class);
        int i = 0;
        while (i < array.length) {
            Customization custom = array[i];
            Assert.assertThat((Object)custom, (Matcher)instanceOf);
            ++i;
        }
    }

    @Test
    public void add() {
        IFacetManager facetManager = CustomizationsDelegatingListTests.createFacetManager(5, 5);
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(facetManager);
        managedCustom.add(CustomFactory.eINSTANCE.createCustomization());
        Assert.assertEquals((String)"The size of custom list must be 6", (long)6L, (long)managedCustom.size());
        Assert.assertEquals((String)"The size of facet manager list must be 11", (long)11L, (long)facetManager.getManagedFacetSets().size());
    }

    @Test
    public void removeObject() {
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(5, 5);
        Customization customToRemove = managedCustom.get(2);
        boolean removed = managedCustom.remove(customToRemove);
        Assert.assertTrue((String)"The element isn't removed", (boolean)removed);
        Assert.assertEquals((String)"The size must be 4", (long)4L, (long)managedCustom.size());
        for (Customization custom : managedCustom) {
            Assert.assertNotSame((String)"The element isn't removed", (Object)customToRemove, (Object)custom);
        }
    }

    @Test
    public void containsAll() {
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(5, 5);
        ArrayList<Customization> listToTest1 = new ArrayList<Customization>();
        listToTest1.add(managedCustom.get(0));
        listToTest1.add(managedCustom.get(1));
        listToTest1.add(managedCustom.get(2));
        Assert.assertTrue((String)"All elements are not found in custom list", (boolean)managedCustom.containsAll(listToTest1));
        ArrayList<Customization> listToTest2 = new ArrayList<Customization>();
        listToTest2.add(managedCustom.get(2));
        listToTest2.add(CustomFactory.eINSTANCE.createCustomization());
        Assert.assertFalse((String)"All elements must not be found in custom list", (boolean)managedCustom.containsAll(listToTest2));
    }

    @Test
    public void addAll() {
        IFacetManager facetManager = CustomizationsDelegatingListTests.createFacetManager(5, 5);
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(facetManager);
        ArrayList<Customization> listToAdd = new ArrayList<Customization>();
        listToAdd.add(CustomFactory.eINSTANCE.createCustomization());
        listToAdd.add(CustomFactory.eINSTANCE.createCustomization());
        managedCustom.addAll(listToAdd);
        Assert.assertEquals((String)"The size of custom list must be 7", (long)7L, (long)managedCustom.size());
        Assert.assertEquals((String)"The size of facet manager list must be 12", (long)12L, (long)facetManager.getManagedFacetSets().size());
    }

    @Test
    public void addAllAtIndex() {
        IFacetManager facetManager = CustomizationsDelegatingListTests.createFacetManager(5, 5);
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(facetManager);
        Customization newCustom1 = CustomFactory.eINSTANCE.createCustomization();
        Customization newCustom2 = CustomFactory.eINSTANCE.createCustomization();
        ArrayList<Customization> listToAdd = new ArrayList<Customization>();
        listToAdd.add(newCustom1);
        listToAdd.add(newCustom2);
        managedCustom.addAll(1, listToAdd);
        Assert.assertEquals((String)"The size of custom list must be 7", (long)7L, (long)managedCustom.size());
        Assert.assertEquals((String)"The size of facet manager list must be 12", (long)12L, (long)facetManager.getManagedFacetSets().size());
        Assert.assertSame((String)"Added custom isn't correct", (Object)newCustom1, (Object)managedCustom.get(1));
        Assert.assertSame((String)"Added custom isn't correct", (Object)newCustom2, (Object)managedCustom.get(2));
    }

    @Test
    public void removeAll() {
        IFacetManager facetManager = CustomizationsDelegatingListTests.createFacetManager(5, 5);
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(facetManager);
        int index = 1;
        ArrayList<Customization> listToRemove = new ArrayList<Customization>();
        listToRemove.add(managedCustom.get(index));
        listToRemove.add(managedCustom.get(++index));
        listToRemove.add(managedCustom.get(++index));
        listToRemove.add(managedCustom.get(++index));
        Customization lastCustom = managedCustom.get(0);
        managedCustom.removeAll(listToRemove);
        Assert.assertEquals((String)"The size of custom list must be 1", (long)1L, (long)managedCustom.size());
        Assert.assertSame((String)"The last custom has changed", (Object)lastCustom, (Object)managedCustom.get(0));
        Assert.assertEquals((String)"The size of facet manager list must be 6", (long)6L, (long)facetManager.getManagedFacetSets().size());
    }

    @Test
    public void retainAll() {
        IFacetManager facetManager = CustomizationsDelegatingListTests.createFacetManager(5, 5);
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(facetManager);
        ArrayList<Customization> listToRetain = new ArrayList<Customization>();
        Customization customToRetain = managedCustom.get(1);
        listToRetain.add(customToRetain);
        managedCustom.retainAll(listToRetain);
        Assert.assertEquals((String)"The size of custom list must be 1", (long)1L, (long)managedCustom.size());
        Assert.assertSame((String)"The retained custom has changed", (Object)customToRetain, (Object)managedCustom.get(0));
        Assert.assertEquals((String)"The size of facet manager list must be 6", (long)6L, (long)facetManager.getManagedFacetSets().size());
    }

    @Test
    public void clear() {
        IFacetManager facetManager = CustomizationsDelegatingListTests.createFacetManager(5, 5);
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(facetManager);
        managedCustom.clear();
        Assert.assertEquals((String)"The size of custom list must be 0", (long)0L, (long)managedCustom.size());
        Assert.assertEquals((String)"The size of facet manager list must be 5", (long)5L, (long)facetManager.getManagedFacetSets().size());
    }

    @Test
    public void get() {
        IFacetManager facetManager = CustomizationsDelegatingListTests.createFacetManager(5, 5);
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(facetManager);
        FacetSet custom1 = (FacetSet)facetManager.getManagedFacetSets().get(1);
        Assert.assertSame((Object)custom1, (Object)managedCustom.get(0));
        FacetSet custom2 = (FacetSet)facetManager.getManagedFacetSets().get(3);
        Assert.assertSame((Object)custom2, (Object)managedCustom.get(1));
    }

    @Test
    public void set() {
        IFacetManager facetManager = CustomizationsDelegatingListTests.createFacetManager(5, 5);
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(facetManager);
        Customization customToSet = CustomFactory.eINSTANCE.createCustomization();
        Customization oldCustom = managedCustom.get(0);
        Customization removedCustom = managedCustom.set(0, customToSet);
        Assert.assertSame((String)"The changed custom isn't correct", (Object)oldCustom, (Object)removedCustom);
        Assert.assertSame((String)"The new custom isn't correct in custom list", (Object)customToSet, (Object)managedCustom.get(0));
        Assert.assertSame((String)"The new custom isn't correct in facet manager list", (Object)customToSet, facetManager.getManagedFacetSets().get(1));
        Assert.assertEquals((String)"The size of custom list must be 5", (long)5L, (long)managedCustom.size());
        Assert.assertEquals((String)"The size of facet manager list must be 10", (long)10L, (long)facetManager.getManagedFacetSets().size());
    }

    @Test
    public void addAtIndex() {
        IFacetManager facetManager = CustomizationsDelegatingListTests.createFacetManager(5, 5);
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(facetManager);
        Customization customToAdd = CustomFactory.eINSTANCE.createCustomization();
        managedCustom.add(0, customToAdd);
        Assert.assertSame((String)"The new custom isn't correct in custom list", (Object)customToAdd, (Object)managedCustom.get(0));
        Assert.assertSame((String)"The new custom isn't correct in facet manager list", (Object)customToAdd, facetManager.getManagedFacetSets().get(0));
        Assert.assertEquals((String)"The size of custom list must be 6", (long)6L, (long)managedCustom.size());
        Assert.assertEquals((String)"The size of facet manager list must be 11", (long)11L, (long)facetManager.getManagedFacetSets().size());
    }

    @Test
    public void removeAtIndex() {
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(5, 5);
        Customization customToRemove = managedCustom.get(3);
        Customization removed = managedCustom.remove(3);
        Assert.assertSame((String)"The removed element isn't correct", (Object)customToRemove, (Object)removed);
        Assert.assertEquals((String)"The size must be 4", (long)4L, (long)managedCustom.size());
        for (Customization custom : managedCustom) {
            Assert.assertNotSame((String)"The element isn't removed", (Object)customToRemove, (Object)custom);
        }
    }

    @Test
    public void indexOf() {
        IFacetManager facetManager = CustomizationsDelegatingListTests.createFacetManager(5, 5);
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(facetManager);
        FacetSet customToSearch = (FacetSet)facetManager.getManagedFacetSets().get(3);
        Assert.assertEquals((String)"Element searching failed", (long)1L, (long)managedCustom.indexOf(customToSearch));
    }

    @Test
    public void lastIndexOf() {
        IFacetManager facetManager = CustomizationsDelegatingListTests.createFacetManager(5, 5);
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(facetManager);
        FacetSet customToSearch = (FacetSet)facetManager.getManagedFacetSets().get(5);
        Assert.assertEquals((String)"Element searching failed", (long)2L, (long)managedCustom.lastIndexOf(customToSearch));
    }

    @Test
    public void listIterator() {
        int customCount = 0;
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(5, 5);
        ListIterator<Customization> iterator = managedCustom.listIterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++customCount;
        }
        Assert.assertEquals((String)"Iteration doesn't return 5 elements", (long)5L, (long)customCount);
    }

    @Test
    public void listIteratorAtIndex() {
        int customCount = 0;
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(5, 5);
        ListIterator<Customization> iterator = managedCustom.listIterator(2);
        while (iterator.hasNext()) {
            iterator.next();
            ++customCount;
        }
        Assert.assertEquals((String)"Iteration doesn't return 3 elements", (long)3L, (long)customCount);
    }

    @Test
    public void subList() {
        IFacetManager facetManager = CustomizationsDelegatingListTests.createFacetManager(5, 5);
        List<Customization> managedCustom = CustomizationsDelegatingListTests.createCustomizations(facetManager);
        ArrayList<FacetSet> subList = new ArrayList<FacetSet>();
        int index = 1;
        subList.add((FacetSet)facetManager.getManagedFacetSets().get(index));
        subList.add((FacetSet)facetManager.getManagedFacetSets().get(index += 2));
        Assert.assertEquals((String)"Sublist isn't correct", subList, managedCustom.subList(0, 2));
    }
}

