/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.core.tests.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.util.emf.core.internal.catalog.v2.EmfUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class Bug521883 {
    private IProject project;

    @After
    public void after() throws CoreException {
        if (this.project != null) {
            this.project.delete(true, null);
        }
    }

    @Test
    public void testGetProjectNameWithSpaceAndEncodeURI() throws CoreException {
        this.assertProjectName("Bug 521883", true);
    }

    @Test
    public void testGetProjectNameWithSpace() throws CoreException {
        this.assertProjectName("Bug 521883", false);
    }

    @Test
    public void testGetProjectNameWithSpecialCharAndEncodeURI() throws CoreException {
        this.assertProjectName("Bug%521883", true);
    }

    @Test
    public void testGetProjectNameWithSpecialChar() throws CoreException {
        this.assertProjectName("Bug%521883", false);
    }

    private void assertProjectName(String projectName, boolean encodeURI) throws CoreException {
        this.project = Bug521883.getProject(projectName);
        this.project.create(null);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        String pathName = String.format("%s/resource.xmi", projectName);
        URI uri = URI.createPlatformResourceURI((String)pathName, (boolean)encodeURI);
        Resource resource = resourceSet.createResource(uri);
        URI resourceUri = resource.getURI();
        IProject projectFromURI = EmfUtils.getProject((URI)resourceUri);
        Assert.assertEquals((String)"Project name from resource URI must be equals to original project name", (Object)this.project.getName(), (Object)projectFromURI.getName());
    }

    private static IProject getProject(String prjName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        return root.getProject(prjName);
    }
}

