/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.emf.core.ModelUtils;
import org.eclipse.emf.facet.util.junit.core.internal.exported.matcher.Contains;
import org.eclipse.emf.facet.util.swt.internal.exported.TestUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.InstantiationMethod;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetInternalUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableCell;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NatTableAPITests {
    private static final String RESOURCES_LOCATION = "/resources/v0_2/";
    private static final int TIMEOUT = 30000;
    private static final String RESOURCES_TEST = "tableTestNatTableAPITest.table";
    private static final String RESOURCES_ECORE_MODEL = "ecoreModel.ecore";
    private static final String PROJECT_NAME = "NatTableAPITestsProject";
    private static final String RESOURCES_TEST_WITH_TABLECONFIGURATION = "tableTestWithTableConfiguration.table";
    private static final String TEST_ECORE_TABLECONFIGURATION = "_test_EcoreTableConfiguration.tableconfiguration";
    private static final List<Column> EMPTY_COLUMN_LST = Collections.emptyList();
    private ITableWidgetInternal natTableWidget;
    private EditingDomain editingDomain;
    private Resource ecoreModel;
    private IProject project;

    private IEditorPart openEditorOnTable() throws PartInitException {
        IFile tableFile = this.project.getFile(RESOURCES_TEST);
        IEditorPart editor = NatTableAPITests.openEditor(tableFile);
        ITableWidgetProvider natTableWidgetPart = (ITableWidgetProvider)editor.getAdapter(ITableWidgetProvider.class);
        Assert.assertNotNull((Object)natTableWidgetPart);
        this.natTableWidget = (ITableWidgetInternal)natTableWidgetPart.getTableWidget();
        return editor;
    }

    private static IEditorPart openEditor(final IFile file) throws PartInitException {
        final IEditorPart[] editorHandler = new IEditorPart[1];
        final PartInitException[] exceptionHander = new PartInitException[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    editorHandler[0] = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
                }
                catch (PartInitException e) {
                    exceptionHander[0] = e;
                }
            }
        });
        if (exceptionHander[0] != null) {
            throw exceptionHander[0];
        }
        return editorHandler[0];
    }

    @BeforeClass
    public static void beforeClass() {
        TestUtils.closeWelcomePage();
    }

    @Before
    public void initResource() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project2 = iProjectArray[n2];
            project2.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        this.project = workspace.getRoot().getProject(PROJECT_NAME);
        this.project.create((IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/tableTestNatTableAPITest.table", (IProject)this.project, (String)"/tableTestNatTableAPITest.table", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/ecoreModel.ecore", (IProject)this.project, (String)"/ecoreModel.ecore", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/tableTestWithTableConfiguration.table", (IProject)this.project, (String)"/tableTestWithTableConfiguration.table", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/_test_EcoreTableConfiguration.tableconfiguration", (IProject)this.project, (String)"/_test_EcoreTableConfiguration.tableconfiguration", (Bundle)bundle);
        IEditorPart editor = this.openEditorOnTable();
        Assert.assertNotNull((Object)this.natTableWidget);
        Assert.assertTrue((boolean)(editor instanceof IEditingDomainProvider));
        this.editingDomain = ((IEditingDomainProvider)editor).getEditingDomain();
        Assert.assertNotNull((Object)this.editingDomain);
        this.ecoreModel = this.editingDomain.getResourceSet().getResource(URI.createPlatformResourceURI((String)"NatTableAPITestsProject/ecoreModel.ecore", (boolean)true), true);
        Assert.assertNotNull((Object)this.ecoreModel);
    }

    @Test(timeout=30000L)
    public void deleteSelectionTest() {
        EObject eObject = (EObject)TableWidgetUtils.getElements((Table)this.natTableWidget.getTable()).get(0);
        this.natTableWidget.selectCell(eObject, (EStructuralFeature)this.getSelfReference());
        ISelection selection = this.natTableWidget.getSelection();
        Object element = null;
        if (selection instanceof IStructuredSelection) {
            element = ((IStructuredSelection)selection).getFirstElement();
        }
        Assert.assertEquals((Object)eObject, element);
        Assert.assertTrue((boolean)this.natTableWidget.isCellSelected());
        int oldRowSize = this.natTableWidget.getTable().getRows().size();
        this.natTableWidget.deleteSelection();
        Assert.assertEquals((long)(oldRowSize - 1), (long)this.natTableWidget.getTable().getRows().size());
        Assert.assertFalse((boolean)TableWidgetUtils.getElements((Table)this.natTableWidget.getTable()).contains(eObject));
        EObject contents = (EObject)this.ecoreModel.getContents().get(0);
        Assert.assertFalse((boolean)((EPackage)contents).getEClassifiers().contains((Object)eObject));
    }

    private FacetReference getSelfReference() {
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.ecore/resources/eobject_ext.efacet");
        Resource resource = resourceSet.getResource(uri, true);
        FacetSet eObjExtFacetSet = (FacetSet)resource.getContents().get(0);
        Assert.assertNotNull((Object)eObjExtFacetSet);
        Facet facet = FacetUtils.getFacet((Collection)FacetUtils.getFacets((FacetSet)eObjExtFacetSet), (String)"EObjectExt");
        Assert.assertNotNull((Object)facet);
        FacetReference self = (FacetReference)FacetUtils.getETypedElement((Facet)facet, (String)"self", FacetReference.class);
        Assert.assertNotNull((Object)self);
        return self;
    }

    @Test(timeout=30000L)
    public void selectAllTest() {
        List eObjectsInTable = TableWidgetUtils.getElements((Table)this.natTableWidget.getTable());
        this.natTableWidget.selectAll();
        ISelection selection = this.natTableWidget.getSelection();
        IStructuredSelection structSelection = (IStructuredSelection)selection;
        List objects = structSelection.toList();
        Assert.assertFalse((boolean)objects.isEmpty());
        Assert.assertThat((Object)objects, (Matcher)Contains.containsAll((Collection)eObjectsInTable));
    }

    @Test(timeout=30000L)
    public void addRowsTest() {
        List initialObjects = TableWidgetUtils.getElements((Table)this.natTableWidget.getTable());
        ArrayList<EClass> newObjects = new ArrayList<EClass>();
        newObjects.add(EcoreFactory.eINSTANCE.createEClass());
        newObjects.add(EcoreFactory.eINSTANCE.createEClass());
        this.natTableWidget.addRows(newObjects);
        List actualObjects = TableWidgetUtils.getElements((Table)this.natTableWidget.getTable());
        ArrayList<EClass> expectedObjects = new ArrayList<EClass>(initialObjects);
        expectedObjects.addAll(newObjects);
        Assert.assertEquals(expectedObjects, (Object)actualObjects);
        Assert.assertEquals((long)27L, (long)this.natTableWidget.getTable().getColumns().size());
        ArrayList<EPackage> newEPackages = new ArrayList<EPackage>();
        newEPackages.add(EcoreFactory.eINSTANCE.createEPackage());
        newEPackages.add(EcoreFactory.eINSTANCE.createEPackage());
        newEPackages.add(EcoreFactory.eINSTANCE.createEPackage());
        this.natTableWidget.addRows(newEPackages);
        Assert.assertEquals((long)33L, (long)this.natTableWidget.getTable().getColumns().size());
    }

    @Test(timeout=30000L)
    public void removeLineTest() {
        EObject eObject = (EObject)TableWidgetUtils.getElements((Table)this.natTableWidget.getTable()).get(0);
        this.natTableWidget.selectRows(Collections.singletonList(eObject), true);
        ISelection selection = this.natTableWidget.getSelection();
        IStructuredSelection structSelection = (IStructuredSelection)selection;
        Assert.assertEquals((Object)structSelection.getFirstElement(), (Object)eObject);
        int oldRowSize = this.natTableWidget.getTable().getRows().size();
        this.natTableWidget.removeLine();
        Assert.assertEquals((long)(oldRowSize - 1), (long)this.natTableWidget.getTable().getRows().size());
        Assert.assertFalse((boolean)TableWidgetUtils.getElements((Table)this.natTableWidget.getTable()).contains(eObject));
        EObject contents = (EObject)this.ecoreModel.getContents().get(0);
        Assert.assertTrue((boolean)((EPackage)contents).getEClassifiers().contains((Object)eObject));
    }

    @Test(timeout=30000L)
    public void saveTest() throws CoreException {
        Assert.assertNotNull((Object)this.natTableWidget);
        Collection registeredFS = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(this.editingDomain.getResourceSet()).getRegisteredFacetSets();
        FacetSet facetSet = FacetUtils.getFacetSet((Collection)registeredFS, (String)"_example_Ecore");
        Assert.assertNotNull((Object)facetSet);
        Facet facet = FacetUtils.getFacet((Collection)FacetUtils.getFacets((FacetSet)facetSet), (String)"FacetExample");
        Assert.assertNotNull((Object)facet);
        Assert.assertTrue((((Column)this.natTableWidget.getTable().getColumns().get(0)).getWidth() != 71 ? 1 : 0) != 0);
        ((Column)this.natTableWidget.getTable().getColumns().get(0)).setWidth(71);
        this.natTableWidget.save();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
            }
        });
        this.openEditorOnTable();
        Assert.assertEquals((long)71L, (long)((Column)this.natTableWidget.getTable().getColumns().get(0)).getWidth());
    }

    @Test(timeout=30000L)
    public void selectRowsRawTest() {
        List visibleColumns = this.natTableWidget.getVisibleColumns(false);
        Assert.assertNotNull((Object)this.natTableWidget);
        List ownedElements = TableWidgetUtils.getElements((Table)this.natTableWidget.getTable());
        Assert.assertTrue((ownedElements.size() >= 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.natTableWidget.getSelection().isEmpty());
        ArrayList<EObject> elementsToSelect = new ArrayList<EObject>();
        elementsToSelect.addAll(ownedElements);
        this.natTableWidget.selectRows(elementsToSelect, true);
        List rawSelection = this.natTableWidget.getRawSelection();
        this.checkFullySelected(rawSelection, elementsToSelect, EMPTY_COLUMN_LST);
        elementsToSelect.remove(1);
        this.natTableWidget.selectRows(elementsToSelect, true);
        rawSelection = this.natTableWidget.getRawSelection();
        this.checkFullySelected(rawSelection, elementsToSelect, EMPTY_COLUMN_LST);
        EObject elementToSelect = (EObject)TableWidgetUtils.getElements((Table)this.natTableWidget.getTable()).get(1);
        EReference columnToSelect = EcorePackage.eINSTANCE.getEClassifier_EPackage();
        this.natTableWidget.selectCell(elementToSelect, (EStructuralFeature)columnToSelect);
        this.natTableWidget.selectRows(elementsToSelect, false);
        rawSelection = this.natTableWidget.getRawSelection();
        this.checkFullySelected(rawSelection, elementsToSelect, visibleColumns);
        this.checkSelected(rawSelection, elementToSelect, columnToSelect);
    }

    private void checkSelected(List<Object> rawSelection, EObject elementToSelect, EReference columnToSelect) {
        boolean found = false;
        for (Object object : rawSelection) {
            ITableCell cell;
            if (object instanceof ITableCell && (cell = (ITableCell)object).getRow().getElement() == elementToSelect && cell.getColumn() instanceof FeatureColumn && ((FeatureColumn)cell.getColumn()).getFeature() == columnToSelect) {
                found = true;
            }
            if (found) break;
        }
        String msg = String.format("This element should be selected: %s in the column for the feature: %s.", elementToSelect, columnToSelect.getName());
        Assert.assertTrue((String)msg, (boolean)found);
    }

    private void checkFullySelected(List<Object> rawSelection, List<EObject> elementsToSelect, List<Column> columns) {
        for (EObject eObject : elementsToSelect) {
            this.isInFullySelectedRows(eObject, rawSelection);
            for (Column column : columns) {
                this.isInFullySelectedColumn(eObject, column, rawSelection);
            }
        }
    }

    protected void isInFullySelectedRows(EObject eObject, List<?> selection) {
        boolean found = false;
        for (Object selected : selection) {
            Row row = null;
            if (selected instanceof Row) {
                row = (Row)selected;
            } else if (selected instanceof ITableCell) {
                ITableCell cell = (ITableCell)selected;
                row = cell.getRow();
            }
            if (row == null || row.getElement() != eObject) continue;
            found = true;
            break;
        }
        String msg = String.format("This element should be in the fully selected rows: %s", eObject);
        Assert.assertTrue((String)msg, (boolean)found);
    }

    protected void isInFullySelectedColumn(EObject eObject, Column column, List<Object> rawSelection) {
        boolean found = false;
        for (Object selected : rawSelection) {
            if (!(selected instanceof ITableCell)) continue;
            Row row = ((ITableCell)selected).getRow();
            EObject element = row.getElement();
            Column selectionColumn = ((ITableCell)selected).getColumn();
            if (selectionColumn != column || element != eObject) continue;
            found = true;
            break;
        }
        String msg = String.format("This element should be selected in column %s : %s.", column, eObject);
        Assert.assertTrue((String)msg, (boolean)found);
    }

    public void selectionInitiallyEmpty() {
        ISelection selection = this.natTableWidget.getSelection();
        Assert.assertTrue((boolean)selection.isEmpty());
    }

    @Test(timeout=30000L)
    public void selectAllRowsTest() {
        this.selectionInitiallyEmpty();
        List elements = TableWidgetUtils.getElements((Table)this.natTableWidget.getTable());
        this.natTableWidget.selectRows(elements, true);
        ISelection selection = this.natTableWidget.getSelection();
        List selectedElements = ((IStructuredSelection)selection).toList();
        Assert.assertThat((Object)selectedElements, (Matcher)Contains.containsAll((Collection)elements));
    }

    @Test(timeout=30000L)
    public void selectRowsTestWithoutClear() {
        this.selectionInitiallyEmpty();
        EObject selectRow = this.selectRow();
        List<EObject> selectRows = this.selectRows(false);
        ISelection selection = this.natTableWidget.getSelection();
        List selectedElements = ((IStructuredSelection)selection).toList();
        ArrayList<EObject> elementsToSelect = new ArrayList<EObject>(selectRows);
        elementsToSelect.add(selectRow);
        Assert.assertThat((Object)selectedElements, (Matcher)Contains.containsAll(elementsToSelect));
    }

    @Test(timeout=30000L)
    public void selectRowsTestWithClear() {
        this.selectionInitiallyEmpty();
        EObject selectRow = this.selectRow();
        List<EObject> selectRows = this.selectRows(true);
        ISelection selection = this.natTableWidget.getSelection();
        List selectedElements = ((IStructuredSelection)selection).toList();
        Assert.assertThat((Object)selectedElements, (Matcher)Contains.containsAll(selectRows));
        Assert.assertThat((Object)selectedElements, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)selectRow)));
    }

    private EObject selectRow() {
        List elements = TableWidgetUtils.getElements((Table)this.natTableWidget.getTable());
        EObject elementToSelect = (EObject)elements.get(1);
        List<EObject> elementsToSelect = Arrays.asList(elementToSelect);
        this.natTableWidget.selectRows(elementsToSelect, true);
        ISelection selection = this.natTableWidget.getSelection();
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        Assert.assertEquals((Object)elementToSelect, (Object)selectedElement);
        return elementToSelect;
    }

    private List<EObject> selectRows(boolean clear) {
        List elements = TableWidgetUtils.getElements((Table)this.natTableWidget.getTable());
        List<EObject> elementsToSelect = Arrays.asList((EObject)elements.get(0), (EObject)elements.get(2));
        this.natTableWidget.selectRows(elementsToSelect, clear);
        return elementsToSelect;
    }

    @Test(timeout=30000L)
    public void selectCellTest() throws FacetManagerException {
        this.selectionInitiallyEmpty();
        Object cellValue = this.selectCell();
        ISelection selection = this.natTableWidget.getSelection();
        Assert.assertEquals((long)1L, (long)((IStructuredSelection)selection).size());
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        Assert.assertEquals((Object)cellValue, (Object)selectedElement);
    }

    private Object selectCell() throws FacetManagerException {
        List elements = TableWidgetUtils.getElements((Table)this.natTableWidget.getTable());
        EObject elementToSelect = (EObject)elements.get(1);
        EReference columnToSelect = EcorePackage.eINSTANCE.getEClassifier_EPackage();
        this.natTableWidget.selectCell(elementToSelect, (EStructuralFeature)columnToSelect);
        ResourceSet resourceSet = ModelUtils.getOrCreateResourceSet((EObject)elementToSelect);
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateDefaultFacetManager(resourceSet);
        return facetManager.getOrInvoke(elementToSelect, (ETypedElement)columnToSelect, Object.class);
    }

    @Test(timeout=30000L)
    public void selectRowsAndCellTest() throws FacetManagerException {
        this.selectionInitiallyEmpty();
        Object cellValue = this.selectCell();
        List<EObject> rows = this.selectRows(false);
        ArrayList<EObject> elementsToSelect = new ArrayList<EObject>(rows);
        elementsToSelect.add((EObject)cellValue);
        ISelection selection = this.natTableWidget.getSelection();
        List selectedElements = ((IStructuredSelection)selection).toList();
        Assert.assertThat((Object)selectedElements, (Matcher)Contains.containsAll(elementsToSelect));
    }

    @Test(timeout=30000L)
    public void getSelectionChangedListenersTest() {
        Assert.assertNotNull((Object)this.natTableWidget);
        SelectionChangeListenerTest selectionChangedListener = new SelectionChangeListenerTest();
        this.natTableWidget.addSelectionChangedListener((ISelectionChangedListener)selectionChangedListener);
        Assert.assertFalse((boolean)selectionChangedListener.hasBeenNotified());
        this.natTableWidget.selectAll();
        Assert.assertTrue((boolean)selectionChangedListener.hasBeenNotified());
        this.natTableWidget.removeSelectionChangedListener((ISelectionChangedListener)selectionChangedListener);
    }

    @Test(timeout=30000L)
    public void setHideEmptyColumnsTest() {
        Assert.assertNotNull((Object)this.natTableWidget);
        Assert.assertFalse((boolean)this.natTableWidget.getTable().isHideEmptyColumns());
        this.natTableWidget.setHideEmptyColumns(true);
        Assert.assertTrue((boolean)this.natTableWidget.getTable().isHideEmptyColumns());
        this.natTableWidget.setHideEmptyColumns(false);
        Assert.assertFalse((boolean)this.natTableWidget.getTable().isHideEmptyColumns());
    }

    @Test(timeout=30000L)
    public void setOnlyShowCommonColumnsTest() {
        Assert.assertNotNull((Object)this.natTableWidget);
        Assert.assertFalse((boolean)this.natTableWidget.getTable().isOnlyShowCommonColumns());
        this.natTableWidget.setOnlyShowCommonColumns(true);
        Assert.assertTrue((boolean)this.natTableWidget.getTable().isOnlyShowCommonColumns());
        this.natTableWidget.setOnlyShowCommonColumns(false);
        Assert.assertFalse((boolean)this.natTableWidget.getTable().isOnlyShowCommonColumns());
    }

    @Ignore
    @Test(timeout=30000L)
    public void testSortColumnsByType() {
        String[] nonSortedList = new String[]{"/self", "/eClass", "/eContainer", "eAnnotations", "name", "instanceClassName", "/instanceClass", "/defaultValue", "instanceTypeName", "ePackage", "eTypeParameters", "abstract", "interface", "eSuperTypes", "eOperations", "/eAllAttributes", "/eAllReferences", "/eReferences", "/eAttributes", "/eAllContainments", "/eAllOperations", "/eAllStructuralFeatures", "/eAllSuperTypes", "/eIDAttribute", "eStructuralFeatures", "eGenericSuperTypes", "/eAllGenericSuperTypes"};
        String[] sortedByTypeList = new String[]{"name", "instanceClassName", "/instanceClass", "/defaultValue", "instanceTypeName", "abstract", "interface", "/self", "/eClass", "/eContainer", "eAnnotations", "ePackage", "eTypeParameters", "eSuperTypes", "eOperations", "/eAllAttributes", "/eAllReferences", "/eReferences", "/eAttributes", "/eAllContainments", "/eAllOperations", "/eAllStructuralFeatures", "/eAllSuperTypes", "/eIDAttribute", "eStructuralFeatures", "eGenericSuperTypes", "/eAllGenericSuperTypes"};
        String[] sortedByTypeAtoZList = new String[]{"abstract", "/defaultValue", "/instanceClass", "instanceClassName", "instanceTypeName", "interface", "name", "/eAllAttributes", "/eAllContainments", "/eAllGenericSuperTypes", "/eAllOperations", "/eAllReferences", "/eAllStructuralFeatures", "/eAllSuperTypes", "eAnnotations", "/eAttributes", "/eClass", "/eContainer", "eGenericSuperTypes", "/eIDAttribute", "eOperations", "ePackage", "/eReferences", "eStructuralFeatures", "eSuperTypes", "eTypeParameters", "/self"};
        Assert.assertNotNull((Object)this.natTableWidget);
        EList columns = this.natTableWidget.getTable().getColumns();
        int i = 0;
        while (i < columns.size()) {
            Assert.assertEquals((Object)nonSortedList[i], (Object)TableWidgetInternalUtils.getColumnName((Column)((Column)columns.get(i))));
            ++i;
        }
        this.natTableWidget.sortColumnsByType();
        i = 0;
        while (i < columns.size()) {
            Assert.assertEquals((Object)sortedByTypeList[i], (Object)TableWidgetInternalUtils.getColumnName((Column)((Column)columns.get(i))));
            ++i;
        }
        this.natTableWidget.sortColumnsByType();
        this.natTableWidget.sortColumnsByType();
        i = 0;
        while (i < columns.size()) {
            Assert.assertEquals((Object)sortedByTypeList[i], (Object)TableWidgetInternalUtils.getColumnName((Column)((Column)columns.get(i))));
            ++i;
        }
        this.natTableWidget.sortColumnByNameAtoZ();
        this.natTableWidget.sortColumnsByType();
        i = 0;
        while (i < columns.size()) {
            Assert.assertEquals((Object)sortedByTypeAtoZList[i], (Object)TableWidgetInternalUtils.getColumnName((Column)((Column)columns.get(i))));
            ++i;
        }
    }

    @Test(timeout=30000L)
    public void testGetInstantiationMethodHistory() throws PartInitException {
        this.closeAllEditors();
        IFile tableFile = this.project.getFile(RESOURCES_TEST_WITH_TABLECONFIGURATION);
        IEditorPart editor = NatTableAPITests.openEditor(tableFile);
        ITableWidgetProvider natTableWidgetPart = (ITableWidgetProvider)editor.getAdapter(ITableWidgetProvider.class);
        Assert.assertNotNull((Object)natTableWidgetPart);
        this.natTableWidget = (ITableWidgetInternal)natTableWidgetPart.getTableWidget();
        TableConfiguration tableConfiguration = this.natTableWidget.getTableConfiguration();
        Assert.assertNotNull((Object)tableConfiguration);
        Assert.assertEquals((long)2L, (long)tableConfiguration.getInstantiationMethod().size());
        InstantiationMethod method0 = (InstantiationMethod)tableConfiguration.getInstantiationMethod().get(0);
        this.natTableWidget.createNewElement(method0);
        Assert.assertEquals((Object)method0, this.natTableWidget.getInstantiationMethodHistory().get(0));
        InstantiationMethod method1 = (InstantiationMethod)tableConfiguration.getInstantiationMethod().get(1);
        this.natTableWidget.createNewElement(method1);
        Assert.assertEquals((Object)method1, this.natTableWidget.getInstantiationMethodHistory().get(0));
    }

    @After
    public void closeAllEditors() {
        TestUtils.closeAllEditors();
    }

    private class SelectionChangeListenerTest
    implements ISelectionChangedListener {
        private boolean hasBeenNotified = false;

        public boolean hasBeenNotified() {
            return this.hasBeenNotified;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.hasBeenNotified = true;
        }
    }
}

