/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.util.emf.core.ModelUtils;
import org.eclipse.emf.facet.util.junit.core.internal.exported.matcher.Contains;
import org.eclipse.emf.facet.util.swt.internal.exported.TestUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.IStructuredTableSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableCell;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableCellSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableColumnSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableRowSelection;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.ITableView;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.ITableViewFactory;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.TableViewException;
import org.eclipse.jface.viewers.ISelection;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionProviderTest {
    private static final String CLASS_NAME = SelectionProviderTest.class.getSimpleName();
    private static final String BUNDLE_NAME = Activator.getDefault().getBundle().getSymbolicName();
    private static final String RSRCS_LOCATION = "resources/v0_2";
    private static final int TIMEOUT = 30000;
    private ITableWidgetInternal natTableWidget;

    @BeforeClass
    public static void beforeClass() {
        TestUtils.closeWelcomePage();
    }

    @Before
    public void initView() throws TableViewException {
        String uriStr = String.format("platform:/plugin/%s/%s/%s/tableSelectionProviderTest.table", BUNDLE_NAME, RSRCS_LOCATION, CLASS_NAME);
        URI modelUri = URI.createURI((String)uriStr);
        ITableView tableView = ITableViewFactory.DEFAULT.openOn(modelUri);
        ITableWidget tableWidget = tableView.getTableWidget();
        this.natTableWidget = (ITableWidgetInternal)tableWidget;
        Assert.assertNotNull((Object)this.natTableWidget);
    }

    @Test(timeout=30000L)
    public void selectAllTest() {
        this.natTableWidget.selectAll();
        ISelection selection = this.natTableWidget.getSelection();
        IStructuredTableSelection structTableSelect = (IStructuredTableSelection)selection;
        ISelection tableSelection = structTableSelect.getTableSelection();
        ITableRowSelection allRowSelection = (ITableRowSelection)tableSelection;
        List selectedRows = allRowSelection.getSelectedFullRows();
        EList rows = this.natTableWidget.getTable().getRows();
        Assert.assertThat((Object)selectedRows, (Matcher)Contains.containsAll((Collection)rows));
        ITableColumnSelection allColSelection = (ITableColumnSelection)tableSelection;
        List selectedColumns = allColSelection.getSelectedFullColumns();
        EList columns = this.natTableWidget.getTable().getColumns();
        Assert.assertThat((Object)selectedColumns, (Matcher)Contains.containsAll((Collection)columns));
        ArrayList<EObject> elements = new ArrayList<EObject>(rows.size());
        for (Row row : rows) {
            elements.add(row.getElement());
        }
        Assert.assertThat((Object)structTableSelect.toList(), (Matcher)Contains.containsAll(elements));
    }

    @Test(timeout=30000L)
    public void selectOneCellTest() {
        Row row = (Row)this.natTableWidget.getTable().getRows().get(0);
        EObject firstElement = row.getElement();
        Column column = (Column)this.natTableWidget.getTable().getColumns().get(0);
        ETypedElement firstFeature = ((FeatureColumn)column).getFeature();
        this.natTableWidget.selectCell(firstElement, (EStructuralFeature)firstFeature);
        ISelection selection = this.natTableWidget.getSelection();
        IStructuredTableSelection structTableSelect = (IStructuredTableSelection)selection;
        ISelection tableSelection = structTableSelect.getTableSelection();
        ITableCellSelection cellSelection = (ITableCellSelection)tableSelection;
        List selectedCells = cellSelection.getSelectedCells();
        Assert.assertEquals((long)1L, (long)selectedCells.size());
        ITableCell cell = (ITableCell)selectedCells.get(0);
        Assert.assertEquals((Object)row, (Object)cell.getRow());
        Assert.assertEquals((Object)firstElement, (Object)cell.getRow().getElement());
        Assert.assertEquals((Object)column, (Object)cell.getColumn());
        FeatureColumn selectedColumn = (FeatureColumn)cell.getColumn();
        Assert.assertEquals((Object)firstFeature, (Object)selectedColumn.getFeature());
        Assert.assertEquals((long)1L, (long)structTableSelect.toList().size());
        Assert.assertEquals((Object)firstElement, (Object)structTableSelect.getFirstElement());
    }

    @Test(timeout=30000L)
    public void selectFragmentedCells() throws FacetManagerException {
        Table table = this.natTableWidget.getTable();
        Row row1 = (Row)table.getRows().get(0);
        EObject eObject1 = row1.getElement();
        EList columns = table.getColumns();
        Column column2 = (Column)columns.get(1);
        ETypedElement feature2 = ((FeatureColumn)column2).getFeature();
        this.natTableWidget.selectCell(eObject1, (EStructuralFeature)feature2);
        Row row2 = (Row)table.getRows().get(1);
        EObject eObject2 = row2.getElement();
        this.natTableWidget.selectRows(Arrays.asList(eObject2), false);
        ISelection selection = this.natTableWidget.getSelection();
        IStructuredTableSelection structTableSelect = (IStructuredTableSelection)selection;
        ISelection tableSelection = structTableSelect.getTableSelection();
        ITableCellSelection cellSelection = (ITableCellSelection)tableSelection;
        List selectedCells = cellSelection.getSelectedCells();
        Assert.assertEquals((long)(columns.size() + 1), (long)selectedCells.size());
        SelectionProviderTest.checkIsInSelection(selectedCells, row1, column2);
        for (Column column : columns) {
            SelectionProviderTest.checkIsInSelection(selectedCells, row2, column);
        }
        ResourceSet resourceSet = ModelUtils.getOrCreateResourceSet((EObject)table);
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateDefaultFacetManager(resourceSet);
        ArrayList<Object> values = new ArrayList<Object>();
        Object value12 = TableWidgetUtils.getValueOf((Row)row1, (Column)column2, (IFacetManager)facetManager);
        values.add(value12);
        for (Column column : table.getColumns()) {
            Object value = TableWidgetUtils.getValueOf((Row)row2, (Column)column, (IFacetManager)facetManager);
            if (value instanceof Collection) {
                if (((Collection)value).isEmpty()) continue;
                values.add(value);
                continue;
            }
            if (value == null) continue;
            values.add(value);
        }
        Assert.assertEquals((long)values.size(), (long)structTableSelect.size());
        Assert.assertThat(values, (Matcher)Contains.containsAll((Collection)structTableSelect.toList()));
    }

    private static void checkIsInSelection(Collection<ITableCell> selectedCell, Row row, Column column) {
        boolean result = false;
        for (ITableCell cell : selectedCell) {
            if (!cell.getColumn().equals(column) || !cell.getRow().equals(row)) continue;
            result = true;
            break;
        }
        if (!result) {
            String msg = String.format("row %s, column %s not contained in selection %s", row, column, selectedCell);
            Assert.fail((String)msg);
        }
    }

    @Test(timeout=30000L)
    public void selectRows() {
        Row row1 = (Row)this.natTableWidget.getTable().getRows().get(0);
        EObject eObject1 = row1.getElement();
        Row row3 = (Row)this.natTableWidget.getTable().getRows().get(2);
        EObject eObject3 = row3.getElement();
        this.natTableWidget.selectRows(Arrays.asList(eObject1, eObject3), true);
        ISelection selection = this.natTableWidget.getSelection();
        IStructuredTableSelection structTableSelect = (IStructuredTableSelection)selection;
        ISelection tableSelection = structTableSelect.getTableSelection();
        ITableRowSelection rowSelection = (ITableRowSelection)tableSelection;
        List selectedRows = rowSelection.getSelectedFullRows();
        Assert.assertEquals((long)2L, (long)selectedRows.size());
        Assert.assertThat((Object)selectedRows, (Matcher)IsCollectionContaining.hasItem((Object)row1));
        Assert.assertThat((Object)selectedRows, (Matcher)IsCollectionContaining.hasItem((Object)row3));
        List list = structTableSelect.toList();
        Assert.assertThat((Object)list, (Matcher)IsCollectionContaining.hasItem((Object)eObject1));
        Assert.assertThat((Object)list, (Matcher)IsCollectionContaining.hasItem((Object)eObject3));
    }

    @Ignore
    @Test(timeout=30000L)
    public void selectColumns() {
    }

    @Ignore
    @Test(timeout=30000L)
    public void selectRectangle() {
    }
}

