/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.util.swt.internal.exported.TestUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.ITableView;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.ITableViewFactory;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.TableViewException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TableViewTest {
    private static final String CLASS_NAME = TableViewTest.class.getSimpleName();
    private static final String BUNDLE_NAME = Activator.getDefault().getBundle().getSymbolicName();
    private static final String RSRCS_LOCATION = "resources/v0_2";
    private static final int TIMEOUT = 30000;
    private ITableWidgetInternal natTableWidget;

    @BeforeClass
    public static void beforeClass() {
        TestUtils.closeWelcomePage();
    }

    @Before
    public void initView() throws TableViewException {
        String uriStr = String.format("platform:/plugin/%s/%s/%s/tableTest.table", BUNDLE_NAME, RSRCS_LOCATION, CLASS_NAME);
        URI modelUri = URI.createURI((String)uriStr);
        ITableView tableView = ITableViewFactory.DEFAULT.openOn(modelUri);
        ITableWidget tableWidget = tableView.getTableWidget();
        Assert.assertThat((Object)tableWidget, (Matcher)CoreMatchers.instanceOf(ITableWidgetInternal.class));
        this.natTableWidget = (ITableWidgetInternal)tableWidget;
        Assert.assertNotNull((Object)this.natTableWidget);
    }

    @Test(timeout=30000L)
    public void openAndSelect() {
        Table table = this.natTableWidget.getTable();
        Row row = (Row)table.getRows().get(0);
        EObject element = row.getElement();
        Column column = (Column)table.getColumns().get(0);
        Assert.assertThat((Object)column, (Matcher)CoreMatchers.instanceOf(FeatureColumn.class));
        ETypedElement feature = ((FeatureColumn)column).getFeature();
        Assert.assertThat((Object)feature, (Matcher)CoreMatchers.instanceOf(EStructuralFeature.class));
        this.natTableWidget.selectCell(element, (EStructuralFeature)feature);
        ISelection selection = this.natTableWidget.getSelection();
        Assert.assertThat((Object)selection, (Matcher)CoreMatchers.instanceOf(IStructuredSelection.class));
        IStructuredSelection structSelect = (IStructuredSelection)selection;
        Assert.assertEquals((Object)element, (Object)structSelect.getFirstElement());
    }
}

