/**
 *  Copyright (c) 2011 Mia-Software.
 *  
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *  
 *  Contributors:
 * 	Gregoire Dupe (Mia-Software) - Design
 * 	Nicolas Guyomar (Mia-Software) - Implementation
 *  
 */
package org.eclipse.emf.facet.efacet.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.EAttributeImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

import org.eclipse.emf.facet.efacet.Category;
import org.eclipse.emf.facet.efacet.EFacetPackage;
import org.eclipse.emf.facet.efacet.Facet;
import org.eclipse.emf.facet.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.FacetElement;
import org.eclipse.emf.facet.efacet.Query;
import org.eclipse.emf.facet.efacet.QueryFacetElement;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Facet Attribute</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.emf.facet.efacet.impl.FacetAttributeImpl#getCategories <em>Categories</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.efacet.impl.FacetAttributeImpl#getFacet <em>Facet</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.efacet.impl.FacetAttributeImpl#getOverride <em>Override</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.efacet.impl.FacetAttributeImpl#getQuery <em>Query</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FacetAttributeImpl extends EAttributeImpl implements FacetAttribute {
	/**
	 * The cached value of the '{@link #getCategories() <em>Categories</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCategories()
	 * @generated
	 * @ordered
	 */
	protected EList<Category> categories;

	/**
	 * The cached value of the '{@link #getOverride() <em>Override</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOverride()
	 * @generated
	 * @ordered
	 */
	protected ETypedElement override;

	/**
	 * The cached value of the '{@link #getQuery() <em>Query</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQuery()
	 * @generated
	 * @ordered
	 */
	protected Query query;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FacetAttributeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return EFacetPackage.Literals.FACET_ATTRIBUTE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Category> getCategories() {
		if (categories == null) {
			categories = new EObjectResolvingEList<Category>(Category.class, this, EFacetPackage.FACET_ATTRIBUTE__CATEGORIES);
		}
		return categories;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Facet getFacet() {
		if (eContainerFeatureID() != EFacetPackage.FACET_ATTRIBUTE__FACET) return null;
		return (Facet)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFacet(Facet newFacet, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newFacet, EFacetPackage.FACET_ATTRIBUTE__FACET, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFacet(Facet newFacet) {
		if (newFacet != eInternalContainer() || (eContainerFeatureID() != EFacetPackage.FACET_ATTRIBUTE__FACET && newFacet != null)) {
			if (EcoreUtil.isAncestor(this, newFacet))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString()); //$NON-NLS-1$
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newFacet != null)
				msgs = ((InternalEObject)newFacet).eInverseAdd(this, EFacetPackage.FACET__FACET_ELEMENTS, Facet.class, msgs);
			msgs = basicSetFacet(newFacet, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EFacetPackage.FACET_ATTRIBUTE__FACET, newFacet, newFacet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ETypedElement getOverride() {
		if (override != null && override.eIsProxy()) {
			InternalEObject oldOverride = (InternalEObject)override;
			override = (ETypedElement)eResolveProxy(oldOverride);
			if (override != oldOverride) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EFacetPackage.FACET_ATTRIBUTE__OVERRIDE, oldOverride, override));
			}
		}
		return override;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ETypedElement basicGetOverride() {
		return override;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOverride(ETypedElement newOverride) {
		ETypedElement oldOverride = override;
		override = newOverride;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EFacetPackage.FACET_ATTRIBUTE__OVERRIDE, oldOverride, override));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Query getQuery() {
		return query;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetQuery(Query newQuery, NotificationChain msgs) {
		Query oldQuery = query;
		query = newQuery;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EFacetPackage.FACET_ATTRIBUTE__QUERY, oldQuery, newQuery);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setQuery(Query newQuery) {
		if (newQuery != query) {
			NotificationChain msgs = null;
			if (query != null)
				msgs = ((InternalEObject)query).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - EFacetPackage.FACET_ATTRIBUTE__QUERY, null, msgs);
			if (newQuery != null)
				msgs = ((InternalEObject)newQuery).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - EFacetPackage.FACET_ATTRIBUTE__QUERY, null, msgs);
			msgs = basicSetQuery(newQuery, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EFacetPackage.FACET_ATTRIBUTE__QUERY, newQuery, newQuery));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case EFacetPackage.FACET_ATTRIBUTE__FACET:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetFacet((Facet)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case EFacetPackage.FACET_ATTRIBUTE__FACET:
				return basicSetFacet(null, msgs);
			case EFacetPackage.FACET_ATTRIBUTE__QUERY:
				return basicSetQuery(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case EFacetPackage.FACET_ATTRIBUTE__FACET:
				return eInternalContainer().eInverseRemove(this, EFacetPackage.FACET__FACET_ELEMENTS, Facet.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case EFacetPackage.FACET_ATTRIBUTE__CATEGORIES:
				return getCategories();
			case EFacetPackage.FACET_ATTRIBUTE__FACET:
				return getFacet();
			case EFacetPackage.FACET_ATTRIBUTE__OVERRIDE:
				if (resolve) return getOverride();
				return basicGetOverride();
			case EFacetPackage.FACET_ATTRIBUTE__QUERY:
				return getQuery();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case EFacetPackage.FACET_ATTRIBUTE__CATEGORIES:
				getCategories().clear();
				getCategories().addAll((Collection<? extends Category>)newValue);
				return;
			case EFacetPackage.FACET_ATTRIBUTE__FACET:
				setFacet((Facet)newValue);
				return;
			case EFacetPackage.FACET_ATTRIBUTE__OVERRIDE:
				setOverride((ETypedElement)newValue);
				return;
			case EFacetPackage.FACET_ATTRIBUTE__QUERY:
				setQuery((Query)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case EFacetPackage.FACET_ATTRIBUTE__CATEGORIES:
				getCategories().clear();
				return;
			case EFacetPackage.FACET_ATTRIBUTE__FACET:
				setFacet((Facet)null);
				return;
			case EFacetPackage.FACET_ATTRIBUTE__OVERRIDE:
				setOverride((ETypedElement)null);
				return;
			case EFacetPackage.FACET_ATTRIBUTE__QUERY:
				setQuery((Query)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case EFacetPackage.FACET_ATTRIBUTE__CATEGORIES:
				return categories != null && !categories.isEmpty();
			case EFacetPackage.FACET_ATTRIBUTE__FACET:
				return getFacet() != null;
			case EFacetPackage.FACET_ATTRIBUTE__OVERRIDE:
				return override != null;
			case EFacetPackage.FACET_ATTRIBUTE__QUERY:
				return query != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == FacetElement.class) {
			switch (derivedFeatureID) {
				case EFacetPackage.FACET_ATTRIBUTE__CATEGORIES: return EFacetPackage.FACET_ELEMENT__CATEGORIES;
				case EFacetPackage.FACET_ATTRIBUTE__FACET: return EFacetPackage.FACET_ELEMENT__FACET;
				case EFacetPackage.FACET_ATTRIBUTE__OVERRIDE: return EFacetPackage.FACET_ELEMENT__OVERRIDE;
				default: return -1;
			}
		}
		if (baseClass == QueryFacetElement.class) {
			switch (derivedFeatureID) {
				case EFacetPackage.FACET_ATTRIBUTE__QUERY: return EFacetPackage.QUERY_FACET_ELEMENT__QUERY;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == FacetElement.class) {
			switch (baseFeatureID) {
				case EFacetPackage.FACET_ELEMENT__CATEGORIES: return EFacetPackage.FACET_ATTRIBUTE__CATEGORIES;
				case EFacetPackage.FACET_ELEMENT__FACET: return EFacetPackage.FACET_ATTRIBUTE__FACET;
				case EFacetPackage.FACET_ELEMENT__OVERRIDE: return EFacetPackage.FACET_ATTRIBUTE__OVERRIDE;
				default: return -1;
			}
		}
		if (baseClass == QueryFacetElement.class) {
			switch (baseFeatureID) {
				case EFacetPackage.QUERY_FACET_ELEMENT__QUERY: return EFacetPackage.FACET_ATTRIBUTE__QUERY;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

} //FacetAttributeImpl
