/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gregoire DUPE (Mia-Software)
 *******************************************************************************/
package org.eclipse.emf.facet.infra.common.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.common.core.internal.builder.AbstractEmfFacetCatalog;
import org.eclipse.emf.facet.infra.common.core.internal.builder.EcoreCatalog;
import org.eclipse.emf.facet.infra.common.ui.internal.Messages;
import org.eclipse.emf.facet.infra.common.ui.internal.util.ImageProvider;
import org.eclipse.emf.facet.util.emf.ui.internal.utils.ImageUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class GetEmfFacetResourceDialog extends ElementTreeSelectionDialog {

	protected static final String CATALOG_ICON_URL = "/icons/catalog.png"; //$NON-NLS-1$

	public GetEmfFacetResourceDialog(final Shell parent) {
		super(parent, createLabelProvider(), createContentProvider());
		setInput(AbstractEmfFacetCatalog.getCatalogs());
		setTitle(Messages.GetEmfFacetResourceDialog_loadEmfFacetResource);
	}

	private static ITreeContentProvider createContentProvider() {
		return new ITreeContentProvider() {
			public Object[] getChildren(final Object parentElement) {
				if (parentElement instanceof AbstractEmfFacetCatalog) {
					AbstractEmfFacetCatalog catalog = (AbstractEmfFacetCatalog) parentElement;
					return catalog.getAllRootObjects().toArray();
				}
				return new Object[] {};
			}

			public Object getParent(final Object element) {
				return null;
			}

			public boolean hasChildren(final Object element) {
				if (element instanceof List<?>) {
					List<?> objectList = (List<?>) element;
					List<AbstractEmfFacetCatalog> catalogList = new ArrayList<AbstractEmfFacetCatalog>();
					for (Object object : objectList) {
						if (object instanceof AbstractEmfFacetCatalog) {
							AbstractEmfFacetCatalog catalog = (AbstractEmfFacetCatalog) object;
							catalogList.add(catalog);
						}
					}
					return catalogList.size() > 0;
				} else if (element instanceof AbstractEmfFacetCatalog) {
					AbstractEmfFacetCatalog catalog = (AbstractEmfFacetCatalog) element;
					return catalog.getAllRootObjects().size() > 0;
				}
				return false;
			}

			public Object[] getElements(final Object inputElement) {
				if (inputElement == null) {
					return AbstractEmfFacetCatalog.getCatalogs().toArray();
				} else if (inputElement instanceof List<?>) {
					List<?> objectList = (List<?>) inputElement;
					List<AbstractEmfFacetCatalog> catalogList = new ArrayList<AbstractEmfFacetCatalog>();
					for (Object object : objectList) {
						if (object instanceof AbstractEmfFacetCatalog) {
							if (!(object instanceof EcoreCatalog)) {
								AbstractEmfFacetCatalog catalog = (AbstractEmfFacetCatalog) object;
								catalogList.add(catalog);
							}
						}
					}
					return catalogList.toArray(new AbstractEmfFacetCatalog[catalogList.size()]);
				}
				return null;
			}

			public void dispose() {
				// Nothing to do
			}

			public void inputChanged(final Viewer viewer, final Object oldInput,
					final Object newInput) {
				// Nothing to do
			}

		};
	}

	private static ILabelProvider createLabelProvider() {
		return new LabelProvider() {
			
			@Override
			public boolean isLabelProperty(final Object element, final String property) {
				if (element instanceof AbstractEmfFacetCatalog) {
					return true;
				} else if (element instanceof EObject) {
					return true;
				}
				return false;
			}

			@Override
			public String getText(final Object element) {
				if (element instanceof AbstractEmfFacetCatalog) {
					AbstractEmfFacetCatalog catalog = (AbstractEmfFacetCatalog) element;
					return catalog.getClass().getSimpleName();
				} else if (element instanceof EObject) {
					EObject eObject = (EObject) element;
					for (EAttribute eAttribute : eObject.eClass().getEAttributes()) {
						if (eAttribute.getName().equals("name")) { //$NON-NLS-1$
							return eObject.eGet(eAttribute).toString();
						}
					}
				}
				return ""; //$NON-NLS-1$
			}

			@Override
			public Image getImage(final Object element) {
				if (element instanceof AbstractEmfFacetCatalog) {
					return ImageProvider.getInstance().getCatalogIcon();
				}
				return ImageUtils.getImage(element);
			}
		};
	}

}
