/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.facet.editor.presentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.facet.infra.common.core.internal.utils.BuildPropertiesUtils;
import org.eclipse.emf.facet.infra.common.core.internal.utils.PluginUtils;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ProjectUtils;
import org.eclipse.emf.facet.infra.facet.FacetFactory;
import org.eclipse.emf.facet.infra.facet.FacetPackage;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.editor.Messages;
import org.eclipse.emf.facet.infra.facet.editor.presentation.FacetEditorPlugin;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetModelWizard
extends Wizard
implements INewWizard {
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(FacetEditorPlugin.INSTANCE.getString("_UI_FacetEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = FacetEditorPlugin.INSTANCE.getString("_UI_FacetEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected FacetPackage facetPackage = FacetPackage.eINSTANCE;
    protected FacetFactory facetFactory = this.facetPackage.getFacetFactory();
    protected FacetModelWizardNewFileCreationPage newFileCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(FacetEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(FacetEditorPlugin.INSTANCE.getImage("full/wizban/NewFacet")));
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            for (EClassifier eClassifier : this.facetPackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eClass.getName());
            }
            Collections.sort(this.initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        }
        return this.initialObjectNames;
    }

    protected EObject createInitialModel() {
        FacetSet rootObject = this.facetFactory.createFacetSet();
        String modelFacetSetName = this.getModelFile().getName().replaceAll(".facetSet$", "");
        rootObject.setName(modelFacetSetName);
        return rootObject;
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = FacetModelWizard.this.createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            resource.save(null);
                            try {
                                BuildPropertiesUtils.addToBuild((IFile)modelFile);
                            }
                            catch (Exception e) {
                                Logger.logError((Throwable)e, (String)("Error adding file " + modelFile.getFullPath() + " to the build.properties"), (Plugin)FacetEditorPlugin.getPlugin());
                            }
                            PluginUtils.register((IFile)modelFile, (String)"org.eclipse.emf.facet.infra.facet.registration", (String)"facetset");
                        }
                        catch (Exception exception) {
                            FacetEditorPlugin.INSTANCE.log(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)FacetEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            FacetEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new FacetModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(FacetEditorPlugin.INSTANCE.getString("_UI_FacetModelWizard_label"));
        this.newFileCreationPage.setDescription(FacetEditorPlugin.INSTANCE.getString("_UI_FacetModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(FacetEditorPlugin.INSTANCE.getString("_UI_FacetEditorFilenameDefaultBase")) + "." + FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = FacetEditorPlugin.INSTANCE.getString("_UI_FacetEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = FILE_EXTENSIONS.get(0);
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public class FacetModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public FacetModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.validatePage();
        }

        protected boolean validatePage() {
            IPath containerFullPath;
            String extension;
            boolean valid;
            try {
                valid = super.validatePage();
            }
            catch (NullPointerException e) {
                valid = false;
            }
            if (valid && ((extension = new Path(this.getFileName()).getFileExtension()) == null || !FILE_EXTENSIONS.contains(extension))) {
                String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                this.setErrorMessage(FacetEditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                valid = false;
            }
            if (valid && !ProjectUtils.isInEmfFacetProject((IPath)(containerFullPath = this.getContainerFullPath()))) {
                this.setMessage(Messages.FacetModelWizard_facetInNonEmfFacetProject, 2);
            }
            return valid;
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

