/**
 * Copyright (c) 2010 CEA LIST
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nicolas Guyomar (Mia-Software) - design and implementation
 *     Gregoire DUPE (Mia-Software) - design and implementation
 * 
 */
package org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl;

import java.math.BigDecimal;
import java.math.BigInteger;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1;
import org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class2;
import org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Enum1;
import org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.SamplemmPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Class1</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEIntAttr <em>EInt Attr</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEInObjectAtt <em>EIn Object Att</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEStringAttr <em>EString Attr</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEnum1Att <em>Enum1 Att</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getMultiRef <em>Multi Ref</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEFloatAtt <em>EFloat Att</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEFloatObjectAtt <em>EFloat Object Att</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#isEBooleanAttr <em>EBoolean Attr</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEBooleanObjectAttr <em>EBoolean Object Attr</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getECharAttr <em>EChar Attr</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEcharObjectAttr <em>Echar Object Attr</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEDoubleAttr <em>EDouble Attr</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEdoubleObjectAttr <em>Edouble Object Attr</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEBigDecimalAtt <em>EBig Decimal Att</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEBigIntegerAtt <em>EBig Integer Att</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getELongAtt <em>ELong Att</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getELongObjectAtt <em>ELong Object Att</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEShortAttr <em>EShort Attr</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEShortObjectAttr <em>EShort Object Attr</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEByteAttr <em>EByte Attr</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEByteAttrObject <em>EByte Attr Object</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getUnaryReference <em>Unary Reference</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getNaryReference <em>Nary Reference</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getNaryReference_notUnique <em>Nary Reference not Unique</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getUnaryContainmentReference <em>Unary Containment Reference</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getNaryContainmentReference <em>Nary Containment Reference</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getEIntMultiAttr <em>EInt Multi Attr</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl#getStrings <em>Strings</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class Class1Impl extends EObjectImpl implements Class1 {
	/**
	 * The default value of the '{@link #getEIntAttr() <em>EInt Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEIntAttr()
	 * @generated
	 * @ordered
	 */
	protected static final int EINT_ATTR_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getEIntAttr() <em>EInt Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEIntAttr()
	 * @generated
	 * @ordered
	 */
	protected int eIntAttr = EINT_ATTR_EDEFAULT;

	/**
	 * The default value of the '{@link #getEInObjectAtt() <em>EIn Object Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEInObjectAtt()
	 * @generated
	 * @ordered
	 */
	protected static final Integer EIN_OBJECT_ATT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEInObjectAtt() <em>EIn Object Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEInObjectAtt()
	 * @generated
	 * @ordered
	 */
	protected Integer eInObjectAtt = EIN_OBJECT_ATT_EDEFAULT;

	/**
	 * The default value of the '{@link #getEStringAttr() <em>EString Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEStringAttr()
	 * @generated
	 * @ordered
	 */
	protected static final String ESTRING_ATTR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEStringAttr() <em>EString Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEStringAttr()
	 * @generated
	 * @ordered
	 */
	protected String eStringAttr = ESTRING_ATTR_EDEFAULT;

	/**
	 * The default value of the '{@link #getEnum1Att() <em>Enum1 Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnum1Att()
	 * @generated
	 * @ordered
	 */
	protected static final Enum1 ENUM1_ATT_EDEFAULT = Enum1.LIT1;

	/**
	 * The cached value of the '{@link #getEnum1Att() <em>Enum1 Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnum1Att()
	 * @generated
	 * @ordered
	 */
	protected Enum1 enum1Att = ENUM1_ATT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMultiRef() <em>Multi Ref</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMultiRef()
	 * @generated
	 * @ordered
	 */
	protected EList<Class1> multiRef;

	/**
	 * The default value of the '{@link #getEFloatAtt() <em>EFloat Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEFloatAtt()
	 * @generated
	 * @ordered
	 */
	protected static final float EFLOAT_ATT_EDEFAULT = 0.0F;

	/**
	 * The cached value of the '{@link #getEFloatAtt() <em>EFloat Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEFloatAtt()
	 * @generated
	 * @ordered
	 */
	protected float eFloatAtt = EFLOAT_ATT_EDEFAULT;

	/**
	 * The default value of the '{@link #getEFloatObjectAtt() <em>EFloat Object Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEFloatObjectAtt()
	 * @generated
	 * @ordered
	 */
	protected static final Float EFLOAT_OBJECT_ATT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEFloatObjectAtt() <em>EFloat Object Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEFloatObjectAtt()
	 * @generated
	 * @ordered
	 */
	protected Float eFloatObjectAtt = EFLOAT_OBJECT_ATT_EDEFAULT;

	/**
	 * The default value of the '{@link #isEBooleanAttr() <em>EBoolean Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEBooleanAttr()
	 * @generated
	 * @ordered
	 */
	protected static final boolean EBOOLEAN_ATTR_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isEBooleanAttr() <em>EBoolean Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEBooleanAttr()
	 * @generated
	 * @ordered
	 */
	protected boolean eBooleanAttr = EBOOLEAN_ATTR_EDEFAULT;

	/**
	 * The default value of the '{@link #getEBooleanObjectAttr() <em>EBoolean Object Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEBooleanObjectAttr()
	 * @generated
	 * @ordered
	 */
	protected static final Boolean EBOOLEAN_OBJECT_ATTR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEBooleanObjectAttr() <em>EBoolean Object Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEBooleanObjectAttr()
	 * @generated
	 * @ordered
	 */
	protected Boolean eBooleanObjectAttr = EBOOLEAN_OBJECT_ATTR_EDEFAULT;

	/**
	 * The default value of the '{@link #getECharAttr() <em>EChar Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getECharAttr()
	 * @generated
	 * @ordered
	 */
	protected static final char ECHAR_ATTR_EDEFAULT = '\u0000';

	/**
	 * The cached value of the '{@link #getECharAttr() <em>EChar Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getECharAttr()
	 * @generated
	 * @ordered
	 */
	protected char eCharAttr = ECHAR_ATTR_EDEFAULT;

	/**
	 * The default value of the '{@link #getEcharObjectAttr() <em>Echar Object Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEcharObjectAttr()
	 * @generated
	 * @ordered
	 */
	protected static final Character ECHAR_OBJECT_ATTR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEcharObjectAttr() <em>Echar Object Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEcharObjectAttr()
	 * @generated
	 * @ordered
	 */
	protected Character echarObjectAttr = ECHAR_OBJECT_ATTR_EDEFAULT;

	/**
	 * The default value of the '{@link #getEDoubleAttr() <em>EDouble Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEDoubleAttr()
	 * @generated
	 * @ordered
	 */
	protected static final double EDOUBLE_ATTR_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getEDoubleAttr() <em>EDouble Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEDoubleAttr()
	 * @generated
	 * @ordered
	 */
	protected double eDoubleAttr = EDOUBLE_ATTR_EDEFAULT;

	/**
	 * The default value of the '{@link #getEdoubleObjectAttr() <em>Edouble Object Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEdoubleObjectAttr()
	 * @generated
	 * @ordered
	 */
	protected static final Double EDOUBLE_OBJECT_ATTR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEdoubleObjectAttr() <em>Edouble Object Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEdoubleObjectAttr()
	 * @generated
	 * @ordered
	 */
	protected Double edoubleObjectAttr = EDOUBLE_OBJECT_ATTR_EDEFAULT;

	/**
	 * The default value of the '{@link #getEBigDecimalAtt() <em>EBig Decimal Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEBigDecimalAtt()
	 * @generated
	 * @ordered
	 */
	protected static final BigDecimal EBIG_DECIMAL_ATT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEBigDecimalAtt() <em>EBig Decimal Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEBigDecimalAtt()
	 * @generated
	 * @ordered
	 */
	protected BigDecimal eBigDecimalAtt = EBIG_DECIMAL_ATT_EDEFAULT;

	/**
	 * The default value of the '{@link #getEBigIntegerAtt() <em>EBig Integer Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEBigIntegerAtt()
	 * @generated
	 * @ordered
	 */
	protected static final BigInteger EBIG_INTEGER_ATT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEBigIntegerAtt() <em>EBig Integer Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEBigIntegerAtt()
	 * @generated
	 * @ordered
	 */
	protected BigInteger eBigIntegerAtt = EBIG_INTEGER_ATT_EDEFAULT;

	/**
	 * The default value of the '{@link #getELongAtt() <em>ELong Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getELongAtt()
	 * @generated
	 * @ordered
	 */
	protected static final long ELONG_ATT_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getELongAtt() <em>ELong Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getELongAtt()
	 * @generated
	 * @ordered
	 */
	protected long eLongAtt = ELONG_ATT_EDEFAULT;

	/**
	 * The default value of the '{@link #getELongObjectAtt() <em>ELong Object Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getELongObjectAtt()
	 * @generated
	 * @ordered
	 */
	protected static final Long ELONG_OBJECT_ATT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getELongObjectAtt() <em>ELong Object Att</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getELongObjectAtt()
	 * @generated
	 * @ordered
	 */
	protected Long eLongObjectAtt = ELONG_OBJECT_ATT_EDEFAULT;

	/**
	 * The default value of the '{@link #getEShortAttr() <em>EShort Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEShortAttr()
	 * @generated
	 * @ordered
	 */
	protected static final short ESHORT_ATTR_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getEShortAttr() <em>EShort Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEShortAttr()
	 * @generated
	 * @ordered
	 */
	protected short eShortAttr = ESHORT_ATTR_EDEFAULT;

	/**
	 * The default value of the '{@link #getEShortObjectAttr() <em>EShort Object Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEShortObjectAttr()
	 * @generated
	 * @ordered
	 */
	protected static final Short ESHORT_OBJECT_ATTR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEShortObjectAttr() <em>EShort Object Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEShortObjectAttr()
	 * @generated
	 * @ordered
	 */
	protected Short eShortObjectAttr = ESHORT_OBJECT_ATTR_EDEFAULT;

	/**
	 * The default value of the '{@link #getEByteAttr() <em>EByte Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEByteAttr()
	 * @generated
	 * @ordered
	 */
	protected static final byte EBYTE_ATTR_EDEFAULT = 0x00;

	/**
	 * The cached value of the '{@link #getEByteAttr() <em>EByte Attr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEByteAttr()
	 * @generated
	 * @ordered
	 */
	protected byte eByteAttr = EBYTE_ATTR_EDEFAULT;

	/**
	 * The default value of the '{@link #getEByteAttrObject() <em>EByte Attr Object</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEByteAttrObject()
	 * @generated
	 * @ordered
	 */
	protected static final Byte EBYTE_ATTR_OBJECT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEByteAttrObject() <em>EByte Attr Object</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEByteAttrObject()
	 * @generated
	 * @ordered
	 */
	protected Byte eByteAttrObject = EBYTE_ATTR_OBJECT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getUnaryReference() <em>Unary Reference</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUnaryReference()
	 * @generated
	 * @ordered
	 */
	protected Class2 unaryReference;

	/**
	 * The cached value of the '{@link #getNaryReference() <em>Nary Reference</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNaryReference()
	 * @generated
	 * @ordered
	 */
	protected EList<Class2> naryReference;

	/**
	 * The cached value of the '{@link #getNaryReference_notUnique() <em>Nary Reference not Unique</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNaryReference_notUnique()
	 * @generated
	 * @ordered
	 */
	protected EList<Class2> naryReference_notUnique;

	/**
	 * The cached value of the '{@link #getUnaryContainmentReference() <em>Unary Containment Reference</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUnaryContainmentReference()
	 * @generated
	 * @ordered
	 */
	protected Class2 unaryContainmentReference;

	/**
	 * The cached value of the '{@link #getNaryContainmentReference() <em>Nary Containment Reference</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNaryContainmentReference()
	 * @generated
	 * @ordered
	 */
	protected EList<Class2> naryContainmentReference;

	/**
	 * The cached value of the '{@link #getEIntMultiAttr() <em>EInt Multi Attr</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEIntMultiAttr()
	 * @generated
	 * @ordered
	 */
	protected EList<Integer> eIntMultiAttr;

	/**
	 * The cached value of the '{@link #getStrings() <em>Strings</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStrings()
	 * @generated
	 * @ordered
	 */
	protected EList<String> strings;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Class1Impl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SamplemmPackage.Literals.CLASS1;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getEIntAttr() {
		return eIntAttr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEIntAttr(int newEIntAttr) {
		int oldEIntAttr = eIntAttr;
		eIntAttr = newEIntAttr;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__EINT_ATTR, oldEIntAttr, eIntAttr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Integer getEInObjectAtt() {
		return eInObjectAtt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEInObjectAtt(Integer newEInObjectAtt) {
		Integer oldEInObjectAtt = eInObjectAtt;
		eInObjectAtt = newEInObjectAtt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__EIN_OBJECT_ATT, oldEInObjectAtt, eInObjectAtt));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getEStringAttr() {
		return eStringAttr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEStringAttr(String newEStringAttr) {
		String oldEStringAttr = eStringAttr;
		eStringAttr = newEStringAttr;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__ESTRING_ATTR, oldEStringAttr, eStringAttr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Enum1 getEnum1Att() {
		return enum1Att;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnum1Att(Enum1 newEnum1Att) {
		Enum1 oldEnum1Att = enum1Att;
		enum1Att = newEnum1Att == null ? ENUM1_ATT_EDEFAULT : newEnum1Att;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__ENUM1_ATT, oldEnum1Att, enum1Att));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Class1> getMultiRef() {
		if (multiRef == null) {
			multiRef = new EObjectContainmentEList<Class1>(Class1.class, this, SamplemmPackage.CLASS1__MULTI_REF);
		}
		return multiRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public float getEFloatAtt() {
		return eFloatAtt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEFloatAtt(float newEFloatAtt) {
		float oldEFloatAtt = eFloatAtt;
		eFloatAtt = newEFloatAtt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__EFLOAT_ATT, oldEFloatAtt, eFloatAtt));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Float getEFloatObjectAtt() {
		return eFloatObjectAtt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEFloatObjectAtt(Float newEFloatObjectAtt) {
		Float oldEFloatObjectAtt = eFloatObjectAtt;
		eFloatObjectAtt = newEFloatObjectAtt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__EFLOAT_OBJECT_ATT, oldEFloatObjectAtt, eFloatObjectAtt));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isEBooleanAttr() {
		return eBooleanAttr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEBooleanAttr(boolean newEBooleanAttr) {
		boolean oldEBooleanAttr = eBooleanAttr;
		eBooleanAttr = newEBooleanAttr;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__EBOOLEAN_ATTR, oldEBooleanAttr, eBooleanAttr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Boolean getEBooleanObjectAttr() {
		return eBooleanObjectAttr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEBooleanObjectAttr(Boolean newEBooleanObjectAttr) {
		Boolean oldEBooleanObjectAttr = eBooleanObjectAttr;
		eBooleanObjectAttr = newEBooleanObjectAttr;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__EBOOLEAN_OBJECT_ATTR, oldEBooleanObjectAttr, eBooleanObjectAttr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public char getECharAttr() {
		return eCharAttr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setECharAttr(char newECharAttr) {
		char oldECharAttr = eCharAttr;
		eCharAttr = newECharAttr;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__ECHAR_ATTR, oldECharAttr, eCharAttr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Character getEcharObjectAttr() {
		return echarObjectAttr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEcharObjectAttr(Character newEcharObjectAttr) {
		Character oldEcharObjectAttr = echarObjectAttr;
		echarObjectAttr = newEcharObjectAttr;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__ECHAR_OBJECT_ATTR, oldEcharObjectAttr, echarObjectAttr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getEDoubleAttr() {
		return eDoubleAttr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEDoubleAttr(double newEDoubleAttr) {
		double oldEDoubleAttr = eDoubleAttr;
		eDoubleAttr = newEDoubleAttr;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__EDOUBLE_ATTR, oldEDoubleAttr, eDoubleAttr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Double getEdoubleObjectAttr() {
		return edoubleObjectAttr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEdoubleObjectAttr(Double newEdoubleObjectAttr) {
		Double oldEdoubleObjectAttr = edoubleObjectAttr;
		edoubleObjectAttr = newEdoubleObjectAttr;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__EDOUBLE_OBJECT_ATTR, oldEdoubleObjectAttr, edoubleObjectAttr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BigDecimal getEBigDecimalAtt() {
		return eBigDecimalAtt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEBigDecimalAtt(BigDecimal newEBigDecimalAtt) {
		BigDecimal oldEBigDecimalAtt = eBigDecimalAtt;
		eBigDecimalAtt = newEBigDecimalAtt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__EBIG_DECIMAL_ATT, oldEBigDecimalAtt, eBigDecimalAtt));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BigInteger getEBigIntegerAtt() {
		return eBigIntegerAtt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEBigIntegerAtt(BigInteger newEBigIntegerAtt) {
		BigInteger oldEBigIntegerAtt = eBigIntegerAtt;
		eBigIntegerAtt = newEBigIntegerAtt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__EBIG_INTEGER_ATT, oldEBigIntegerAtt, eBigIntegerAtt));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getELongAtt() {
		return eLongAtt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setELongAtt(long newELongAtt) {
		long oldELongAtt = eLongAtt;
		eLongAtt = newELongAtt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__ELONG_ATT, oldELongAtt, eLongAtt));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Long getELongObjectAtt() {
		return eLongObjectAtt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setELongObjectAtt(Long newELongObjectAtt) {
		Long oldELongObjectAtt = eLongObjectAtt;
		eLongObjectAtt = newELongObjectAtt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__ELONG_OBJECT_ATT, oldELongObjectAtt, eLongObjectAtt));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getEShortAttr() {
		return eShortAttr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEShortAttr(short newEShortAttr) {
		short oldEShortAttr = eShortAttr;
		eShortAttr = newEShortAttr;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__ESHORT_ATTR, oldEShortAttr, eShortAttr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Short getEShortObjectAttr() {
		return eShortObjectAttr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEShortObjectAttr(Short newEShortObjectAttr) {
		Short oldEShortObjectAttr = eShortObjectAttr;
		eShortObjectAttr = newEShortObjectAttr;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__ESHORT_OBJECT_ATTR, oldEShortObjectAttr, eShortObjectAttr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public byte getEByteAttr() {
		return eByteAttr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEByteAttr(byte newEByteAttr) {
		byte oldEByteAttr = eByteAttr;
		eByteAttr = newEByteAttr;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__EBYTE_ATTR, oldEByteAttr, eByteAttr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Byte getEByteAttrObject() {
		return eByteAttrObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEByteAttrObject(Byte newEByteAttrObject) {
		Byte oldEByteAttrObject = eByteAttrObject;
		eByteAttrObject = newEByteAttrObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__EBYTE_ATTR_OBJECT, oldEByteAttrObject, eByteAttrObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Class2 getUnaryReference() {
		if (unaryReference != null && unaryReference.eIsProxy()) {
			InternalEObject oldUnaryReference = (InternalEObject)unaryReference;
			unaryReference = (Class2)eResolveProxy(oldUnaryReference);
			if (unaryReference != oldUnaryReference) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SamplemmPackage.CLASS1__UNARY_REFERENCE, oldUnaryReference, unaryReference));
			}
		}
		return unaryReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Class2 basicGetUnaryReference() {
		return unaryReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUnaryReference(Class2 newUnaryReference) {
		Class2 oldUnaryReference = unaryReference;
		unaryReference = newUnaryReference;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__UNARY_REFERENCE, oldUnaryReference, unaryReference));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Class2> getNaryReference() {
		if (naryReference == null) {
			naryReference = new EObjectResolvingEList<Class2>(Class2.class, this, SamplemmPackage.CLASS1__NARY_REFERENCE);
		}
		return naryReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Class2> getNaryReference_notUnique() {
		if (naryReference_notUnique == null) {
			naryReference_notUnique = new EObjectResolvingEList<Class2>(Class2.class, this, SamplemmPackage.CLASS1__NARY_REFERENCE_NOT_UNIQUE);
		}
		return naryReference_notUnique;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Class2 getUnaryContainmentReference() {
		return unaryContainmentReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetUnaryContainmentReference(Class2 newUnaryContainmentReference, NotificationChain msgs) {
		Class2 oldUnaryContainmentReference = unaryContainmentReference;
		unaryContainmentReference = newUnaryContainmentReference;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__UNARY_CONTAINMENT_REFERENCE, oldUnaryContainmentReference, newUnaryContainmentReference);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUnaryContainmentReference(Class2 newUnaryContainmentReference) {
		if (newUnaryContainmentReference != unaryContainmentReference) {
			NotificationChain msgs = null;
			if (unaryContainmentReference != null)
				msgs = ((InternalEObject)unaryContainmentReference).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SamplemmPackage.CLASS1__UNARY_CONTAINMENT_REFERENCE, null, msgs);
			if (newUnaryContainmentReference != null)
				msgs = ((InternalEObject)newUnaryContainmentReference).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SamplemmPackage.CLASS1__UNARY_CONTAINMENT_REFERENCE, null, msgs);
			msgs = basicSetUnaryContainmentReference(newUnaryContainmentReference, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SamplemmPackage.CLASS1__UNARY_CONTAINMENT_REFERENCE, newUnaryContainmentReference, newUnaryContainmentReference));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Class2> getNaryContainmentReference() {
		if (naryContainmentReference == null) {
			naryContainmentReference = new EObjectContainmentEList<Class2>(Class2.class, this, SamplemmPackage.CLASS1__NARY_CONTAINMENT_REFERENCE);
		}
		return naryContainmentReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Integer> getEIntMultiAttr() {
		if (eIntMultiAttr == null) {
			eIntMultiAttr = new EDataTypeUniqueEList<Integer>(Integer.class, this, SamplemmPackage.CLASS1__EINT_MULTI_ATTR);
		}
		return eIntMultiAttr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<String> getStrings() {
		if (strings == null) {
			strings = new EDataTypeUniqueEList<String>(String.class, this, SamplemmPackage.CLASS1__STRINGS);
		}
		return strings;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SamplemmPackage.CLASS1__MULTI_REF:
				return ((InternalEList<?>)getMultiRef()).basicRemove(otherEnd, msgs);
			case SamplemmPackage.CLASS1__UNARY_CONTAINMENT_REFERENCE:
				return basicSetUnaryContainmentReference(null, msgs);
			case SamplemmPackage.CLASS1__NARY_CONTAINMENT_REFERENCE:
				return ((InternalEList<?>)getNaryContainmentReference()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SamplemmPackage.CLASS1__EINT_ATTR:
				return getEIntAttr();
			case SamplemmPackage.CLASS1__EIN_OBJECT_ATT:
				return getEInObjectAtt();
			case SamplemmPackage.CLASS1__ESTRING_ATTR:
				return getEStringAttr();
			case SamplemmPackage.CLASS1__ENUM1_ATT:
				return getEnum1Att();
			case SamplemmPackage.CLASS1__MULTI_REF:
				return getMultiRef();
			case SamplemmPackage.CLASS1__EFLOAT_ATT:
				return getEFloatAtt();
			case SamplemmPackage.CLASS1__EFLOAT_OBJECT_ATT:
				return getEFloatObjectAtt();
			case SamplemmPackage.CLASS1__EBOOLEAN_ATTR:
				return isEBooleanAttr();
			case SamplemmPackage.CLASS1__EBOOLEAN_OBJECT_ATTR:
				return getEBooleanObjectAttr();
			case SamplemmPackage.CLASS1__ECHAR_ATTR:
				return getECharAttr();
			case SamplemmPackage.CLASS1__ECHAR_OBJECT_ATTR:
				return getEcharObjectAttr();
			case SamplemmPackage.CLASS1__EDOUBLE_ATTR:
				return getEDoubleAttr();
			case SamplemmPackage.CLASS1__EDOUBLE_OBJECT_ATTR:
				return getEdoubleObjectAttr();
			case SamplemmPackage.CLASS1__EBIG_DECIMAL_ATT:
				return getEBigDecimalAtt();
			case SamplemmPackage.CLASS1__EBIG_INTEGER_ATT:
				return getEBigIntegerAtt();
			case SamplemmPackage.CLASS1__ELONG_ATT:
				return getELongAtt();
			case SamplemmPackage.CLASS1__ELONG_OBJECT_ATT:
				return getELongObjectAtt();
			case SamplemmPackage.CLASS1__ESHORT_ATTR:
				return getEShortAttr();
			case SamplemmPackage.CLASS1__ESHORT_OBJECT_ATTR:
				return getEShortObjectAttr();
			case SamplemmPackage.CLASS1__EBYTE_ATTR:
				return getEByteAttr();
			case SamplemmPackage.CLASS1__EBYTE_ATTR_OBJECT:
				return getEByteAttrObject();
			case SamplemmPackage.CLASS1__UNARY_REFERENCE:
				if (resolve) return getUnaryReference();
				return basicGetUnaryReference();
			case SamplemmPackage.CLASS1__NARY_REFERENCE:
				return getNaryReference();
			case SamplemmPackage.CLASS1__NARY_REFERENCE_NOT_UNIQUE:
				return getNaryReference_notUnique();
			case SamplemmPackage.CLASS1__UNARY_CONTAINMENT_REFERENCE:
				return getUnaryContainmentReference();
			case SamplemmPackage.CLASS1__NARY_CONTAINMENT_REFERENCE:
				return getNaryContainmentReference();
			case SamplemmPackage.CLASS1__EINT_MULTI_ATTR:
				return getEIntMultiAttr();
			case SamplemmPackage.CLASS1__STRINGS:
				return getStrings();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SamplemmPackage.CLASS1__EINT_ATTR:
				setEIntAttr((Integer)newValue);
				return;
			case SamplemmPackage.CLASS1__EIN_OBJECT_ATT:
				setEInObjectAtt((Integer)newValue);
				return;
			case SamplemmPackage.CLASS1__ESTRING_ATTR:
				setEStringAttr((String)newValue);
				return;
			case SamplemmPackage.CLASS1__ENUM1_ATT:
				setEnum1Att((Enum1)newValue);
				return;
			case SamplemmPackage.CLASS1__MULTI_REF:
				getMultiRef().clear();
				getMultiRef().addAll((Collection<? extends Class1>)newValue);
				return;
			case SamplemmPackage.CLASS1__EFLOAT_ATT:
				setEFloatAtt((Float)newValue);
				return;
			case SamplemmPackage.CLASS1__EFLOAT_OBJECT_ATT:
				setEFloatObjectAtt((Float)newValue);
				return;
			case SamplemmPackage.CLASS1__EBOOLEAN_ATTR:
				setEBooleanAttr((Boolean)newValue);
				return;
			case SamplemmPackage.CLASS1__EBOOLEAN_OBJECT_ATTR:
				setEBooleanObjectAttr((Boolean)newValue);
				return;
			case SamplemmPackage.CLASS1__ECHAR_ATTR:
				setECharAttr((Character)newValue);
				return;
			case SamplemmPackage.CLASS1__ECHAR_OBJECT_ATTR:
				setEcharObjectAttr((Character)newValue);
				return;
			case SamplemmPackage.CLASS1__EDOUBLE_ATTR:
				setEDoubleAttr((Double)newValue);
				return;
			case SamplemmPackage.CLASS1__EDOUBLE_OBJECT_ATTR:
				setEdoubleObjectAttr((Double)newValue);
				return;
			case SamplemmPackage.CLASS1__EBIG_DECIMAL_ATT:
				setEBigDecimalAtt((BigDecimal)newValue);
				return;
			case SamplemmPackage.CLASS1__EBIG_INTEGER_ATT:
				setEBigIntegerAtt((BigInteger)newValue);
				return;
			case SamplemmPackage.CLASS1__ELONG_ATT:
				setELongAtt((Long)newValue);
				return;
			case SamplemmPackage.CLASS1__ELONG_OBJECT_ATT:
				setELongObjectAtt((Long)newValue);
				return;
			case SamplemmPackage.CLASS1__ESHORT_ATTR:
				setEShortAttr((Short)newValue);
				return;
			case SamplemmPackage.CLASS1__ESHORT_OBJECT_ATTR:
				setEShortObjectAttr((Short)newValue);
				return;
			case SamplemmPackage.CLASS1__EBYTE_ATTR:
				setEByteAttr((Byte)newValue);
				return;
			case SamplemmPackage.CLASS1__EBYTE_ATTR_OBJECT:
				setEByteAttrObject((Byte)newValue);
				return;
			case SamplemmPackage.CLASS1__UNARY_REFERENCE:
				setUnaryReference((Class2)newValue);
				return;
			case SamplemmPackage.CLASS1__NARY_REFERENCE:
				getNaryReference().clear();
				getNaryReference().addAll((Collection<? extends Class2>)newValue);
				return;
			case SamplemmPackage.CLASS1__NARY_REFERENCE_NOT_UNIQUE:
				getNaryReference_notUnique().clear();
				getNaryReference_notUnique().addAll((Collection<? extends Class2>)newValue);
				return;
			case SamplemmPackage.CLASS1__UNARY_CONTAINMENT_REFERENCE:
				setUnaryContainmentReference((Class2)newValue);
				return;
			case SamplemmPackage.CLASS1__NARY_CONTAINMENT_REFERENCE:
				getNaryContainmentReference().clear();
				getNaryContainmentReference().addAll((Collection<? extends Class2>)newValue);
				return;
			case SamplemmPackage.CLASS1__EINT_MULTI_ATTR:
				getEIntMultiAttr().clear();
				getEIntMultiAttr().addAll((Collection<? extends Integer>)newValue);
				return;
			case SamplemmPackage.CLASS1__STRINGS:
				getStrings().clear();
				getStrings().addAll((Collection<? extends String>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SamplemmPackage.CLASS1__EINT_ATTR:
				setEIntAttr(EINT_ATTR_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__EIN_OBJECT_ATT:
				setEInObjectAtt(EIN_OBJECT_ATT_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__ESTRING_ATTR:
				setEStringAttr(ESTRING_ATTR_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__ENUM1_ATT:
				setEnum1Att(ENUM1_ATT_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__MULTI_REF:
				getMultiRef().clear();
				return;
			case SamplemmPackage.CLASS1__EFLOAT_ATT:
				setEFloatAtt(EFLOAT_ATT_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__EFLOAT_OBJECT_ATT:
				setEFloatObjectAtt(EFLOAT_OBJECT_ATT_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__EBOOLEAN_ATTR:
				setEBooleanAttr(EBOOLEAN_ATTR_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__EBOOLEAN_OBJECT_ATTR:
				setEBooleanObjectAttr(EBOOLEAN_OBJECT_ATTR_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__ECHAR_ATTR:
				setECharAttr(ECHAR_ATTR_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__ECHAR_OBJECT_ATTR:
				setEcharObjectAttr(ECHAR_OBJECT_ATTR_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__EDOUBLE_ATTR:
				setEDoubleAttr(EDOUBLE_ATTR_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__EDOUBLE_OBJECT_ATTR:
				setEdoubleObjectAttr(EDOUBLE_OBJECT_ATTR_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__EBIG_DECIMAL_ATT:
				setEBigDecimalAtt(EBIG_DECIMAL_ATT_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__EBIG_INTEGER_ATT:
				setEBigIntegerAtt(EBIG_INTEGER_ATT_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__ELONG_ATT:
				setELongAtt(ELONG_ATT_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__ELONG_OBJECT_ATT:
				setELongObjectAtt(ELONG_OBJECT_ATT_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__ESHORT_ATTR:
				setEShortAttr(ESHORT_ATTR_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__ESHORT_OBJECT_ATTR:
				setEShortObjectAttr(ESHORT_OBJECT_ATTR_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__EBYTE_ATTR:
				setEByteAttr(EBYTE_ATTR_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__EBYTE_ATTR_OBJECT:
				setEByteAttrObject(EBYTE_ATTR_OBJECT_EDEFAULT);
				return;
			case SamplemmPackage.CLASS1__UNARY_REFERENCE:
				setUnaryReference((Class2)null);
				return;
			case SamplemmPackage.CLASS1__NARY_REFERENCE:
				getNaryReference().clear();
				return;
			case SamplemmPackage.CLASS1__NARY_REFERENCE_NOT_UNIQUE:
				getNaryReference_notUnique().clear();
				return;
			case SamplemmPackage.CLASS1__UNARY_CONTAINMENT_REFERENCE:
				setUnaryContainmentReference((Class2)null);
				return;
			case SamplemmPackage.CLASS1__NARY_CONTAINMENT_REFERENCE:
				getNaryContainmentReference().clear();
				return;
			case SamplemmPackage.CLASS1__EINT_MULTI_ATTR:
				getEIntMultiAttr().clear();
				return;
			case SamplemmPackage.CLASS1__STRINGS:
				getStrings().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SamplemmPackage.CLASS1__EINT_ATTR:
				return eIntAttr != EINT_ATTR_EDEFAULT;
			case SamplemmPackage.CLASS1__EIN_OBJECT_ATT:
				return EIN_OBJECT_ATT_EDEFAULT == null ? eInObjectAtt != null : !EIN_OBJECT_ATT_EDEFAULT.equals(eInObjectAtt);
			case SamplemmPackage.CLASS1__ESTRING_ATTR:
				return ESTRING_ATTR_EDEFAULT == null ? eStringAttr != null : !ESTRING_ATTR_EDEFAULT.equals(eStringAttr);
			case SamplemmPackage.CLASS1__ENUM1_ATT:
				return enum1Att != ENUM1_ATT_EDEFAULT;
			case SamplemmPackage.CLASS1__MULTI_REF:
				return multiRef != null && !multiRef.isEmpty();
			case SamplemmPackage.CLASS1__EFLOAT_ATT:
				return eFloatAtt != EFLOAT_ATT_EDEFAULT;
			case SamplemmPackage.CLASS1__EFLOAT_OBJECT_ATT:
				return EFLOAT_OBJECT_ATT_EDEFAULT == null ? eFloatObjectAtt != null : !EFLOAT_OBJECT_ATT_EDEFAULT.equals(eFloatObjectAtt);
			case SamplemmPackage.CLASS1__EBOOLEAN_ATTR:
				return eBooleanAttr != EBOOLEAN_ATTR_EDEFAULT;
			case SamplemmPackage.CLASS1__EBOOLEAN_OBJECT_ATTR:
				return EBOOLEAN_OBJECT_ATTR_EDEFAULT == null ? eBooleanObjectAttr != null : !EBOOLEAN_OBJECT_ATTR_EDEFAULT.equals(eBooleanObjectAttr);
			case SamplemmPackage.CLASS1__ECHAR_ATTR:
				return eCharAttr != ECHAR_ATTR_EDEFAULT;
			case SamplemmPackage.CLASS1__ECHAR_OBJECT_ATTR:
				return ECHAR_OBJECT_ATTR_EDEFAULT == null ? echarObjectAttr != null : !ECHAR_OBJECT_ATTR_EDEFAULT.equals(echarObjectAttr);
			case SamplemmPackage.CLASS1__EDOUBLE_ATTR:
				return eDoubleAttr != EDOUBLE_ATTR_EDEFAULT;
			case SamplemmPackage.CLASS1__EDOUBLE_OBJECT_ATTR:
				return EDOUBLE_OBJECT_ATTR_EDEFAULT == null ? edoubleObjectAttr != null : !EDOUBLE_OBJECT_ATTR_EDEFAULT.equals(edoubleObjectAttr);
			case SamplemmPackage.CLASS1__EBIG_DECIMAL_ATT:
				return EBIG_DECIMAL_ATT_EDEFAULT == null ? eBigDecimalAtt != null : !EBIG_DECIMAL_ATT_EDEFAULT.equals(eBigDecimalAtt);
			case SamplemmPackage.CLASS1__EBIG_INTEGER_ATT:
				return EBIG_INTEGER_ATT_EDEFAULT == null ? eBigIntegerAtt != null : !EBIG_INTEGER_ATT_EDEFAULT.equals(eBigIntegerAtt);
			case SamplemmPackage.CLASS1__ELONG_ATT:
				return eLongAtt != ELONG_ATT_EDEFAULT;
			case SamplemmPackage.CLASS1__ELONG_OBJECT_ATT:
				return ELONG_OBJECT_ATT_EDEFAULT == null ? eLongObjectAtt != null : !ELONG_OBJECT_ATT_EDEFAULT.equals(eLongObjectAtt);
			case SamplemmPackage.CLASS1__ESHORT_ATTR:
				return eShortAttr != ESHORT_ATTR_EDEFAULT;
			case SamplemmPackage.CLASS1__ESHORT_OBJECT_ATTR:
				return ESHORT_OBJECT_ATTR_EDEFAULT == null ? eShortObjectAttr != null : !ESHORT_OBJECT_ATTR_EDEFAULT.equals(eShortObjectAttr);
			case SamplemmPackage.CLASS1__EBYTE_ATTR:
				return eByteAttr != EBYTE_ATTR_EDEFAULT;
			case SamplemmPackage.CLASS1__EBYTE_ATTR_OBJECT:
				return EBYTE_ATTR_OBJECT_EDEFAULT == null ? eByteAttrObject != null : !EBYTE_ATTR_OBJECT_EDEFAULT.equals(eByteAttrObject);
			case SamplemmPackage.CLASS1__UNARY_REFERENCE:
				return unaryReference != null;
			case SamplemmPackage.CLASS1__NARY_REFERENCE:
				return naryReference != null && !naryReference.isEmpty();
			case SamplemmPackage.CLASS1__NARY_REFERENCE_NOT_UNIQUE:
				return naryReference_notUnique != null && !naryReference_notUnique.isEmpty();
			case SamplemmPackage.CLASS1__UNARY_CONTAINMENT_REFERENCE:
				return unaryContainmentReference != null;
			case SamplemmPackage.CLASS1__NARY_CONTAINMENT_REFERENCE:
				return naryContainmentReference != null && !naryContainmentReference.isEmpty();
			case SamplemmPackage.CLASS1__EINT_MULTI_ATTR:
				return eIntMultiAttr != null && !eIntMultiAttr.isEmpty();
			case SamplemmPackage.CLASS1__STRINGS:
				return strings != null && !strings.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (eIntAttr: ");
		result.append(eIntAttr);
		result.append(", eInObjectAtt: ");
		result.append(eInObjectAtt);
		result.append(", eStringAttr: ");
		result.append(eStringAttr);
		result.append(", enum1Att: ");
		result.append(enum1Att);
		result.append(", eFloatAtt: ");
		result.append(eFloatAtt);
		result.append(", eFloatObjectAtt: ");
		result.append(eFloatObjectAtt);
		result.append(", eBooleanAttr: ");
		result.append(eBooleanAttr);
		result.append(", EBooleanObjectAttr: ");
		result.append(eBooleanObjectAttr);
		result.append(", eCharAttr: ");
		result.append(eCharAttr);
		result.append(", EcharObjectAttr: ");
		result.append(echarObjectAttr);
		result.append(", eDoubleAttr: ");
		result.append(eDoubleAttr);
		result.append(", edoubleObjectAttr: ");
		result.append(edoubleObjectAttr);
		result.append(", eBigDecimalAtt: ");
		result.append(eBigDecimalAtt);
		result.append(", eBigIntegerAtt: ");
		result.append(eBigIntegerAtt);
		result.append(", eLongAtt: ");
		result.append(eLongAtt);
		result.append(", eLongObjectAtt: ");
		result.append(eLongObjectAtt);
		result.append(", eShortAttr: ");
		result.append(eShortAttr);
		result.append(", eShortObjectAttr: ");
		result.append(eShortObjectAttr);
		result.append(", eByteAttr: ");
		result.append(eByteAttr);
		result.append(", eByteAttrObject: ");
		result.append(eByteAttrObject);
		result.append(", eIntMultiAttr: ");
		result.append(eIntMultiAttr);
		result.append(", strings: ");
		result.append(strings);
		result.append(')');
		return result.toString();
	}

} //Class1Impl
