/*******************************************************************************
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Nicolas Guyomar (Mia-Software) - Bug 342451 - To be able to edit derived facet attributes and derived facet references in a table
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.examples.ecore.internal.query.eclass;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.emf.facet.infra.query.core.java.IJavaModelQueryWithEditingDomain;
import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue;

/** set the eSuperType on the EClass */
public class SetESuperType implements IJavaModelQueryWithEditingDomain<EClass, EObject> {
	public EObject evaluate(final EClass context, final ParameterValueList parameterValues)
			throws ModelQueryExecutionException {
		return null;
	}

	public EObject evaluate(final EClass context, final ParameterValueList parameterValues,
			final EditingDomain editingDomain) throws ModelQueryExecutionException {

		ModelQueryParameterValue model = parameterValues
				.getParameterValueByName(FacetContext.NEW_VALUE);
		Object value = model.getValue();

		SetCommand setCommand = new SetCommand(editingDomain, context,
				EcorePackage.eINSTANCE.getEClass_ESuperTypes(), value);
		editingDomain.getCommandStack().execute(setCommand);
		return null;
	}
}
