/*****************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 *    
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *  Gregoire Dupe (Mia-Software) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *  Vincent Lorenzo (CEA-LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *****************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal.dialogs;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.facet.widgets.internal.ImageProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.internal.IColumnsToHideDialog;
import org.eclipse.emf.facet.widgets.nattable.internal.IPutOnTheTopQuestionDialog;
import org.eclipse.emf.facet.widgets.nattable.internal.Messages;
import org.eclipse.emf.facet.widgets.nattable.internal.SortedColumnContentProvider;
import org.eclipse.emf.facet.widgets.nattable.internal.preference.pages.NatTablePreferencePage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public abstract class ColumnsToHideDialog extends ListSelectionDialog implements IColumnsToHideDialog {
	private final SortedColumnContentProvider contentProvider;

	/**indicates if the local customization files should be set at the top*/
	private boolean setAtTheTop;
	
	/**the initial selections*/
	private List<Column> initialSelection;

	private final boolean askToPutOnTheTopTheLocalCustomization;

	private boolean mustAskTheUserNextTime;

	private PutOnTheTopQuestionDialog putOnTheTopQuestionDialog;

	public ColumnsToHideDialog(final Shell parentShell, final Object input,
			final ILabelProvider labelProvider, final SortedColumnContentProvider contentProvider,
			final boolean askToPutOnTheTopTheLocalCustomization, final boolean localCustomizatinMustBeOnTheTop) {
		super(parentShell, input, contentProvider, labelProvider,
				Messages.NatTableWidget_selectColumnToShowHide);
		this.contentProvider = contentProvider;
		this.setAtTheTop = localCustomizatinMustBeOnTheTop;
		this.askToPutOnTheTopTheLocalCustomization = askToPutOnTheTopTheLocalCustomization;
	}
	
	@Override
	protected void configureShell(final Shell shell) {
		super.configureShell(shell);
		shell.setImage(ImageProvider.getInstance().getSelectColumnsToHide());
	}

	@Override
	protected Control createDialogArea(final Composite parent) {
		Control control = super.createDialogArea(parent);
		// this chechbox allows to sort the columns by name
		final Button checkBox = new Button((Composite) control, SWT.CHECK);
		checkBox.setText("Sort Columns By Name"); //$NON-NLS-1$ // TODO should be externalized
		checkBox.pack();
		checkBox.addSelectionListener(new SelectionListener() {

			public void widgetSelected(final SelectionEvent e) {
				ColumnsToHideDialog.this.contentProvider.setIsSorted(checkBox.getSelection());
				getViewer().refresh();
			}

			public void widgetDefaultSelected(final SelectionEvent e) {
				// Nothing to do

			}
		});
		return control;

	}

	/**
	 * 
	 * @see org.eclipse.jface.window.Window#open()
	 *
	 * @return
	 */
	@Override
	public int open() {
		if (this.askToPutOnTheTopTheLocalCustomization) {
			this.putOnTheTopQuestionDialog = openPutOnTheTopQuestionDialog();
		}
		this.initialSelection = getVisibleColumns(this.setAtTheTop);
		setInitialElementSelections(this.initialSelection);
		return super.open();
	}

	/**
	 * 
	 * @return <ul>
	 *         <li>IDialogConstants.NO_ID</li>
	 *         <li>IDialogConstants.YES_ID</li>
	 *         <li><code>-1<code> in other cases</li>
	 *         </ul>
	 */
	private PutOnTheTopQuestionDialog openPutOnTheTopQuestionDialog() {
		String message = NatTablePreferencePage.DISPLAYED_MESSAGE_1
				+ " " + NatTablePreferencePage.DISPLAYED_MESSAGE_2 + "\n\n" + NatTablePreferencePage.DISPLAYED_QUESTION; //$NON-NLS-1$//$NON-NLS-2$
		String toggleMessage = NatTablePreferencePage.DONT_DISPLAY_NEXT_TIME;
		final PutOnTheTopQuestionDialog dialog = new PutOnTheTopQuestionDialog(getShell(),
				Messages.NatTableWidget_selectColumnToShowHide, ImageProvider.getInstance()
						.getSelectColumnsToHide(), message, MessageDialog.WARNING, new String[] {
						IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL }, 0, toggleMessage,
				false) {
			@Override
			public boolean close() {
				ColumnsToHideDialog.this.setAtTheTop = getUserAnswer();
				ColumnsToHideDialog.this.mustAskTheUserNextTime = getMustAskTheUserNextTime();
				return super.close();
			}
		};
		Display.getDefault().asyncExec(new Runnable() {
			public void run() {
				dialog.open();
			}
		});
		return dialog;
	}

	public boolean getPutOnTheTop() {
		return this.setAtTheTop;
	}

	/**
	 * 
	 * @see org.eclipse.emf.facet.widgets.nattable.internal.IColumnsToHideDialog#getInitialSelection()
	 *
	 * @return
	 * the initial selection
	 */
	public List<Column> getInitialSelection() {
		return this.initialSelection;
	}

	public IPutOnTheTopQuestionDialog getPutOnTheTopQuestionDialog() {
		return this.putOnTheTopQuestionDialog;
	}
	
	public void ok() {
		okPressed();
	}
	
	public abstract List<Column> getVisibleColumns(boolean putOnTheTop);
	
	public List<Column> getSelectedColumns() {
		List<Column> resultList = new ArrayList<Column>();
		for (Object result : getResult()) {
			if (result instanceof Column) {
				Column column = (Column) result;
				resultList.add(column);
			}
		}
		return resultList;
	}
	
	public boolean getMustAskTheUserNextTime() {
		return this.mustAskTheUserNextTime;
	}
	
	public void selectAll() {
		getViewer().setAllChecked(true);
	}

	public void deselectAll() {
		getViewer().setAllChecked(false);
	}
}