/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 332226 - To be able to create or delete model element from the table - initial API and implementation
 */
package org.eclipse.emf.facet.widgets.nattable.tableconfiguration.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.widgets.celleditors.modelCellEditor.AbstractModelCellEditor;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.InstantiationMethod;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableconfigurationPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Table Configuration</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.impl.TableConfigurationImpl#getCanBePresentedInTheTable <em>Can Be Presented In The Table</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.impl.TableConfigurationImpl#getForcedCellEditors <em>Forced Cell Editors</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.impl.TableConfigurationImpl#getDefaultFacets <em>Default Facets</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.impl.TableConfigurationImpl#getDefaultCustomizations <em>Default Customizations</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.impl.TableConfigurationImpl#getInstantiationMethod <em>Instantiation Method</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.impl.TableConfigurationImpl#getDefaultLocalCustomization <em>Default Local Customization</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TableConfigurationImpl extends EObjectImpl implements TableConfiguration {
	/**
	 * The cached value of the '{@link #getCanBePresentedInTheTable() <em>Can Be Presented In The Table</em>}' reference.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getCanBePresentedInTheTable()
	 * @generated
	 * @ordered
	 */
	protected ModelQuery canBePresentedInTheTable;

	/**
	 * The cached value of the '{@link #getForcedCellEditors() <em>Forced Cell Editors</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getForcedCellEditors()
	 * @generated
	 * @ordered
	 */
	protected EList<AbstractModelCellEditor> forcedCellEditors;

	/**
	 * The cached value of the '{@link #getDefaultFacets() <em>Default Facets</em>}' reference list.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getDefaultFacets()
	 * @generated
	 * @ordered
	 */
	protected EList<Facet> defaultFacets;

	/**
	 * The cached value of the '{@link #getDefaultCustomizations() <em>Default Customizations</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefaultCustomizations()
	 * @generated
	 * @ordered
	 */
	protected EList<MetamodelView> defaultCustomizations;

	/**
	 * The cached value of the '{@link #getInstantiationMethod()
	 * <em>Instantiation Method</em>}' containment reference list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getInstantiationMethod()
	 * @generated
	 * @ordered
	 */
	protected EList<InstantiationMethod> instantiationMethod;

	/**
	 * The cached value of the '{@link #getDefaultLocalCustomization() <em>Default Local Customization</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefaultLocalCustomization()
	 * @generated
	 * @ordered
	 */
	protected MetamodelView defaultLocalCustomization;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected TableConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TableconfigurationPackage.Literals.TABLE_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ModelQuery getCanBePresentedInTheTable() {
		if (canBePresentedInTheTable != null && canBePresentedInTheTable.eIsProxy()) {
			InternalEObject oldCanBePresentedInTheTable = (InternalEObject)canBePresentedInTheTable;
			canBePresentedInTheTable = (ModelQuery)eResolveProxy(oldCanBePresentedInTheTable);
			if (canBePresentedInTheTable != oldCanBePresentedInTheTable) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TableconfigurationPackage.TABLE_CONFIGURATION__CAN_BE_PRESENTED_IN_THE_TABLE, oldCanBePresentedInTheTable, canBePresentedInTheTable));
			}
		}
		return canBePresentedInTheTable;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ModelQuery basicGetCanBePresentedInTheTable() {
		return canBePresentedInTheTable;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setCanBePresentedInTheTable(ModelQuery newCanBePresentedInTheTable) {
		ModelQuery oldCanBePresentedInTheTable = canBePresentedInTheTable;
		canBePresentedInTheTable = newCanBePresentedInTheTable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TableconfigurationPackage.TABLE_CONFIGURATION__CAN_BE_PRESENTED_IN_THE_TABLE, oldCanBePresentedInTheTable, canBePresentedInTheTable));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AbstractModelCellEditor> getForcedCellEditors() {
		if (forcedCellEditors == null) {
			forcedCellEditors = new EObjectResolvingEList<AbstractModelCellEditor>(AbstractModelCellEditor.class, this, TableconfigurationPackage.TABLE_CONFIGURATION__FORCED_CELL_EDITORS);
		}
		return forcedCellEditors;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Facet> getDefaultFacets() {
		if (defaultFacets == null) {
			defaultFacets = new EObjectResolvingEList<Facet>(Facet.class, this, TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_FACETS);
		}
		return defaultFacets;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<MetamodelView> getDefaultCustomizations() {
		if (defaultCustomizations == null) {
			defaultCustomizations = new EObjectResolvingEList<MetamodelView>(MetamodelView.class, this, TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_CUSTOMIZATIONS);
		}
		return defaultCustomizations;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<InstantiationMethod> getInstantiationMethod() {
		if (instantiationMethod == null) {
			instantiationMethod = new EObjectContainmentEList<InstantiationMethod>(InstantiationMethod.class, this, TableconfigurationPackage.TABLE_CONFIGURATION__INSTANTIATION_METHOD);
		}
		return instantiationMethod;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MetamodelView getDefaultLocalCustomization() {
		if (defaultLocalCustomization != null && defaultLocalCustomization.eIsProxy()) {
			InternalEObject oldDefaultLocalCustomization = (InternalEObject)defaultLocalCustomization;
			defaultLocalCustomization = (MetamodelView)eResolveProxy(oldDefaultLocalCustomization);
			if (defaultLocalCustomization != oldDefaultLocalCustomization) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_LOCAL_CUSTOMIZATION, oldDefaultLocalCustomization, defaultLocalCustomization));
			}
		}
		return defaultLocalCustomization;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MetamodelView basicGetDefaultLocalCustomization() {
		return defaultLocalCustomization;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefaultLocalCustomization(MetamodelView newDefaultLocalCustomization) {
		MetamodelView oldDefaultLocalCustomization = defaultLocalCustomization;
		defaultLocalCustomization = newDefaultLocalCustomization;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_LOCAL_CUSTOMIZATION, oldDefaultLocalCustomization, defaultLocalCustomization));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TableconfigurationPackage.TABLE_CONFIGURATION__INSTANTIATION_METHOD:
				return ((InternalEList<?>)getInstantiationMethod()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TableconfigurationPackage.TABLE_CONFIGURATION__CAN_BE_PRESENTED_IN_THE_TABLE:
				if (resolve) return getCanBePresentedInTheTable();
				return basicGetCanBePresentedInTheTable();
			case TableconfigurationPackage.TABLE_CONFIGURATION__FORCED_CELL_EDITORS:
				return getForcedCellEditors();
			case TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_FACETS:
				return getDefaultFacets();
			case TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_CUSTOMIZATIONS:
				return getDefaultCustomizations();
			case TableconfigurationPackage.TABLE_CONFIGURATION__INSTANTIATION_METHOD:
				return getInstantiationMethod();
			case TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_LOCAL_CUSTOMIZATION:
				if (resolve) return getDefaultLocalCustomization();
				return basicGetDefaultLocalCustomization();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TableconfigurationPackage.TABLE_CONFIGURATION__CAN_BE_PRESENTED_IN_THE_TABLE:
				setCanBePresentedInTheTable((ModelQuery)newValue);
				return;
			case TableconfigurationPackage.TABLE_CONFIGURATION__FORCED_CELL_EDITORS:
				getForcedCellEditors().clear();
				getForcedCellEditors().addAll((Collection<? extends AbstractModelCellEditor>)newValue);
				return;
			case TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_FACETS:
				getDefaultFacets().clear();
				getDefaultFacets().addAll((Collection<? extends Facet>)newValue);
				return;
			case TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_CUSTOMIZATIONS:
				getDefaultCustomizations().clear();
				getDefaultCustomizations().addAll((Collection<? extends MetamodelView>)newValue);
				return;
			case TableconfigurationPackage.TABLE_CONFIGURATION__INSTANTIATION_METHOD:
				getInstantiationMethod().clear();
				getInstantiationMethod().addAll((Collection<? extends InstantiationMethod>)newValue);
				return;
			case TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_LOCAL_CUSTOMIZATION:
				setDefaultLocalCustomization((MetamodelView)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TableconfigurationPackage.TABLE_CONFIGURATION__CAN_BE_PRESENTED_IN_THE_TABLE:
				setCanBePresentedInTheTable((ModelQuery)null);
				return;
			case TableconfigurationPackage.TABLE_CONFIGURATION__FORCED_CELL_EDITORS:
				getForcedCellEditors().clear();
				return;
			case TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_FACETS:
				getDefaultFacets().clear();
				return;
			case TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_CUSTOMIZATIONS:
				getDefaultCustomizations().clear();
				return;
			case TableconfigurationPackage.TABLE_CONFIGURATION__INSTANTIATION_METHOD:
				getInstantiationMethod().clear();
				return;
			case TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_LOCAL_CUSTOMIZATION:
				setDefaultLocalCustomization((MetamodelView)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TableconfigurationPackage.TABLE_CONFIGURATION__CAN_BE_PRESENTED_IN_THE_TABLE:
				return canBePresentedInTheTable != null;
			case TableconfigurationPackage.TABLE_CONFIGURATION__FORCED_CELL_EDITORS:
				return forcedCellEditors != null && !forcedCellEditors.isEmpty();
			case TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_FACETS:
				return defaultFacets != null && !defaultFacets.isEmpty();
			case TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_CUSTOMIZATIONS:
				return defaultCustomizations != null && !defaultCustomizations.isEmpty();
			case TableconfigurationPackage.TABLE_CONFIGURATION__INSTANTIATION_METHOD:
				return instantiationMethod != null && !instantiationMethod.isEmpty();
			case TableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_LOCAL_CUSTOMIZATION:
				return defaultLocalCustomization != null;
		}
		return super.eIsSet(featureID);
	}

} // TableConfigurationImpl
