/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal;

import net.sourceforge.nattable.data.IDataProvider;
import net.sourceforge.nattable.grid.layer.ColumnHeaderLayer;
import net.sourceforge.nattable.layer.AbstractLayerTransform;
import net.sourceforge.nattable.layer.DataLayer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.layer.event.ILayerEvent;
import net.sourceforge.nattable.layer.event.StructuralRefreshEvent;
import net.sourceforge.nattable.sort.ISortModel;
import net.sourceforge.nattable.sort.SortDirectionEnum;
import net.sourceforge.nattable.sort.SortHeaderLayer;
import org.eclipse.emf.facet.widgets.nattable.internal.BodyDataProvider;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;

public class ColumnHeaderLayerStack
extends AbstractLayerTransform {
    private final DataLayer dataLayer;

    public ColumnHeaderLayerStack(IDataProvider dataProvider, final NatTableWidget.BodyLayerStack bodyLayer, final BodyDataProvider bodyDataProvider) {
        this.dataLayer = new DataLayer(dataProvider);
        ColumnHeaderLayer colHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)this.dataLayer, (ILayer)bodyLayer, bodyLayer.getSelectionLayer());
        ISortModel sortModel = new ISortModel(){
            private int sortedColumn = -1;
            private SortDirectionEnum fSortDirection = SortDirectionEnum.NONE;

            public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
                this.sortedColumn = columnIndex;
                this.fSortDirection = sortDirection;
                bodyDataProvider.sort(columnIndex, sortDirection);
                bodyLayer.fireLayerEvent((ILayerEvent)new StructuralRefreshEvent((ILayer)bodyLayer.getBodyDataLayer()));
            }

            public boolean isColumnIndexSorted(int columnIndex) {
                return columnIndex == this.sortedColumn && this.fSortDirection != SortDirectionEnum.NONE;
            }

            public int getSortOrder(int columnIndex) {
                return 0;
            }

            public SortDirectionEnum getSortDirection(int columnIndex) {
                if (columnIndex == this.sortedColumn) {
                    return this.fSortDirection;
                }
                return SortDirectionEnum.NONE;
            }

            public void clear() {
                this.sortedColumn = -1;
                this.fSortDirection = SortDirectionEnum.NONE;
            }
        };
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)colHeaderLayer, sortModel, true);
        this.setUnderlyingLayer((ILayer)sortHeaderLayer);
    }

    public DataLayer getDataLayer() {
        return this.dataLayer;
    }
}

