/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Fabien Giquel (Mia-Software) - initial implementation
 *    Grégoire Dupé (Mia-Software)
 *******************************************************************************/
package org.eclipse.emf.facet.infra.common.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.facet.infra.common.core.internal.EmfFacetProject;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ProjectUtils;
import org.eclipse.emf.facet.infra.common.ui.internal.Messages;
import org.eclipse.emf.facet.infra.common.ui.internal.EmfFacetCommonUIPlugin;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/**
 * This operation creates a new project with EmfFacet, Java and Plugin natures.
 * It initializes the Classpath and plugin configuration files with default
 * values.
 * 
 */
public class NewProjectCreationOperation extends WorkspaceModifyOperation {
	private IPath projectLocation = null;
	private IProject project = null;

	public NewProjectCreationOperation(final IPath projectLocation, final IProject projectToCreate) {
		this.projectLocation = projectLocation;
		this.project = projectToCreate;
	}

	@Override
	protected void execute(final IProgressMonitor monitor) throws CoreException,
			InvocationTargetException, InterruptedException {
		monitor.beginTask(Messages.NewProjectCreationOperation_EmfFacetProjectCreation,
				IProgressMonitor.UNKNOWN);
		if (!this.project.exists()) {
			IProjectDescription description = this.project.getWorkspace().newProjectDescription(
					this.project.getName());
			if (!Platform.getLocation().equals(this.projectLocation)) {
				description.setLocation(this.projectLocation);
			}
			this.project.create(monitor);
			this.project.open(monitor);
			monitor.subTask(Messages.NewProjectCreationOperation_AddingJavaNature);
			ProjectUtils.configureAsJavaProject(this.project, monitor);
			monitor.subTask(Messages.NewProjectCreationOperation_AddingPluginNature);
			ProjectUtils.configureAsPluginProject(this.project);
			ProjectUtils.addNature(this.project, monitor, EmfFacetProject.NATURE_ID);
			ProjectUtils.createBuildProperties(this.project);
		} else {
			Logger.logWarning("EmfFacet project creation aborted: the project already exists", //$NON-NLS-1$
					EmfFacetCommonUIPlugin.getDefault());
		}
		monitor.done();
	}
}
