/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.query.ui.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.util.emf.ui.internal.utils.ImageUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryFilteredTree
extends FilteredTree {
    public QueryFilteredTree(Composite parentComposite, Collection<ModelQuerySet> availableQuerySets, List<ViewerFilter> viewerFilters, boolean multiSelection) {
        super(parentComposite, QueryFilteredTree.selectionStyle(multiSelection) | 0x100 | 0x200 | 0x800, QueryFilteredTree.createPatternFilter(), true);
        this.getViewer().setContentProvider(this.createContentProvider());
        this.getViewer().setLabelProvider(this.createLabelProvider());
        this.setFilters(viewerFilters);
        this.setInput(availableQuerySets);
    }

    public void setFilters(final List<ViewerFilter> viewerFilters) {
        if (viewerFilters != null) {
            ViewerFilter emptyQuerySetsFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof ModelQuerySet) {
                        ModelQuerySet modelQuerySet = (ModelQuerySet)element;
                        EList queries = modelQuerySet.getQueries();
                        for (ViewerFilter viewerFilter : viewerFilters) {
                            if (viewerFilter.filter(viewer, (Object)modelQuerySet, queries.toArray()).length != 0) continue;
                            return false;
                        }
                    }
                    return true;
                }
            };
            ArrayList<Object> allViewerFilters = new ArrayList<Object>();
            allViewerFilters.addAll(viewerFilters);
            allViewerFilters.add(emptyQuerySetsFilter);
            allViewerFilters.add(this.getPatternFilter());
            this.getViewer().setFilters(allViewerFilters.toArray(new ViewerFilter[allViewerFilters.size()]));
        } else {
            this.getViewer().setFilters(new ViewerFilter[]{this.getPatternFilter()});
        }
    }

    public void setInput(Collection<ModelQuerySet> availableQuerySets) {
        Collection querySets = availableQuerySets == null ? ModelQuerySetCatalog.getSingleton().getAllModelQuerySets() : availableQuerySets;
        this.getViewer().setInput((Object)querySets);
    }

    private IBaseLabelProvider createLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ModelQuerySet) {
                    ModelQuerySet querySet = (ModelQuerySet)element;
                    return querySet.getName();
                }
                if (element instanceof ModelQuery) {
                    ModelQuery query = (ModelQuery)element;
                    return query.getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }
        };
    }

    private IContentProvider createContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                List querySets = (List)inputElement;
                return querySets.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof ModelQuerySet) {
                    ModelQuerySet querySet = (ModelQuerySet)parentElement;
                    return querySet.getQueries().toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof ModelQuery) {
                    ModelQuery query = (ModelQuery)element;
                    return query.getModelQuerySet();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof ModelQuerySet) {
                    ModelQuerySet querySet = (ModelQuerySet)element;
                    return !querySet.getQueries().isEmpty();
                }
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
    }

    private static int selectionStyle(boolean multiSelection) {
        int selectionStyle = multiSelection ? 2 : 4;
        return selectionStyle;
    }

    private static PatternFilter createPatternFilter() {
        return new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
                if (labelText == null) {
                    return false;
                }
                return this.wordMatches(labelText) || this.parentMatches(viewer, element);
            }

            private boolean parentMatches(Viewer viewer, Object element) {
                ITreeContentProvider contentProvider = (ITreeContentProvider)((StructuredViewer)viewer).getContentProvider();
                Object parent = contentProvider.getParent(element);
                if (parent == null) {
                    return false;
                }
                return this.isLeafMatch(viewer, parent);
            }
        };
    }
}

