/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.core.internal.serialization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.infra.common.core.internal.extensions.AbstractRegistry;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.core.internal.Activator;
import org.eclipse.emf.facet.util.emf.core.serialization.ISerializationRegistry;
import org.eclipse.emf.facet.util.emf.core.serialization.ISerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationRegistry
extends AbstractRegistry
implements ISerializationRegistry {
    private static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.emf.facet.util.emf.core";
    private static final String EXTENSION_POINT_NAME = "serialization";
    private static final String SERIALIZER_ELEMENT = "serializer";
    private static final String CLASS_ATTRIBUTE = "class";
    private static SerializationRegistry instance = null;
    private final List<ISerializer<?>> serializers = new ArrayList();

    public static SerializationRegistry getInstance() {
        if (instance == null) {
            instance = new SerializationRegistry();
        }
        return instance;
    }

    public SerializationRegistry() {
        this.initialize();
    }

    @Override
    public List<ISerializer<?>> getSerializers() {
        return Collections.unmodifiableList(this.serializers);
    }

    @Override
    public ISerializer<?> getSerializerFor(Class<?> type) {
        for (ISerializer<?> serializer : this.serializers) {
            if (!serializer.getType().isAssignableFrom(type)) continue;
            return serializer;
        }
        return null;
    }

    @Override
    public ISerializer<?> getSerializerFor(String type) {
        for (ISerializer<?> serializer : this.serializers) {
            if (!serializer.getType().getName().equals(type)) continue;
            return serializer;
        }
        return null;
    }

    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    protected String getExtensionPointNamespace() {
        return EXTENSION_POINT_NAMESPACE;
    }

    protected void handleRootElement(IConfigurationElement configurationElement) {
        String name = configurationElement.getName();
        if (name.equalsIgnoreCase(SERIALIZER_ELEMENT)) {
            this.readSerializerElement(configurationElement);
        } else {
            this.logUnknownElement(configurationElement);
        }
    }

    private void readSerializerElement(IConfigurationElement configurationElement) {
        Object object;
        try {
            object = configurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return;
        }
        if (object == null) {
            this.logMissingAttribute(configurationElement, CLASS_ATTRIBUTE);
            return;
        }
        if (object instanceof ISerializer) {
            ISerializer serializer = (ISerializer)object;
            ISerializer<?> existingSerializer = this.getSerializerFor(serializer.getType());
            if (existingSerializer != null) {
                this.logError(configurationElement, "Several serializers are provided for the type: " + serializer.getType().getName() + ". Only the first one will be used.");
                if (serializer.getClass().getName().compareTo(existingSerializer.getClass().getName()) < 0) {
                    this.serializers.remove(existingSerializer);
                } else {
                    return;
                }
            }
            this.serializers.add(serializer);
        } else {
            this.logError(configurationElement, "class must implement " + ISerializer.class.getSimpleName());
        }
    }
}

