/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.List;
import net.sourceforge.nattable.data.convert.IDisplayConverter;
import net.sourceforge.nattable.data.validate.IDataValidator;
import net.sourceforge.nattable.edit.ICellEditHandler;
import net.sourceforge.nattable.edit.editor.ICellEditor;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.style.IStyle;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.facet.FacetStructuralFeature;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.infra.facet.core.exception.EmfFacetFacetException;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditHandler;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditor;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.internal.GridElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NatTableCellEditorAdapter
implements ICellEditor {
    private final IModelCellEditor modelCellEditor;
    private final List<Column> columns;
    private Control control;
    private Composite fParent;
    private Object element;
    private FacetContext facetContext;

    public NatTableCellEditorAdapter(IModelCellEditor modelCellEditor, List<Column> columns, FacetContext facetContext) {
        this.modelCellEditor = modelCellEditor;
        this.columns = columns;
        this.facetContext = facetContext;
    }

    public Control activateCell(Composite parent, Object originalCanonicalValue, Character initialEditValue, IDisplayConverter displayConverter, IStyle cellStyle, IDataValidator dataValidator, final ICellEditHandler editHandler, int colIndex, int rowIndex) {
        this.fParent = parent;
        IModelCellEditHandler modelCellEditHandler = new IModelCellEditHandler(){

            public void commit() {
                editHandler.commit(SelectionLayer.MoveDirectionEnum.NONE, true);
            }
        };
        Column column = this.columns.get(colIndex);
        if (column instanceof FeatureColumn) {
            FeatureColumn featureColumn = (FeatureColumn)column;
            EStructuralFeature feature = featureColumn.getFeature();
            GridElement gridElement = (GridElement)originalCanonicalValue;
            this.element = gridElement.getElement();
            if (this.element instanceof EObject) {
                EObject eObject = (EObject)this.element;
                Object value = null;
                if (feature instanceof FacetStructuralFeature) {
                    try {
                        value = this.facetContext.get(eObject, feature);
                    }
                    catch (ModelQueryException e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                    catch (EmfFacetFacetException e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                } else {
                    value = eObject.eGet(feature);
                }
                this.control = this.modelCellEditor.activateCell(parent, value, modelCellEditHandler, feature, eObject);
                return this.control;
            }
            throw new IllegalArgumentException("not an EObject");
        }
        this.control = new Composite(parent, 0);
        return this.control;
    }

    public void setCanonicalValue(Object canonicalValue) {
        throw new UnsupportedOperationException();
    }

    public Object getCanonicalValue() {
        return this.modelCellEditor.getValue();
    }

    public void close() {
        if (this.fParent != null && !this.fParent.isDisposed()) {
            this.fParent.forceFocus();
        }
        if (this.control != null && !this.control.isDisposed()) {
            this.control.dispose();
        }
    }

    public boolean isClosed() {
        return this.control == null || this.control.isDisposed();
    }
}

