/*******************************************************************************
 * Copyright (c) 2009, 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.emf.facet.infra.browser.actions;

import java.util.Collection;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.editors.EcoreBrowser;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.ui.actions.AbstractLoadFacetsAction;

public class LoadFacetsAction extends AbstractLoadFacetsAction {

	private final IBrowserActionBarContributor browserActionBarContributor;

	public LoadFacetsAction(final IBrowserActionBarContributor browserActionBarContributor) {
		super();
		this.browserActionBarContributor = browserActionBarContributor;
	}

	@Override
	protected void loadFacet(final Facet facetToLoad) {
		this.browserActionBarContributor.getBrowser().getBrowserConfiguration()
				.getAppearanceConfiguration().loadFacet(facetToLoad);
	}

	@Override
	protected void clearFacets() {
		this.browserActionBarContributor.getBrowser().getBrowserConfiguration()
				.getAppearanceConfiguration().clearFacets();
	}

	@Override
	protected Collection<? extends Facet> getLoadedFacets() {
		return this.browserActionBarContributor.getBrowser().getBrowserConfiguration()
				.getAppearanceConfiguration().getLoadedFacets();
	}

	@Override
	protected Collection<EPackage> getReferencedEPackages() {
		return this.browserActionBarContributor.getBrowser().getReferencedEPackages();
	}

	@Override
	protected void facetsLoaded(final Collection<Facet> facets) {
		EcoreBrowser browser = this.browserActionBarContributor.getBrowser();
		if (facets.size() > 0) {
			// since customizations can apply to facets, reload
			// customizations
			browser.getBrowserConfiguration().getAppearanceConfiguration().getCustomizationEngine()
					.loadCustomizations();
		}
		// browser.reloadModel();
		// for modified facets
		browser.getBrowserConfiguration().getInstancesForMetaclasses().buildDerivationTree();
		browser.getBrowserConfiguration().getAppearanceConfiguration().touch();
		browser.refreshDelayed(true);

	}
}
