/*******************************************************************************
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.examples.ecore.internal.query.estructuralfeature;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.emf.facet.infra.query.core.java.IJavaModelQuery;
import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;

/**
 * return whether the class is derived
 **/
public class IsDerived implements IJavaModelQuery<EStructuralFeature, String> {
	public String evaluate(final EStructuralFeature context,
			final ParameterValueList parameterValues)
			throws ModelQueryExecutionException {
		if (context.isDerived()) {
			return "Derived"; //$NON-NLS-1$ // TODO Should be externalized
		}
		return new String();
	}
}
