/*******************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * 	  Gregoire Dupe (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *    Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *   Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal;

import org.eclipse.emf.facet.widgets.nattable.INatTableUtils;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;

public class NatTableUtilsImpl implements INatTableUtils {

	public boolean checkInput(final TableInstance tableInstance) {
		TableConfiguration tableConfiguration = tableInstance.getTableConfiguration();
		for (Object element : tableInstance.getElements()) {
			if (!NatTableWidgetInternalUtils.acceptsElement(element, tableConfiguration)) {
				return false;
			}
		}
		return true;
	}

}
