/*******************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal.actions;

import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

/**
 * This class defines the part action HideEmptyColumns for EMF Facet Table
 */
public class HideEmptyColumnsAction implements IEditorActionDelegate, IViewActionDelegate,
		IActionDelegate2 {

	private INatTableWidgetProvider provider = null;
	private IAction localAction;

	public void run(final IAction action) {
		runWithEvent(action, null);
	}

	public void selectionChanged(final IAction action, final ISelection selection) {
		// Update the option change
		try {
			this.localAction.setChecked(this.provider.getNatTableWidget().getTableInstance()
					.isHideEmptyColumns());
		} catch (NullPointerException e) {
			this.localAction.setChecked(false);
		}
	}

	public void setActiveEditor(final IAction action, final IEditorPart targetEditor) {
		if (targetEditor != null) {
			this.provider = (INatTableWidgetProvider) targetEditor
					.getAdapter(INatTableWidgetProvider.class);
			try {
				this.provider.getNatTableWidget().registerActionDelegate(this);
				action.setChecked(this.provider.getNatTableWidget().getTableInstance()
						.isHideEmptyColumns());
			} catch (NullPointerException e) {
				action.setChecked(false);
			}
		}
	}

	public void init(final IViewPart view) {
		this.provider = (INatTableWidgetProvider) view.getAdapter(INatTableWidgetProvider.class);
		if (this.provider != null) {
			this.provider.getNatTableWidget().registerActionDelegate(this);
			if (this.localAction != null) {
				try {
					this.localAction.setChecked(this.provider.getNatTableWidget()
							.getTableInstance().isHideEmptyColumns());
				} catch (NullPointerException e) {
					this.localAction.setChecked(false);
				}
			}
		}
	}

	public void init(final IAction action) {
		this.localAction = action;
	}

	public void dispose() {
		// Nothing to do
	}

	public void runWithEvent(final IAction action, final Event event) {
		if (this.provider != null) {
			this.provider.getNatTableWidget().setHideEmptyColumns(action.isChecked());
			action.setChecked(this.provider.getNatTableWidget().getTableInstance()
					.isHideEmptyColumns());
		}
	}

}
