/*******************************************************************************
 * Copyright (c) 2010 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Guyomar (Mia-Software) - Bug 332924 - To be able to save the table
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.workbench.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.UnsatisfiedConfigurationConstraint;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.view.NatTableView;
import org.eclipse.jface.viewers.IStructuredSelection;

/** Action "View in Table" defined for EObject class */
public class OpenTableViewAction extends OpenTableAction {

	/**
	 * Open the Table to display the selection, if the editing is not null,
	 * model will be editable
	 * 
	 * @param structuredSelection
	 * @param editingDomain
	 * @throws UnsatisfiedConfigurationConstraint
	 */
	@Override
	public void openOn(final IStructuredSelection structuredSelection,
			final EditingDomain editingDomain) throws UnsatisfiedConfigurationConstraint {
		final List<EObject> elements = new ArrayList<EObject>();
		final Iterator<?> iterator = structuredSelection.iterator();
		while (iterator.hasNext()) {
			final Object selectedElement = iterator.next();

			if (selectedElement instanceof EObject) {
				final EObject eObject = (EObject) selectedElement;
				elements.add(eObject);
			} else {
				Logger.logWarning(
						"Cannot open table editor: selected objects are not all model elements", Activator.getDefault()); //$NON-NLS-1$
				return;
			}
		}
		if (editingDomain == null) {
			Logger.logInfo("Model is not editable", Activator.getDefault()); //$NON-NLS-1$

		}
		NatTableView.openOn(elements, editingDomain, new String(), null, null, null);

	}
}
