/*******************************************************************************
 * Copyright (c) 2011 Mia-Software
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software) - Bug 355951 - Wizard to create EMF Facet plug-ins
 *******************************************************************************/
package org.eclipse.emf.facet.dev.ui.internal.wizard;

import java.io.File;
import java.io.IOException;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.facet.dev.ui.internal.Activator;
import org.eclipse.emf.facet.dev.ui.internal.Messages;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class NewEmfFacetPluginPage extends WizardPage {

	private static final String LAST_ID = "lastId"; //$NON-NLS-1$
	private static final String LAST_NAME = "lastName"; //$NON-NLS-1$
	private static final String LAST_VERSION = "lastVersion"; //$NON-NLS-1$
	private static final String LAST_PROVIDER = "lastProvider"; //$NON-NLS-1$
	private static final String LAST_JAVA_NATURE_ENABLED = "javaNatureEnabled"; //$NON-NLS-1$
	private static final String SETTINGS_FILENAME = "settings.txt"; //$NON-NLS-1$
	private static final String NEW_PLUGIN_PAGE_ID = "newPluginPage"; //$NON-NLS-1$
	private Text textID;
	private Text textName;
	private Text textVersion;
	private Text textProvider;
	private Button cbJavaNature;

	protected NewEmfFacetPluginPage() {
		super(NewEmfFacetPluginPage.NEW_PLUGIN_PAGE_ID);
		setTitle(Messages.NewPluginPage_title);
		setMessage(Messages.NewPluginPage_message);
		setImageDescriptor(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/newpprj_wiz.png"))); //$NON-NLS-1$
	}

	protected String getDefaultID() {
		return "org.eclipse.emf.facet.xx"; //$NON-NLS-1$
	}

	protected String getDefaultName() {
		return "EMF Facet xx"; //$NON-NLS-1$
	}

	protected String getDefaultVersion() {
		return "0.2.0"; //$NON-NLS-1$
	}

	protected String getDefaultProvider() {
		return "Eclipse Modeling Project"; //$NON-NLS-1$
	}

	protected boolean getDefaultJavaNatureEnablement() {
		return true;
	}

	//@SuppressWarnings("unused")
	public void createControl(final Composite parent) {
		Composite container = new Composite(parent, SWT.NONE);

		setControl(container);
		final int nColumns = 3;
		container.setLayout(new GridLayout(nColumns, false));

		Label lblID = new Label(container, SWT.NONE);
		lblID.setText(Messages.NewPluginPage_id);

		this.textID = new Text(container, SWT.BORDER);
		this.textID.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		new Label(container, SWT.NONE);

		Label lblName = new Label(container, SWT.NONE);
		lblName.setText(Messages.NewPluginPage_name);

		this.textName = new Text(container, SWT.BORDER);
		this.textName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Label lbluserVisible = new Label(container, SWT.NONE);
		lbluserVisible.setText(Messages.NewPluginPage_userVisible);

		Label lblVersion = new Label(container, SWT.NONE);
		lblVersion.setText(Messages.NewPluginPage_version);

		this.textVersion = new Text(container, SWT.BORDER);
		this.textVersion.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Label lblDigits = new Label(container, SWT.NONE);
		lblDigits.setText(Messages.NewPluginPage_threeDigits);

		Label lblProvider = new Label(container, SWT.NONE);
		lblProvider.setText(Messages.NewPluginPage_provider);

		this.textProvider = new Text(container, SWT.BORDER);
		this.textProvider.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		new Label(container, SWT.NONE);

		this.cbJavaNature = new Button(container, SWT.CHECK);
		this.cbJavaNature.setSelection(true);
		this.cbJavaNature.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, nColumns, 1));
		this.cbJavaNature.setText(Messages.NewEmfFacetPluginPage_btnCheckButton_text);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		load();
	}

	protected DialogSettings getSettings() {
		DialogSettings dialogSettings = new DialogSettings("NewPluginPage.settings"); //$NON-NLS-1$
		return dialogSettings;
	}

	public void load() {
		DialogSettings settings = getSettings();
		String filepath = getSettingsFilePath();
		String id = getDefaultID();
		String name = getDefaultName();
		String version = getDefaultVersion();
		String provider = getDefaultProvider();
		boolean javaNatureEnabled = getDefaultJavaNatureEnablement();
		if (new File(filepath).exists()) {
			try {
				settings.load(filepath);
				id = settings.get(NewEmfFacetPluginPage.LAST_ID);
				name = settings.get(NewEmfFacetPluginPage.LAST_NAME);
				version = settings.get(NewEmfFacetPluginPage.LAST_VERSION);
				provider = settings.get(NewEmfFacetPluginPage.LAST_PROVIDER);
				javaNatureEnabled = settings.getBoolean(NewEmfFacetPluginPage.LAST_JAVA_NATURE_ENABLED);
			} catch (IOException e) {
				Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Error loading dialog settings", e)); //$NON-NLS-1$
			}
		}
		this.textID.setText(id);
		this.textName.setText(name);
		this.textVersion.setText(version);
		this.textProvider.setText(provider);
		this.cbJavaNature.setSelection(javaNatureEnabled);
	}

	protected String getSettingsFilePath() {
		IPath path = Activator.getDefault().getStateLocation();
		return path.append(NewEmfFacetPluginPage.SETTINGS_FILENAME).toOSString();
	}

	public void save() {
		DialogSettings settings = getSettings();
		settings.put(NewEmfFacetPluginPage.LAST_ID, this.textID.getText());
		settings.put(NewEmfFacetPluginPage.LAST_NAME, this.textName.getText());
		settings.put(NewEmfFacetPluginPage.LAST_VERSION, this.textVersion.getText());
		settings.put(NewEmfFacetPluginPage.LAST_PROVIDER, this.textProvider.getText());
		settings.put(NewEmfFacetPluginPage.LAST_JAVA_NATURE_ENABLED, this.cbJavaNature.getSelection());
		try {
			settings.save(getSettingsFilePath());
		} catch (IOException e) {
			Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Error saving dialog settings", e)); //$NON-NLS-1$
		}
	}

	public String getId() {
		return this.textID.getText();
	}

	@Override
	public String getName() {
		return this.textName.getText();
	}

	public String getVersion() {
		return this.textVersion.getText();
	}

	public String getProvider() {
		return this.textProvider.getText();
	}

	public boolean getJavaNatureEnabled() {
		return this.cbJavaNature.getSelection();
	}

}
