/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.dev.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.facet.dev.ui.internal.Activator;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckICU4JHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        Job job = new Job("Searching forbidden references to non-ICU4J classes"){

            protected IStatus run(IProgressMonitor monitor) {
                CheckICU4JHandler.this.search(monitor, window);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    private void search(IProgressMonitor monitor, final IWorkbenchWindow window) {
        String projectName;
        final ArrayList<Match> matches = new ArrayList<Match>();
        int nTasks = 19;
        monitor.beginTask("Searching for forbidden references", 19);
        this.search("java.text.BreakIterator", matches, monitor);
        this.search("java.text.CollationKey", matches, monitor);
        this.search("java.text.Collator", matches, monitor);
        this.search("java.text.DateFormat", matches, monitor);
        this.search("java.text.DateFormatSymbols", matches, monitor);
        this.search("java.text.DecimalFormat", matches, monitor);
        this.search("java.text.DecimalFormatSymbols", matches, monitor);
        this.search("java.text.MessageFormat", matches, monitor);
        this.search("java.text.NumberFormat", matches, monitor);
        this.search("java.text.SimpleDateFormat", matches, monitor);
        this.search("java.util.Calendar", matches, monitor);
        this.search("java.util.TimeZone", matches, monitor);
        this.search("java.util.Currency", matches, monitor);
        this.search("java.util.GregorianCalendar", matches, monitor);
        this.search("java.util.SimpleTimeZone", matches, monitor);
        this.search("java.lang.Character", matches, monitor);
        this.search("java.text.Format", matches, monitor);
        this.search("java.util.Locale", matches, monitor);
        this.search("java.util.ResourceBundle", matches, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        if (!matches.isEmpty()) {
            String newline = System.getProperty("line.separator");
            StringBuilder builder = new StringBuilder();
            for (Match match : matches) {
                builder.append(String.valueOf(match.type) + " : " + match.location + newline);
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("icu4j_" + System.currentTimeMillis());
            try {
                project.create(monitor);
                project.open(monitor);
                projectName = project.getName();
                IFile file = project.getFile("violations.txt");
                ByteArrayInputStream inputStream = new ByteArrayInputStream(builder.toString().getBytes());
                file.create((InputStream)inputStream, true, monitor);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.facet.dev.ui", "Error creating results project", (Throwable)e));
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)window.getShell(), (String)"Error", (String)"Error creating results project (see log)");
                    }
                });
                return;
            }
        } else {
            projectName = null;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                CheckICU4JHandler.this.displayResult(matches, window, projectName);
            }
        });
    }

    protected void displayResult(List<Match> matches, IWorkbenchWindow window, String projectName) {
        if (matches.isEmpty()) {
            MessageDialog.openInformation((Shell)window.getShell(), (String)"MoDisco Development Tools (Incubation)", (String)"No ICU4J violation found");
        } else {
            MessageDialog.openWarning((Shell)window.getShell(), (String)"MoDisco Development Tools (Incubation)", (String)(String.valueOf(matches.size()) + " violation(s) were found. See project " + projectName));
        }
    }

    private void search(final String type, final List<Match> matches, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask("Searching for occurrences of " + type);
        SearchRequestor searchRequestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
                IMember member;
                Object element = searchMatch.getElement();
                if (element instanceof IMember && (member = (IMember)element).isBinary()) {
                    return;
                }
                Match match = new Match();
                match.type = type;
                IResource resource = searchMatch.getResource();
                match.location = resource.getFullPath().toString();
                matches.add(match);
            }
        };
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        SearchPattern pattern = SearchPattern.createPattern((String)type, (int)0, (int)2, (int)0);
        SearchEngine searchEngine = new SearchEngine();
        try {
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, searchRequestor, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.facet.dev.ui", "Error searching for " + type, (Throwable)e));
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)"Error", (String)("Error searching for " + type + " (see log)"));
                }
            });
        }
        monitor.worked(1);
    }

    private class Match {
        private String type;
        private String location;

        private Match() {
        }
    }
}

