/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Grgoire Dup (Mia-Software)
 *     Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.emf.facet.infra.query.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ui.Activator;
import org.eclipse.emf.facet.infra.query.ui.views.queryExecution.internal.QueryExecutionView;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/**
 * Opens the "Query Execution" view, and sets its context to the list of
 * currently selected {@link EObject}s.
 * @deprecated use the new eFacet2 metamodel in org.eclipse.emf.facet.efacet2.metamodel
 *             and the new APIs in org.eclipse.emf.facet.efacet.ui
 */
@Deprecated
public class ExecuteQueryAction implements IActionDelegate {

	private ISelection fSelection = null;

	private IViewPart openQueryExecutionView() {
		try {
			IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
			if (window != null) {
				IWorkbenchPage activePage = window.getActivePage();
				if (activePage != null) {
					return activePage.showView(QueryExecutionView.ID);
				}
			}
		} catch (final PartInitException e) {
			Logger.logError(e, Activator.getDefault());
		}
		return null;
	}

	public void run(final IAction action) {
		List<EObject> selectedEObjects = new ArrayList<EObject>();
		List<ModelQuery> selectedQueries = new ArrayList<ModelQuery>();
		if (this.fSelection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) this.fSelection;
			Iterator<?> iterator = structuredSelection.iterator();
			while (iterator.hasNext()) {
				Object selectedElement = iterator.next();
				if (selectedElement instanceof ModelQuery
						&& "emffacet".equals(((ModelQuery) selectedElement).eResource().getURI().scheme())) { //$NON-NLS-1$
					ModelQuery query = (ModelQuery) selectedElement;
					selectedQueries.add(query);
				} else if (selectedElement instanceof EObject) {
					EObject element = (EObject) selectedElement;
					selectedEObjects.add(element);
				}
			}
		}
		IViewPart view = openQueryExecutionView();
		if (view instanceof QueryExecutionView) {
			QueryExecutionView queryExecutionView = (QueryExecutionView) view;
			if (selectedEObjects.size() > 0) {
				queryExecutionView.setContext(selectedEObjects);
			}
			if (selectedQueries.size() > 0) {
				queryExecutionView.setSelectedQueries(selectedQueries);

			}
		}
	}

	public void selectionChanged(final IAction action, final ISelection selection) {
		this.fSelection = selection;
	}
}
