/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Gregoire Dupe (Mia-Software) - Bug 340571 - To be able have more than one localCustomization
 *   Gregoire Dupe (Mia-Software) - Bug 340572 - Wrong multiplicity in TableInstance.facets
 *   Nicolas Guyomar (Mia-Software) - Bug 340941 - Need new row and column types in the table
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.RowImpl;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryRow;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Package;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Query Row</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>
 * {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.QueryRowImpl#getQueryResult
 * <em>Query Result</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 * @deprecated https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public abstract class QueryRowImpl extends RowImpl implements QueryRow {
	/**
	 * The cached value of the '{@link #getQueryResult() <em>Query Result</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQueryResult()
	 * @generated
	 * @ordered
	 */
	protected ModelQueryResult queryResult;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QueryRowImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Tableinstance2Package.Literals.QUERY_ROW;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelQueryResult getQueryResult() {
		if (queryResult != null && queryResult.eIsProxy()) {
			InternalEObject oldQueryResult = (InternalEObject)queryResult;
			queryResult = (ModelQueryResult)eResolveProxy(oldQueryResult);
			if (queryResult != oldQueryResult) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Tableinstance2Package.QUERY_ROW__QUERY_RESULT, oldQueryResult, queryResult));
			}
		}
		return queryResult;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelQueryResult basicGetQueryResult() {
		return queryResult;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setQueryResult(final ModelQueryResult newQueryResult) {
		ModelQueryResult oldQueryResult = queryResult;
		queryResult = newQueryResult;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Tableinstance2Package.QUERY_ROW__QUERY_RESULT, oldQueryResult, queryResult));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(final int featureID, final boolean resolve, final boolean coreType) {
		switch (featureID) {
			case Tableinstance2Package.QUERY_ROW__QUERY_RESULT:
				if (resolve) return getQueryResult();
				return basicGetQueryResult();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(final int featureID, final Object newValue) {
		switch (featureID) {
			case Tableinstance2Package.QUERY_ROW__QUERY_RESULT:
				setQueryResult((ModelQueryResult)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(final int featureID) {
		switch (featureID) {
			case Tableinstance2Package.QUERY_ROW__QUERY_RESULT:
				setQueryResult((ModelQueryResult)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(final int featureID) {
		switch (featureID) {
			case Tableinstance2Package.QUERY_ROW__QUERY_RESULT:
				return queryResult != null;
		}
		return super.eIsSet(featureID);
	}

} //QueryRowImpl
