/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal;

import net.sourceforge.nattable.copy.command.CopyDataCommandHandler;
import net.sourceforge.nattable.copy.command.CopyDataToClipboardCommand;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.selection.SelectionLayer;
import org.eclipse.emf.facet.widgets.nattable.internal.GridElement;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.internal.TableLabelProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

@Deprecated
public class CopyToClipboardCommandHandler
extends CopyDataCommandHandler {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final NatTableWidget natTableWidget;

    public CopyToClipboardCommandHandler(SelectionLayer selectionLayer, NatTableWidget natTableWidget) {
        super(selectionLayer);
        this.natTableWidget = natTableWidget;
    }

    public boolean doCommand(CopyDataToClipboardCommand command) {
        LayerCell[][] copiedCells = this.assembleCopiedDataStructure();
        this.serializeToClipboard(command, copiedCells);
        return true;
    }

    public void serializeToClipboard(CopyDataToClipboardCommand command, LayerCell[][] copiedCells) {
        Clipboard clipboard = command.getClipboard();
        String cellDelimeter = command.getCellDelimeter();
        String rowDelimeter = NEWLINE;
        TextTransfer textTransfer = TextTransfer.getInstance();
        StringBuilder textData = new StringBuilder();
        int currentRow = 0;
        TableLabelProvider tableLabelProvider = this.natTableWidget.getTableLabelProvider();
        String[] columnNames = this.natTableWidget.getColumnNames();
        LayerCell[][] layerCellArray = copiedCells;
        int n = copiedCells.length;
        int n2 = 0;
        while (n2 < n) {
            LayerCell cell;
            int n3;
            int n4;
            LayerCell[] layerCellArray2;
            boolean first;
            LayerCell[] cells = layerCellArray[n2];
            if (currentRow == 0) {
                first = true;
                layerCellArray2 = cells;
                n4 = cells.length;
                n3 = 0;
                while (n3 < n4) {
                    cell = layerCellArray2[n3];
                    if (first) {
                        first = false;
                    } else {
                        textData.append(cellDelimeter);
                    }
                    int originColumnPosition = cell.getOriginColumnPosition();
                    int converted = this.natTableWidget.convertColumnPositionSelectionToData(originColumnPosition);
                    textData.append(columnNames[converted]);
                    ++n3;
                }
                textData.append(rowDelimeter);
            }
            first = true;
            layerCellArray2 = cells;
            n4 = cells.length;
            n3 = 0;
            while (n3 < n4) {
                Object dataValue;
                cell = layerCellArray2[n3];
                if (first) {
                    first = false;
                } else {
                    textData.append(cellDelimeter);
                }
                if (cell != null && (dataValue = cell.getDataValue()) instanceof GridElement) {
                    GridElement gridElement = (GridElement)dataValue;
                    int originColumnPosition = cell.getOriginColumnPosition();
                    int converted = this.natTableWidget.convertColumnPositionSelectionToData(originColumnPosition);
                    String text = tableLabelProvider.getColumnText(gridElement, converted);
                    textData.append(text);
                }
                ++n3;
            }
            if (++currentRow < copiedCells.length) {
                textData.append(rowDelimeter);
            }
            ++n2;
        }
        String string = textData.toString();
        if (string.length() > 0) {
            clipboard.setContents(new Object[]{textData.toString()}, new Transfer[]{textTransfer});
        }
    }
}

