/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal.listeners;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.internal.TableInstanceCommandFactory;
import org.eclipse.emf.facet.widgets.nattable.internal.exception.CannotExecuteCommandException;
import org.eclipse.emf.facet.widgets.nattable.internal.exception.MultiModelQueryException;
import org.eclipse.emf.facet.widgets.nattable.internal.exception.MultiModelQueryRuntimeException;
import org.eclipse.emf.facet.widgets.nattable.internal.listeners.TableInstanceListenerUtils;

@Deprecated
public class RowDeleteCommandStackListener
implements CommandStackListener {
    protected static final String DEBUG_OPTION = "org.eclipse.emf.facet.widgets.nattable/debug/RowDeleteCommandStackListener";
    protected static final boolean DEBUG = Activator.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.emf.facet.widgets.nattable/debug/RowDeleteCommandStackListener"));
    private TableInstance tableInstance;
    private EditingDomain editingDomain;
    private boolean enable = true;
    private ICommandFactory commandFactory;

    public RowDeleteCommandStackListener(TableInstance tableInstance, EditingDomain editingDomain) {
        this.tableInstance = tableInstance;
        this.editingDomain = editingDomain;
        this.commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor(this.editingDomain);
    }

    public synchronized void commandStackChanged(EventObject event) {
        if (this.enable) {
            CommandStack commandStack;
            Command mostRecentCommand;
            Object source;
            if (DEBUG) {
                System.out.println(String.valueOf(this.getClass().getName()) + ".commandStackChanged(" + System.identityHashCode(event) + ")");
            }
            if ((source = event.getSource()) instanceof CommandStack && !((mostRecentCommand = (commandStack = (CommandStack)source).getMostRecentCommand()) instanceof MostRecentAndDeleteCompoundCommand)) {
                try {
                    try {
                        Command mostRecentAndDeleteCompoundCommand = this.createMostRecentAndDeleteCompoundCommand(event, mostRecentCommand);
                        if (mostRecentAndDeleteCompoundCommand != null) {
                            this.enable = false;
                            if (DEBUG) {
                                System.out.println(String.valueOf(this.getClass().getName()) + ".commandStackChanged(" + System.identityHashCode(event) + "): Exec undo");
                            }
                            this.editingDomain.getCommandStack().undo();
                            if (DEBUG && !mostRecentAndDeleteCompoundCommand.canExecute()) {
                                System.out.println(String.valueOf(this.getClass().getName()) + ".commandStackChanged(" + System.identityHashCode(event) + "): Cannot execute redo+delete");
                                throw new CannotExecuteCommandException("Cannot execute redo+delete");
                            }
                            if (DEBUG) {
                                System.out.println(String.valueOf(this.getClass().getName()) + ".commandStackChanged(" + System.identityHashCode(event) + "): Exec redo+delete");
                            }
                            this.editingDomain.getCommandStack().execute(mostRecentAndDeleteCompoundCommand);
                            if (this.editingDomain.getCommandStack().getMostRecentCommand() != mostRecentAndDeleteCompoundCommand) {
                                throw new CannotExecuteCommandException("Cannot execute redo+delete");
                            }
                        }
                    }
                    catch (CannotExecuteCommandException e) {
                        throw e;
                    }
                    catch (MultiModelQueryException e) {
                        throw new MultiModelQueryRuntimeException(e);
                    }
                }
                finally {
                    this.enable = true;
                }
            }
        }
    }

    private Command createMostRecentAndDeleteCompoundCommand(EventObject event, Command triggeredCommand) throws MultiModelQueryException {
        MostRecentAndDeleteCompoundCommand result = null;
        if (triggeredCommand instanceof DeleteCommand) {
            List<Row> toBeRemovedRows;
            if (DEBUG) {
                System.out.println(String.valueOf(this.getClass().getName()) + ".commandStackChanged(" + System.identityHashCode(event) + "): DeleteCommand found ");
            }
            if (!(toBeRemovedRows = TableInstanceListenerUtils.getRowsRepresentingADeletedEObject((List<Row>)this.tableInstance.getRows())).isEmpty()) {
                DeleteCommand removeRowCommand = new DeleteCommand(this.editingDomain, toBeRemovedRows);
                CompoundCommand removeColumnCommand = TableInstanceCommandFactory.createRemoveUselessColumnsCommand(this.tableInstance, toBeRemovedRows, this.commandFactory, this.editingDomain);
                ArrayList<Command> commandList = new ArrayList<Command>();
                commandList.add(triggeredCommand);
                commandList.add((Command)removeRowCommand);
                if (removeColumnCommand != null) {
                    commandList.add((Command)removeColumnCommand);
                }
                result = new MostRecentAndDeleteCompoundCommand(commandList);
                if (DEBUG) {
                    System.out.println(String.valueOf(this.getClass().getName()) + ".commandStackChanged(" + System.identityHashCode(event) + "): canExecute=" + result.canExecute());
                }
            } else {
                ArrayList<Command> commandList = new ArrayList<Command>();
                commandList.add(triggeredCommand);
                result = new MostRecentAndDeleteCompoundCommand(commandList);
            }
        } else if (triggeredCommand instanceof CompoundCommand) {
            if (DEBUG) {
                System.out.println(String.valueOf(this.getClass().getName()) + ".commandStackChanged(" + System.identityHashCode(event) + "): CompoundCommand found (" + System.identityHashCode(triggeredCommand) + ")");
            }
            CompoundCommand compoundCommand = (CompoundCommand)triggeredCommand;
            MostRecentAndDeleteCompoundCommand resultCompoundCommand = new MostRecentAndDeleteCompoundCommand();
            for (Command command : compoundCommand.getCommandList()) {
                resultCompoundCommand.append(this.createMostRecentAndDeleteCompoundCommand(event, command));
            }
            if (!resultCompoundCommand.isEmpty()) {
                result = resultCompoundCommand;
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MostRecentAndDeleteCompoundCommand
    extends CompoundCommand {
        public MostRecentAndDeleteCompoundCommand() {
        }

        public MostRecentAndDeleteCompoundCommand(List<Command> commandList) {
            super(commandList);
        }
    }
}

