/*******************************************************************************
 * Copyright (c) 2009, 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software) - initial API and implementation
 *     Vincent Lorenzo (CEA-LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal.dialogs;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/**
 * This Dialog provides specific behaviors for the local customizations :
 * <ul>
 * <li>we display only one of the local custom in the dialog</li>
 * <li>all the local customization files are moved when the display local file
 * is moved</li>
 * <li>the local file can't be unloaded</li>
 * </ul>
 * 
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class NatTableWidgetLoadCustomizationsDialog extends
		org.eclipse.emf.facet.infra.browser.custom.ui.dialogs.LoadCustomizationsDialog {

	/**
	 * the {@link MetamodelView} local to the table instance
	 */
	private final List<MetamodelView> localMetamodelViews;

	/**
	 * 
	 * Constructor.
	 * 
	 * @param parent
	 * @param initiallySelectedCustomizations
	 * @param ePackages
	 * @param localMetamodelViews
	 */
	public NatTableWidgetLoadCustomizationsDialog(final Shell parent,
			final List<MetamodelView> initiallySelectedCustomizations,
			final Collection<EPackage> ePackages, final List<MetamodelView> localMetamodelViews) {
		super(parent, initiallySelectedCustomizations, ePackages);
		this.localMetamodelViews = localMetamodelViews;
	}

	/**
	 * Keep only customizations that apply to the given metamodel
	 * 
	 * we add ONE of the local customizations to the previous list (in order to
	 * display it in the dialog)
	 */
	@Override
	protected Collection<MetamodelView> filterForMetamodel(
			final Collection<MetamodelView> allCustomizations, final Collection<EPackage> ePackages) {
		Collection<MetamodelView> filteredCustomizations = super.filterForMetamodel(allCustomizations, ePackages);
		
		// we set only ONE of the localMetamodelView!
		if (!this.localMetamodelViews.isEmpty()) {
			MetamodelView first = this.localMetamodelViews.get(0);
			filteredCustomizations.add(first);
		}

		return filteredCustomizations;
	}

	/**
	 * 
	 * 
	 * 
	 * @return the selected customization + the local customizations at the
	 *         index of the display local customization
	 */
	@Override
	public List<MetamodelView> getSelectedCustomizations() {
		List<MetamodelView> selected = super.getSelectedCustomizations();
		if (!this.localMetamodelViews.isEmpty()) {
			int index = selected.indexOf(this.localMetamodelViews.get(0));

			// we remove the localMetamodel that we have set (we display only
			// one of the metamodel view in the dialog!)
			selected.removeAll(this.localMetamodelViews);
			// we add all local metamodel view at this index
			selected.addAll(index, this.localMetamodelViews);
		}
		return selected;
	}

	/**
	 * Removes the elements from the select excepted the elements which are
	 * local customization
	 * 
	 * @see org.eclipse.emf.facet.infra.browser.custom.ui.dialogs.LoadCustomizationsDialog#removeFromSelection(java.util.List)
	 * 
	 * @param toBeRemoved
	 *            the list of elements to remove from the selection
	 */
	@Override
	protected void removeFromSelection(final List<MetamodelView> toBeRemoved) {
		ListIterator<MetamodelView> iter = toBeRemoved.listIterator();
		boolean displayed = false;
		while (iter.hasNext()) {
			MetamodelView current = iter.next();
			if (this.localMetamodelViews.contains(current)) {
				iter.previous();
				iter.remove();
				displayed = true;
			}
		}
		if (displayed) {
			MessageDialog dialog = new MessageDialog(
					null,
					"Load Customizations Warning", //$NON-NLS-1$ // TODO should be externalized
					null,
					"The local customization can't be unloaded. It is used to store the hidden columns.", //$NON-NLS-1$ // TODO should be externalized
					MessageDialog.WARNING, new String[] { "OK" }, 1); //$NON-NLS-1$ // TODO should be externalized
			dialog.open();
		}
		if (!toBeRemoved.isEmpty()) {
			super.removeFromSelection(toBeRemoved);
		}
	}

	@Override
	protected LabelProvider createLabelProvider() {
		return new ColorLabelProvider();
	}

	/**
	 * LabelProvider for this dialog
	 * 
	 * 
	 * 
	 */
	public class ColorLabelProvider extends LabelProvider implements IColorProvider {

		@Override
		public String getText(final Object element) {
			final MetamodelView metamodelView = (MetamodelView) element;
			if (NatTableWidgetLoadCustomizationsDialog.this.localMetamodelViews.contains(element)) {
				if (metamodelView.getLocation() == null) {
					return "localCustomizations"; //$NON-NLS-1$
				}
			}
			return metamodelView.getName();
		}

		@Override
		public Image getImage(final Object element) {
			final MetamodelView metamodelView = (MetamodelView) element;
			if (NatTableWidgetLoadCustomizationsDialog.this.localMetamodelViews.contains(element)) {
				if (metamodelView.getLocation() == null) {
					return ImageProvider.getInstance().getGrayedUiCustomIcon();

				}
			}
			return ImageProvider.getInstance().getUiCustomIcon();
		}

		public Color getForeground(final Object element) {
			final MetamodelView metamodelView = (MetamodelView) element;
			if (NatTableWidgetLoadCustomizationsDialog.this.localMetamodelViews.contains(element)) {
				if (metamodelView.getLocation() == null) {
					return Display.getDefault().getSystemColor(SWT.COLOR_DARK_GRAY);

				}
			}
			return null;
		}

		public Color getBackground(final Object element) {
			return null;
		}

	}
}
