/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable;

import java.util.List;
import net.sourceforge.nattable.config.CellConfigAttributes;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.layer.config.DefaultColumnHeaderStyleConfiguration;
import net.sourceforge.nattable.painter.cell.BackgroundImagePainter;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import net.sourceforge.nattable.sort.painter.SortableHeaderTextPainter;
import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.DefaultSizeUtils;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.NatTableWidget;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.HeaderImagePainter;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.HorizontalPainterWrapper;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.painter.CustomizedCellPainter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyledColumnHeaderConfiguration
extends DefaultColumnHeaderStyleConfiguration {
    private static final String SELECTED_COLUMN_HEADER_BG_IMAGE = "selected_column_header_bg.png";
    private static final String COLUMN_HEADER_BG_IMAGE = "column_header_bg.png";
    private static final Color COLOR_GRAY = GUIHelper.getColor((int)192, (int)192, (int)192);
    private static final Color COLOR_LIGHT_GRAY = GUIHelper.getColor((int)230, (int)230, (int)230);
    private final NatTableWidget.BodyLayerStack bodyLayer;
    private final List<Column> columnDescriptions;
    private static final Image BG_IMAGE = new Image((Device)Display.getDefault(), StyledColumnHeaderConfiguration.class.getResourceAsStream("column_header_bg.png"));
    private static final Image SELECTED_BG_IMAGE = new Image((Device)Display.getDefault(), StyledColumnHeaderConfiguration.class.getResourceAsStream("selected_column_header_bg.png"));
    private final ICustomizedLabelProvider labelProvider;
    private final NatTableWidget natTableWidget;

    public StyledColumnHeaderConfiguration(NatTableWidget.BodyLayerStack bodyLayer, List<Column> columnDescriptions, ICustomizedLabelProvider labelProvider, NatTableWidget natTableWidget) {
        this.font = DefaultSizeUtils.getHeaderFont();
        this.bodyLayer = bodyLayer;
        this.columnDescriptions = columnDescriptions;
        this.labelProvider = labelProvider;
        this.natTableWidget = natTableWidget;
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        super.configureRegistry(configRegistry);
        this.addNormalModeStyling(configRegistry);
        this.addSelectedModeStyling(configRegistry);
        this.addCornerStyling(configRegistry);
    }

    private void addSelectedModeStyling(IConfigRegistry configRegistry) {
        BackgroundImagePainter selectedCellPainter = new BackgroundImagePainter((ICellPainter)this.createCellPainter(), SELECTED_BG_IMAGE, COLOR_GRAY);
        SortableHeaderTextPainter selectedHeaderPainter = new SortableHeaderTextPainter((ICellPainter)selectedCellPainter, false);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)selectedHeaderPainter, "SELECT", "COLUMN_HEADER");
    }

    private HorizontalPainterWrapper createCellPainter() {
        CustomizedCellPainter txtPainter = new CustomizedCellPainter(this.labelProvider, this.natTableWidget);
        return new HorizontalPainterWrapper(new ICellPainter[]{new HeaderImagePainter(this.bodyLayer, this.columnDescriptions, (ILabelProvider)this.labelProvider), txtPainter});
    }

    private void addNormalModeStyling(IConfigRegistry configurationRegistry) {
        BackgroundImagePainter normalCellPainter = new BackgroundImagePainter((ICellPainter)this.createCellPainter(), BG_IMAGE, COLOR_GRAY);
        SortableHeaderTextPainter headerPainter = new SortableHeaderTextPainter((ICellPainter)normalCellPainter, false);
        configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)headerPainter, "NORMAL", "COLUMN_HEADER");
        configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)headerPainter, "NORMAL", "SORT_DOWN");
        configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)headerPainter, "NORMAL", "SORT_UP");
    }

    private void addCornerStyling(IConfigRegistry configurationRegistry) {
        BackgroundImagePainter cornerPainter = new BackgroundImagePainter(this.createCellPainter(), BG_IMAGE, COLOR_GRAY){

            public void paintCell(LayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
                if (cell.getColumnPosition() != 0) {
                    super.paintCell(cell, gc, rectangle, configRegistry);
                } else {
                    gc.setBackground(COLOR_LIGHT_GRAY);
                    gc.fillPolygon(new int[]{rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height});
                }
            }
        };
        SortableHeaderTextPainter headerPainter = new SortableHeaderTextPainter((ICellPainter)cornerPainter, false);
        configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)headerPainter, "NORMAL", "CORNER");
    }
}

