/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.core.internal.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.infra.common.core.internal.CommonEmfFacetActivator;
import org.eclipse.emf.facet.infra.common.core.internal.Messages;
import org.eclipse.emf.facet.infra.common.core.internal.builder.CatalogJob;
import org.eclipse.emf.facet.infra.common.core.internal.builder.ElementWithSameNameException;
import org.eclipse.emf.facet.infra.common.core.internal.builder.NotificationJob;
import org.eclipse.emf.facet.infra.common.core.internal.builder.OpenResourceException;
import org.eclipse.emf.facet.infra.common.core.internal.protocol.EmfFacetProtocolException;
import org.eclipse.emf.facet.infra.common.core.internal.resource.BrokenRefException;
import org.eclipse.emf.facet.infra.common.core.internal.resource.EmfFacetResourceSet;
import org.eclipse.emf.facet.infra.common.core.internal.resource.IEmfFacetResourceListener;
import org.eclipse.emf.facet.infra.common.core.internal.utils.FileUtils;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ProjectUtils;
import org.eclipse.emf.facet.infra.common.core.internal.validation.ValidationJob;
import org.eclipse.emf.facet.infra.common.core.logging.Logger;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEmfFacetCatalog
implements IEmfFacetResourceListener,
IResourceChangeListener {
    private static final String SCHEDULING_DEBUG_ID = "org.eclipse.emf.facet.infra.common.core/debug/AbstractEmfFacetCatalog/scheduling_debug";
    static final boolean SCHEDULING_DEBUG = CommonEmfFacetActivator.getDefault().isDebugging() && new Boolean(Platform.getDebugOption((String)"org.eclipse.emf.facet.infra.common.core/debug/AbstractEmfFacetCatalog/scheduling_debug")) != false;
    private static final String BUNDLE_DEBUG_ID = "org.eclipse.emf.facet.infra.common.core/debug/AbstractEmfFacetCatalog/bundle_debug";
    private static final boolean DEBUG_BUNDLE = CommonEmfFacetActivator.getDefault().isDebugging() && new Boolean(Platform.getDebugOption((String)"org.eclipse.emf.facet.infra.common.core/debug/AbstractEmfFacetCatalog/bundle_debug")) != false;
    public static final String PROBLEM_MARKER = String.valueOf(CommonEmfFacetActivator.getDefault().getBundle().getSymbolicName()) + ".problemmarker";
    public static final String NAME_CONFLICTS_MARKER = String.valueOf(CommonEmfFacetActivator.getDefault().getBundle().getSymbolicName()) + ".nameconflicts";
    public static final String BROKEN_REF_MARKER = String.valueOf(CommonEmfFacetActivator.getDefault().getBundle().getSymbolicName()) + ".brokenref";
    public static final String NB_ROOTS_MARKER = String.valueOf(CommonEmfFacetActivator.getDefault().getBundle().getSymbolicName()) + ".nbroots";
    private static final String WRONG_ROOT_MARKER = String.valueOf(CommonEmfFacetActivator.getDefault().getBundle().getSymbolicName()) + ".wrongroot";
    private boolean saveEnabled = false;
    private static List<AbstractEmfFacetCatalog> catalogs = new ArrayList<AbstractEmfFacetCatalog>();
    private final EmfFacetResourceSet resourceSet = EmfFacetResourceSet.getResourceSetSingleton();
    private final Map<String, EObject> nameToInstalledEObjectMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, EObject> nameToConcreteInstalledEObjectMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, EObject> nameToWorkspaceEObjectMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, EObject> concreteUriToEObjectMap = Collections.synchronizedMap(new HashMap());
    private final Map<EObject, Bundle> eObjectToBundleMap = Collections.synchronizedMap(new HashMap());
    private final File registryFile;
    private final File nonValidFilesFile;
    private final Map<String, URI> nameToConcreteUriMap = Collections.synchronizedMap(new HashMap());
    private final List<EmfFacetCatalogChangeListener> changeListeners = new ArrayList<EmfFacetCatalogChangeListener>();
    private final Set<IFile> nonValidFiles = Collections.synchronizedSet(new HashSet());
    private final List<NonValidFileListener> nonValidFileListeners = new ArrayList<NonValidFileListener>();
    private final Map<String, List<IFile>> nameToFileInConflict = new HashMap<String, List<IFile>>();

    protected AbstractEmfFacetCatalog() {
        AbstractEmfFacetCatalog.getCatalogs().add(this);
        IPath absolutePath = this.getActivator().getStateLocation().append(this.getRegistryFileName());
        this.registryFile = absolutePath.toFile();
        IPath nonValidFilesAbsolutePath = this.getActivator().getStateLocation().append(String.valueOf(this.getRegistryFileName()) + "_nonValid");
        this.nonValidFilesFile = nonValidFilesAbsolutePath.toFile();
        this.initInstalledRootObject();
        this.initWorkspaceRootObject();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.saveEnabled = true;
        this.save();
    }

    protected abstract Plugin getActivator();

    private void initWorkspaceRootObject() {
        try {
            IResource resource;
            String line;
            BufferedReader br;
            if (this.registryFile.exists()) {
                br = new BufferedReader(new FileReader(this.registryFile));
                line = br.readLine();
                while (line != null) {
                    URI uri = URI.createURI((String)line);
                    String path = uri.toPlatformString(true);
                    if (path != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) instanceof IFile) {
                        IFile file = (IFile)resource;
                        this.internalAddWSFile(file, false);
                    }
                    line = br.readLine();
                }
                br.close();
            }
            if (this.nonValidFilesFile.exists()) {
                br = new BufferedReader(new FileReader(this.nonValidFilesFile));
                line = br.readLine();
                while (line != null) {
                    Path path = new Path(line);
                    IWorkspaceRoot wsr = ResourcesPlugin.getWorkspace().getRoot();
                    resource = wsr.findMember((IPath)path);
                    if (resource == null || !resource.exists() || !(resource instanceof IFile)) {
                        Logger.logError("The resource " + line + " has not be found.", (Plugin)CommonEmfFacetActivator.getDefault());
                    } else {
                        this.internalAddWSFile((IFile)resource, false);
                    }
                    line = br.readLine();
                }
                br.close();
            }
        }
        catch (Exception e) {
            Logger.logError(e, this.getActivator());
        }
    }

    public synchronized void save() {
        if (this.saveEnabled) {
            try {
                PrintStream ps = new PrintStream(this.registryFile);
                for (EObject eObject : this.getNameToWorkspaceEObjectMap().values()) {
                    ps.println(this.getURI(this.getRootObjectName(eObject)));
                }
                ps.close();
                ps = new PrintStream(this.nonValidFilesFile);
                for (IResource iResource : this.nonValidFiles) {
                    ps.println(iResource.getFullPath());
                }
                ps.close();
            }
            catch (FileNotFoundException e) {
                Logger.logError(e, this.getActivator());
            }
        }
    }

    protected Map<String, EObject> getNameToInstalledEObjectMap() {
        return this.nameToInstalledEObjectMap;
    }

    protected Map<String, EObject> getNameToWorkspaceEObjectMap() {
        return this.nameToWorkspaceEObjectMap;
    }

    private void initInstalledRootObject() {
        if (this.getRegistryExtensionPoint() != null) {
            IConfigurationElement[] configs;
            IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(this.getRegistryExtensionPoint());
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                String fileName = config.getAttribute("file");
                URI uri = URI.createURI((String)("platform:/plugin/" + config.getContributor().getName() + "/" + fileName));
                this.openInstalledResource(config, uri);
                ++n2;
            }
        }
    }

    private void openInstalledResource(IConfigurationElement config, URI uri) {
        EObject rootObject = this.openResource(uri, null);
        if (rootObject != null) {
            Bundle bundle = config != null ? Platform.getBundle((String)config.getContributor().getName()) : Platform.getBundle((String)uri.segment(1));
            if (DEBUG_BUNDLE) {
                System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".openInstalledResource(): this.eObjectToBundleMap.put(rootObject=" + rootObject + ", bundle" + bundle + ")");
            }
            this.eObjectToBundleMap.put(rootObject, bundle);
            String name = this.getRootObjectName(rootObject);
            this.nameToInstalledEObjectMap.put(name, rootObject);
            Resource concreteResource = EmfFacetResourceSet.getResourceSetSingleton().getResource(uri, true);
            EObject concreteRootEObject = (EObject)concreteResource.getContents().get(0);
            this.nameToConcreteInstalledEObjectMap.put(name, concreteRootEObject);
        }
    }

    protected abstract String getRootObjectName(EObject var1);

    protected abstract String getRegistryExtensionPoint();

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized EObject openResource(URI uri, IFile file) {
        EObject rootObject = null;
        Class<?> expectedClass = this.getRootClass();
        Resource resource = null;
        try {
            try {
                try {
                    resource = this.resourceSet.getResource(uri, this);
                }
                catch (Exception e) {
                    if (!(e.getCause() instanceof EmfFacetProtocolException)) throw e;
                    EmfFacetProtocolException mpe = (EmfFacetProtocolException)e.getCause();
                    if (file == null) throw mpe;
                    IMarker marker = file.createMarker(BROKEN_REF_MARKER);
                    marker.setAttribute("message", (Object)(String.valueOf(Messages.AbstractEmfFacetCatalog_brokenRef) + uri.toString()));
                    marker.setAttribute("severity", 2);
                    throw mpe;
                }
                this.checkIsBroken(uri, file, resource);
                if (resource.getContents().size() != 1) {
                    if (file == null) throw new OpenResourceException("One and only one root is expected in a model from the catalog; " + resource.getContents().size() + " found.");
                    IMarker marker = file.createMarker(NB_ROOTS_MARKER);
                    marker.setAttribute("message", (Object)Messages.AbstractEmfFacetCatalog_oneRootOnly);
                    marker.setAttribute("severity", 2);
                    throw new OpenResourceException("One and only one root is expected in a model from the catalog; " + resource.getContents().size() + " found.");
                }
                if (!ValidationJob.getInstance().validateSync(resource, file)) {
                    if (file == null) throw new OpenResourceException("Non valid model.");
                    this.nonValidFileNotify(file, resource);
                    throw new OpenResourceException("Non valid model.");
                }
                EObject root = (EObject)resource.getContents().get(0);
                if (!expectedClass.isInstance(root)) {
                    if (file == null) throw new OpenResourceException("Wrong kind of root in " + uri.toString() + " : " + root.getClass().getSimpleName() + "; expected " + this.getRootClass().getSimpleName());
                    IMarker marker = file.createMarker(WRONG_ROOT_MARKER);
                    marker.setAttribute("message", (Object)Messages.AbstractEmfFacetCatalog_wrontKindOfRoot);
                    marker.setAttribute("severity", 2);
                    throw new OpenResourceException("Wrong kind of root in " + uri.toString() + " : " + root.getClass().getSimpleName() + "; expected " + this.getRootClass().getSimpleName());
                }
                this.checkNameConflicts(uri, (IResource)file, root);
                String rootObjectName = this.getRootObjectName(root);
                this.nameToConcreteUriMap.put(rootObjectName, uri);
                rootObject = this.copyToEmfFacetResource(root, rootObjectName);
                this.concreteUriToEObjectMap.put(uri.toString(), rootObject);
                this.postOpenResource(uri, file, rootObject);
                this.nonValidFiles.remove(file);
                return rootObject;
            }
            catch (OpenResourceException e) {
                if (uri.isPlatformPlugin()) {
                    Logger.logError(e, "Failed to load: " + uri, this.getActivator());
                }
                this.invalidateWSFile(file);
                if (resource == null) return rootObject;
                this.resourceSet.getResources().remove((Object)resource);
                return rootObject;
            }
            catch (EmfFacetProtocolException e) {
                if (uri.isPlatformPlugin()) {
                    Logger.logError(e, "Failed to load: " + uri, this.getActivator());
                }
                this.invalidateWSFile(file);
                if (resource == null) return rootObject;
                this.resourceSet.getResources().remove((Object)resource);
                return rootObject;
            }
            catch (Exception e) {
                Logger.logError(e, "Failed to load: " + uri, this.getActivator());
                this.invalidateWSFile(file);
                if (resource == null) return rootObject;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resourceSet.getResources().remove((Object)resource);
                return rootObject;
            }
        }
        finally {
            if (resource != null) {
                this.resourceSet.getResources().remove((Object)resource);
            }
        }
    }

    protected abstract void postOpenResource(URI var1, IFile var2, EObject var3) throws Exception;

    private void checkIsBroken(URI uri, IFile file, Resource resource) throws OpenResourceException {
        boolean brokenRefFound = false;
        for (Resource.Diagnostic diagnostic : resource.getErrors()) {
            if (!(diagnostic instanceof BrokenRefException)) continue;
            brokenRefFound = true;
            BrokenRefException brokenRef = (BrokenRefException)diagnostic;
            if (file != null) {
                try {
                    IMarker marker = file.createMarker(BROKEN_REF_MARKER);
                    marker.setAttribute("message", (Object)(String.valueOf(Messages.AbstractEmfFacetCatalog_brokenRef) + brokenRef.getTargetLocation()));
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("uri", (Object)brokenRef.getLocation());
                }
                catch (CoreException e) {
                    Logger.logError(e, "Failed to load: " + uri, this.getActivator());
                }
                continue;
            }
            Logger.logError(brokenRef, "Failed to load: " + uri, this.getActivator());
        }
        if (brokenRefFound) {
            throw new OpenResourceException("Broken references.");
        }
    }

    private EObject copyToEmfFacetResource(EObject root, String rootObjectName) {
        if (this.getEmfFacetSubProtocol() != null) {
            URI emffacetUri = URI.createURI((String)("emffacet:/" + this.getEmfFacetSubProtocol() + "/" + rootObjectName));
            Resource emffacetResource = this.resourceSet.getResource(emffacetUri, false);
            if (emffacetResource == null) {
                emffacetResource = this.resourceSet.createResource(emffacetUri);
            }
            emffacetResource.getContents().clear();
            EObject emffacetResourceRoot = EcoreUtil.copy((EObject)root);
            emffacetResource.getContents().add((Object)emffacetResourceRoot);
            return emffacetResourceRoot;
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNameConflicts(URI uri, IResource file, EObject rootObject) throws ElementWithSameNameException {
        URI registeredURI;
        EObject objectWithSameName = this.getNameToWorkspaceEObjectMap().get(this.getRootObjectName(rootObject));
        if (objectWithSameName != null && (registeredURI = this.nameToConcreteUriMap.get(this.getRootObjectName(rootObject))) != null && uri.isPlatformResource() && registeredURI.isPlatformResource() && !uri.equals((Object)registeredURI)) {
            try {
                IMarker marker = file.createMarker(NAME_CONFLICTS_MARKER);
                marker.setAttribute("message", (Object)NLS.bind((String)Messages.AbstractEmfFacetCatalog_nameConflict, (Object)registeredURI));
                marker.setAttribute("severity", 2);
            }
            catch (CoreException e1) {
                Logger.logError(e1, "Failed to add markers to " + file.getLocation().toString(), this.getActivator());
            }
            Map<String, List<IFile>> map = this.nameToFileInConflict;
            synchronized (map) {
                if (file instanceof IFile) {
                    IFile iFile = (IFile)file;
                    List<IFile> filesInConflict = this.nameToFileInConflict.get(this.getRootObjectName(rootObject));
                    if (filesInConflict == null) {
                        filesInConflict = new ArrayList<IFile>();
                        this.nameToFileInConflict.put(this.getRootObjectName(rootObject), filesInConflict);
                    }
                    filesInConflict.add(iFile);
                }
            }
            throw new ElementWithSameNameException(uri + " in conflicts with " + registeredURI);
        }
    }

    protected abstract String getEmfFacetSubProtocol();

    protected abstract Class<?> getRootClass();

    public final Collection<EObject> getAllRootObjects() {
        return this.getAllRootObjectMap().values();
    }

    protected Map<String, EObject> getAllRootObjectMap() {
        HashMap<String, EObject> allRootObject = new HashMap<String, EObject>();
        allRootObject.putAll(this.nameToInstalledEObjectMap);
        allRootObject.putAll(this.nameToWorkspaceEObjectMap);
        return allRootObject;
    }

    public final EObject getRootObject(String name) {
        return this.getAllRootObjectMap().get(name);
    }

    public final synchronized void scheduleAddWSFile(final IFile declarationFile) {
        Runnable action = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AbstractEmfFacetCatalog abstractEmfFacetCatalog = AbstractEmfFacetCatalog.this;
                synchronized (abstractEmfFacetCatalog) {
                    if (SCHEDULING_DEBUG) {
                        System.out.println("Executing add ws file: " + this + " file=" + declarationFile);
                    }
                    AbstractEmfFacetCatalog.this.internalAddWSFile(declarationFile, false);
                }
            }
        };
        if (SCHEDULING_DEBUG) {
            System.out.println("scheduleAddWSFile: " + action + " file=" + declarationFile);
        }
        CatalogJob.getInstance().addAction(action);
    }

    private synchronized void invalidateWSFile(IFile file) {
        if (file != null) {
            this.nonValidFiles.add(file);
            this.scheduleRemoveWSFile(file);
        }
    }

    protected abstract void preRemove(IFile var1, String var2, EObject var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWSFile(IFile declarationFile, String pathName) {
        if (SCHEDULING_DEBUG) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".removeWSFile(): file=" + declarationFile);
        }
        URI rootObjectURI = URI.createPlatformResourceURI((String)pathName, (boolean)false);
        EObject oldRootObject = this.concreteUriToEObjectMap.get(rootObjectURI.toString());
        this.preRemove(declarationFile, pathName, oldRootObject);
        if (oldRootObject != null) {
            EObject installedVersion;
            Resource oldResource;
            String rootObjectName = this.getRootObjectName(oldRootObject);
            if (SCHEDULING_DEBUG && !this.nameToWorkspaceEObjectMap.containsKey(rootObjectName)) {
                System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".removeWSFile(): rootObject not contained in this.nameToWorkspaceEObjectMap");
            }
            this.nameToWorkspaceEObjectMap.remove(rootObjectName);
            this.concreteUriToEObjectMap.remove(rootObjectURI.toString());
            this.nameToConcreteUriMap.remove(rootObjectName);
            if (SCHEDULING_DEBUG) {
                System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".removeWSFiles: oldRootObject=" + oldRootObject);
            }
            if ((oldResource = oldRootObject.eResource()) != null) {
                oldResource.unload();
                this.resourceSet.getResources().remove((Object)oldResource);
            }
            if ((installedVersion = this.nameToConcreteInstalledEObjectMap.get(rootObjectName)) != null) {
                if (SCHEDULING_DEBUG && !this.nameToWorkspaceEObjectMap.containsKey(rootObjectName)) {
                    System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".removeWSFile(): replacing the removed ws root object by the installed version.");
                }
                EObject emffacetResourceRoot = this.copyToEmfFacetResource(installedVersion, rootObjectName);
                this.nameToInstalledEObjectMap.put(rootObjectName, emffacetResourceRoot);
                this.restoreInstalledURI(rootObjectName, emffacetResourceRoot);
                this.postRestoreInstalledURI(emffacetResourceRoot);
                this.updateNotify(emffacetResourceRoot, null);
                EmfFacetResourceSet.getResourceSetSingleton().removeListener(this, rootObjectURI);
                EmfFacetResourceSet.getResourceSetSingleton().aResourceHasBeenLoaded(emffacetResourceRoot.eResource());
            } else {
                this.removeNotify(declarationFile);
                if (oldResource != null) {
                    EmfFacetResourceSet.getResourceSetSingleton().aResourceHasBeenUnLoaded(oldResource);
                }
            }
            Map<String, List<IFile>> map = this.nameToFileInConflict;
            synchronized (map) {
                List<IFile> filesInConflict = this.nameToFileInConflict.get(rootObjectName);
                if (filesInConflict != null) {
                    for (IFile fileInConflict : filesInConflict) {
                        this.scheduleUpdateWSFile(fileInConflict);
                    }
                }
            }
        } else if (SCHEDULING_DEBUG) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".removeWSFiles: oldRootObject=null");
        }
        this.save();
    }

    protected void postRestoreInstalledURI(EObject emffacetResourceRoot) {
    }

    private void restoreInstalledURI(String rootObjectName, EObject emffacetResourceRoot) {
        String rootObjectFileName = String.valueOf(rootObjectName) + "." + this.getFileExtension();
        if (this.getRegistryExtensionPoint() != null) {
            IConfigurationElement[] configs;
            IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(this.getRegistryExtensionPoint());
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                String fileName = config.getAttribute("file");
                if (rootObjectFileName.equals(fileName)) {
                    URI uri = URI.createURI((String)("platform:/plugin/" + config.getContributor().getName() + "/" + fileName));
                    Bundle bundle = Platform.getBundle((String)config.getContributor().getName());
                    if (DEBUG_BUNDLE) {
                        System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".restoreInstalledURI(): this.eObjectToBundleMap.put(rootObject=" + emffacetResourceRoot + ", bundle=" + bundle + ")");
                    }
                    this.eObjectToBundleMap.put(emffacetResourceRoot, bundle);
                    this.nameToConcreteUriMap.put(rootObjectName, uri);
                }
                ++n2;
            }
        }
    }

    public void scheduleRemoveWSFiles(List<IFile> toBeRemoved) {
        ArrayList<Status> statusList = new ArrayList<Status>();
        final HashMap<IFile, String> pathNames = new HashMap<IFile, String>();
        for (IFile file : toBeRemoved) {
            try {
                pathNames.put(file, this.getPath(file));
            }
            catch (RuntimeException runtimeException) {
                Status status = new Status(4, "org.eclipse.emf.facet.infra.common.core", "An error happen while getting path of: " + file);
                statusList.add(status);
            }
        }
        Runnable action = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AbstractEmfFacetCatalog abstractEmfFacetCatalog = AbstractEmfFacetCatalog.this;
                synchronized (abstractEmfFacetCatalog) {
                    for (IFile declarationFile : pathNames.keySet()) {
                        if (SCHEDULING_DEBUG) {
                            System.out.println("executing remove ws files: " + this + "file=" + declarationFile);
                        }
                        AbstractEmfFacetCatalog.this.removeWSFile(declarationFile, (String)pathNames.get(declarationFile));
                    }
                }
            }
        };
        if (SCHEDULING_DEBUG) {
            System.out.println("scheduleRemoveWSFiles: " + action);
        }
        CatalogJob.getInstance().addAction(action);
    }

    public synchronized void scheduleRemoveWSFile(final IFile declarationFile) {
        final String pathName = this.getPath(declarationFile);
        Runnable action = new Runnable(){

            public void run() {
                if (SCHEDULING_DEBUG) {
                    System.out.println("executing remove ws file: " + this + " file=" + declarationFile);
                }
                AbstractEmfFacetCatalog.this.removeWSFile(declarationFile, pathName);
            }
        };
        if (SCHEDULING_DEBUG) {
            System.out.println("scheduleRemoveWSFile: " + action + " file=" + declarationFile);
        }
        CatalogJob.getInstance().addAction(action);
    }

    private String getPath(IFile declarationFile) {
        if (declarationFile == null) {
            throw new IllegalArgumentException("declarationFile is null");
        }
        if (declarationFile.getProject() == null) {
            throw new IllegalStateException("declarationFile's project is null");
        }
        String pathName = String.valueOf(declarationFile.getProject().getName()) + "/" + declarationFile.getProjectRelativePath().toString();
        return pathName;
    }

    protected abstract String getRootObjectNsUri(EObject var1);

    final synchronized EObject internalAddWSFile(IFile declarationFile, boolean update) {
        if (declarationFile == null) {
            throw new IllegalArgumentException("declarationFile must not be null");
        }
        if (FileUtils.isInOutputLocation(declarationFile)) {
            return null;
        }
        if (SCHEDULING_DEBUG) {
            System.out.println("internalAddWSFile: file=" + declarationFile);
        }
        EObject rootEObject = null;
        if (declarationFile.exists() && this.getFileExtension().equals(declarationFile.getFileExtension())) {
            try {
                String pathName = String.valueOf(declarationFile.getProject().getName()) + "/" + declarationFile.getProjectRelativePath().toString();
                URI rootObjectURI = URI.createPlatformResourceURI((String)pathName, (boolean)false);
                if (update) {
                    declarationFile.deleteMarkers(PROBLEM_MARKER, true, 1);
                }
                if ((rootEObject = this.openResource(rootObjectURI, declarationFile)) != null) {
                    this.getNameToWorkspaceEObjectMap().put(this.getRootObjectName(rootEObject), rootEObject);
                    this.resourceSet.aResourceHasBeenLoaded(rootEObject.eResource());
                    if (update) {
                        this.updateNotify(rootEObject, declarationFile);
                    } else {
                        this.addNotify(rootEObject, declarationFile);
                    }
                }
            }
            catch (Exception e) {
                String verb = update ? "update" : "add";
                String message = "Failed to " + verb + " a workspace file in " + this.getClass().getSimpleName() + " : " + declarationFile.getLocation();
                Logger.logError(e, message, this.getActivator());
            }
            this.save();
        }
        return rootEObject;
    }

    public final synchronized void scheduleUpdateWSFile(final IFile declarationFile) {
        final String path = this.getPath(declarationFile);
        Runnable action = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AbstractEmfFacetCatalog abstractEmfFacetCatalog = AbstractEmfFacetCatalog.this;
                synchronized (abstractEmfFacetCatalog) {
                    if (SCHEDULING_DEBUG) {
                        System.out.println("executing UpdateWSFile: " + this + " file=" + declarationFile);
                    }
                    if (declarationFile.exists()) {
                        AbstractEmfFacetCatalog.this.internalAddWSFile(declarationFile, true);
                    } else {
                        AbstractEmfFacetCatalog.this.removeWSFile(declarationFile, path);
                    }
                }
            }
        };
        if (SCHEDULING_DEBUG) {
            System.out.println("scheduleUpdateWSFile: " + action + " file=" + declarationFile);
        }
        CatalogJob.getInstance().addAction(action);
    }

    public void addNotify(final EObject rootObject, final IFile file) {
        if (SCHEDULING_DEBUG) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".addNotify(): " + rootObject);
        }
        final List<EmfFacetCatalogChangeListener> tmpChangeListeners = this.changeListeners;
        Runnable runnable = new Runnable(){

            public void run() {
                for (EmfFacetCatalogChangeListener listener : tmpChangeListeners) {
                    if (SCHEDULING_DEBUG) {
                        System.out.println(String.valueOf(AbstractEmfFacetCatalog.this.getClass().getSimpleName()) + ".addNotify() executing: " + rootObject + " -> " + listener.toString());
                    }
                    listener.added(rootObject, file);
                }
            }
        };
        NotificationJob.getInstance().addAction(runnable);
    }

    public void removeNotify(final IFile file) {
        if (SCHEDULING_DEBUG) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".removeNotify(): " + file);
        }
        final List<EmfFacetCatalogChangeListener> tmpChangeListeners = this.changeListeners;
        Runnable runnable = new Runnable(){

            public void run() {
                for (EmfFacetCatalogChangeListener listener : tmpChangeListeners) {
                    if (SCHEDULING_DEBUG) {
                        System.out.println(String.valueOf(AbstractEmfFacetCatalog.this.getClass().getSimpleName()) + ".removeNotify() executing: " + listener.toString());
                    }
                    listener.removed(file);
                }
            }
        };
        NotificationJob.getInstance().addAction(runnable);
    }

    public void updateNotify(final EObject rootObject, final IFile file) {
        if (SCHEDULING_DEBUG) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".updateNotify(): " + rootObject);
        }
        final List<EmfFacetCatalogChangeListener> tmpChangeListeners = this.changeListeners;
        Runnable runnable = new Runnable(){

            public void run() {
                for (EmfFacetCatalogChangeListener listener : tmpChangeListeners) {
                    if (SCHEDULING_DEBUG) {
                        System.out.println(String.valueOf(AbstractEmfFacetCatalog.this.getClass().getSimpleName()) + ".updateNotify() executing:" + rootObject + " -> " + listener.toString());
                    }
                    listener.changed(rootObject, file);
                }
            }
        };
        NotificationJob.getInstance().addAction(runnable);
    }

    public void addNonValidFileListener(NonValidFileListener nonValidFileListener) {
        if (!this.nonValidFileListeners.contains(nonValidFileListener)) {
            this.nonValidFileListeners.add(nonValidFileListener);
        }
    }

    public void removeNonValidFileListener(NonValidFileListener nonValidFileListener) {
        this.nonValidFileListeners.remove(nonValidFileListener);
    }

    private void nonValidFileNotify(IFile file, Resource resource) {
        for (NonValidFileListener nonValidFileListener : this.nonValidFileListeners) {
            nonValidFileListener.nonValidFile(file, resource);
        }
    }

    public URI getURI(String name) {
        return this.nameToConcreteUriMap.get(name);
    }

    public void addChangeListener(EmfFacetCatalogChangeListener emffacetCatalogChangeListener) {
        if (SCHEDULING_DEBUG) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".addChangeListener(): " + emffacetCatalogChangeListener.toString());
        }
        if (!this.changeListeners.contains(emffacetCatalogChangeListener)) {
            this.changeListeners.add(emffacetCatalogChangeListener);
        }
    }

    public void removeChangeListener(EmfFacetCatalogChangeListener emffacetCatalogChangeListener) {
        if (SCHEDULING_DEBUG) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".removeChangeListener(): " + emffacetCatalogChangeListener.toString());
        }
        this.changeListeners.remove(emffacetCatalogChangeListener);
    }

    public synchronized void clean(IProject project) {
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    String fileExtension = resource.getFileExtension();
                    if (AbstractEmfFacetCatalog.this.getFileExtension().equals(fileExtension)) {
                        try {
                            if (resource.exists()) {
                                resource.deleteMarkers("org.eclipse.emf.ecore.diagnostic", true, 1);
                                resource.deleteMarkers(PROBLEM_MARKER, true, 1);
                            }
                        }
                        catch (CoreException e) {
                            Logger.logError(e, "An error happened while removing markers", (Plugin)CommonEmfFacetActivator.getDefault());
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            Logger.logError(e, this.getActivator());
        }
        ArrayList<IFile> oldNonValidFiles = new ArrayList<IFile>(this.nonValidFiles);
        this.nonValidFiles.clear();
        for (IFile nonValidFile : oldNonValidFiles) {
            if (nonValidFile.getProject() == project) continue;
            this.nonValidFiles.add(nonValidFile);
        }
        ArrayList<String> toBeRemovedList = new ArrayList<String>();
        ArrayList<IFile> toBeRemovedFileList = new ArrayList<IFile>();
        for (String rootObjectName : this.getNameToWorkspaceEObjectMap().keySet()) {
            IFile file;
            EObject rootObject = this.getNameToWorkspaceEObjectMap().get(rootObjectName);
            if (rootObject.eResource() == null) {
                toBeRemovedList.add(rootObjectName);
                continue;
            }
            URI uri = this.getURI(rootObjectName);
            if (!uri.isPlatformResource() || (file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(uri.toPlatformString(true))) == null || project != file.getProject()) continue;
            toBeRemovedFileList.add(file);
        }
        for (String toBeRemoved : toBeRemovedList) {
            this.getNameToWorkspaceEObjectMap().remove(toBeRemoved);
        }
        if (!toBeRemovedList.isEmpty()) {
            this.removeNotify(null);
        }
        for (IFile file : toBeRemovedFileList) {
            this.scheduleRemoveWSFile(file);
        }
        if (!toBeRemovedFileList.isEmpty()) {
            this.removeNotify(null);
        }
    }

    @Override
    public void aListenedResourceHasChanged(URI resourceUri, URI dependingResourceURI) {
        IFile declarationFile = null;
        if (dependingResourceURI.isPlatformPlugin()) {
            this.openInstalledResource(null, dependingResourceURI);
        } else {
            if (dependingResourceURI.isPlatformResource()) {
                URI uri = dependingResourceURI;
                declarationFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            } else if (dependingResourceURI.scheme().equals("emffacet")) {
                URI uri = this.getURI(dependingResourceURI.segment(1));
                declarationFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            } else {
                Logger.logError("Unexpected uri: " + dependingResourceURI, this.getActivator());
                return;
            }
            if (EmfFacetResourceSet.DEBUG) {
                String message = String.valueOf(this.getClass().getSimpleName()) + ".aListenedResourceHasChanged(): Reloading: file= " + declarationFile;
                System.out.println(message);
            }
            this.scheduleUpdateWSFile(declarationFile);
        }
    }

    private final String getRegistryFileName() {
        return String.valueOf(this.getClass().getName()) + "Registry";
    }

    protected Bundle getBundle(EObject rootObject) {
        Bundle bundle = this.eObjectToBundleMap.get(rootObject);
        if (bundle == null) {
            String name = this.getRootObjectName(rootObject);
            bundle = this.eObjectToBundleMap.get(this.getRootObject(name));
        }
        return bundle;
    }

    public static List<AbstractEmfFacetCatalog> getCatalogs() {
        return catalogs;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResource resource = event.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                if (ProjectUtils.isEmfFacetProject(project) && (event.getType() == 2 || event.getType() == 4)) {
                    final ArrayList<IFile> toBeRemoved = new ArrayList<IFile>();
                    project.accept(new IResourceVisitor(){

                        public boolean visit(IResource visitedResource) throws CoreException {
                            if (visitedResource instanceof IFile) {
                                IFile file = (IFile)visitedResource;
                                if (AbstractEmfFacetCatalog.this.getFileExtension().equals(file.getFileExtension())) {
                                    toBeRemoved.add(file);
                                    AbstractEmfFacetCatalog.this.nonValidFiles.remove(file);
                                }
                            }
                            return true;
                        }
                    });
                    this.scheduleRemoveWSFiles(toBeRemoved);
                }
            } else if (event.getType() == 1 && event.getResource() == null) {
                this.checkOpenResource(event);
            }
        }
        catch (CoreException e) {
            Logger.logError(e, (Plugin)CommonEmfFacetActivator.getDefault());
        }
    }

    private void checkOpenResource(IResourceChangeEvent event) throws CoreException {
        IResourceDelta delta = event.getDelta();
        IResourceDelta[] projectDeltas = delta.getAffectedChildren();
        int i = 0;
        while (i < projectDeltas.length) {
            IProject project;
            int kind = projectDeltas[i].getKind();
            int flags = projectDeltas[i].getFlags();
            if (kind == 4 && (flags & 0x4000) != 0 && (project = (IProject)projectDeltas[i].getResource()).isOpen() && ProjectUtils.isEmfFacetProject(project)) {
                project.accept(new IResourceVisitor(){

                    public boolean visit(IResource visitedResource) throws CoreException {
                        if (visitedResource instanceof IFile) {
                            IFile file = (IFile)visitedResource;
                            AbstractEmfFacetCatalog.this.scheduleAddWSFile(file);
                        }
                        return true;
                    }
                });
            }
            ++i;
        }
    }

    public abstract String getFileExtension();

    public synchronized void revalidateAll(IProject project) {
        if (SCHEDULING_DEBUG) {
            System.out.println("revalidateAll: project=" + project);
        }
        for (String name : this.getNameToWorkspaceEObjectMap().keySet()) {
            URI uri = this.nameToConcreteUriMap.get(name);
            IFile file = ModelUtils.getIFileFromPlatformURI(uri);
            if (file != null) {
                if (file.getProject() != project || this.nonValidFiles.contains(file)) continue;
                this.scheduleUpdateWSFile(file);
                continue;
            }
            Logger.logError("No file found for: " + uri.toString(), (Plugin)CommonEmfFacetActivator.getDefault());
        }
        for (IFile file : new ArrayList<IFile>(this.nonValidFiles)) {
            if (file.getProject() != project) continue;
            this.scheduleUpdateWSFile(file);
        }
    }

    synchronized void validatedCallback(IFile file, boolean result) {
        if (result) {
            this.nonValidFiles.remove(file);
        } else {
            this.invalidateWSFile(file);
        }
    }

    public void waitUntilBuilt() {
        AbstractEmfFacetCatalog.joinJobs();
    }

    public static void whenBuilt(final Runnable runnable) {
        Job job = new Job(Messages.AbstractEmfFacetCatalog_waitingCatalogJobName){

            protected IStatus run(IProgressMonitor monitor) {
                AbstractEmfFacetCatalog.joinJobs();
                runnable.run();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    static void joinJobs() {
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, null);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, null);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (InterruptedException e) {
            Logger.logError(e, "Unexpected error.", (Plugin)CommonEmfFacetActivator.getDefault());
        }
    }

    protected static boolean belongsTo(Object family) {
        return family == ResourcesPlugin.FAMILY_MANUAL_BUILD || family == ResourcesPlugin.FAMILY_AUTO_BUILD || family == ResourcesPlugin.FAMILY_MANUAL_REFRESH;
    }

    @Deprecated
    public final EObject updateWSFile(IFile declarationFile) {
        this.scheduleAddWSFile(declarationFile);
        AbstractEmfFacetCatalog.joinJobs();
        URI uri = URI.createFileURI((String)declarationFile.getLocation().toFile().getPath());
        return this.concreteUriToEObjectMap.get(uri);
    }

    @Deprecated
    public final EObject addWSFile(IFile declarationFile) {
        this.scheduleAddWSFile(declarationFile);
        AbstractEmfFacetCatalog.joinJobs();
        URI uri = URI.createFileURI((String)declarationFile.getLocation().toFile().getPath());
        return this.concreteUriToEObjectMap.get(uri);
    }

    @Deprecated
    public void removeWSFile(IFile declarationFile) {
        this.scheduleRemoveWSFile(declarationFile);
        AbstractEmfFacetCatalog.joinJobs();
    }

    @Deprecated
    public final EObject addWSFile(IFile declarationFile, boolean update) {
        if (update) {
            this.scheduleUpdateWSFile(declarationFile);
        } else {
            this.scheduleAddWSFile(declarationFile);
        }
        AbstractEmfFacetCatalog.joinJobs();
        URI uri = URI.createFileURI((String)declarationFile.getLocation().toFile().getPath());
        return this.concreteUriToEObjectMap.get(uri);
    }

    public static interface EmfFacetCatalogChangeListener
    extends EventListener {
        public void changed(EObject var1, IFile var2);

        public void added(EObject var1, IFile var2);

        public void removed(IFile var1);
    }

    public static interface NonValidFileListener {
        public void nonValidFile(IFile var1, Resource var2);
    }
}

