/*******************************************************************************
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software) - Bug 365808 - [Unit Test Failure][0.2/4.2][0.2/3.8] org.eclipse.emf.facet.widgets.nattable.tests.NatTableAPITests
 *    Gregoire Dupe (Mia-Software) - Bug 368030 - [Unit Test Failure] org.eclipse.emf.facet.widgets.table.tests.internal.v0_1.swtbot.NatTableUITests.testAddQueryColumn
 *******************************************************************************/
 package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.Collection;
import java.util.List;

import net.sourceforge.nattable.coordinate.PositionCoordinate;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.util.ui.internal.exported.displaysync.AbstractExceptionFreeRunnable;
import org.eclipse.emf.facet.util.ui.internal.exported.displaysync.AbstractVoidExceptionFreeRunnable;
import org.eclipse.emf.facet.util.ui.internal.exported.displaysync.AbstractVoidRunnable;
import org.eclipse.emf.facet.util.ui.internal.exported.displaysync.SynchronizedComposite;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.internal.exported.IMustRemoveNonConformingElementsDialog;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.InstantiationMethod;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionDelegate;

/**
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class SynchronizedNatTableWidget extends SynchronizedComposite<NatTableWidget> implements INatTableWidgetInternal {

	public SynchronizedNatTableWidget(final Composite parent,
			final IEditingDomainProvider editingDomainProvider,
			final TableInstance tableInstanceParam, final MenuManager menuMgr) {
		super(new NatTableWidget(parent, editingDomainProvider, tableInstanceParam,
				menuMgr));
	}

	public void addSelectionChangedListener(final ISelectionChangedListener listener) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().addSelectionChangedListener(listener);
			}
		});
	}

	public ISelection getSelection() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<ISelection>() {
			@Override
			public ISelection safeRun() {
				return getSynchronizedComposite().getSelection();
			}
		});
	}

	public void removeSelectionChangedListener(final ISelectionChangedListener listener) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite()
				.removeSelectionChangedListener(listener);
			}
		});
	}

	public void setSelection(final ISelection selection) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().setSelection(selection);
			}
		});
	}

	public void createNewElement() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().createNewElement();
			}
		});
	}

	public void createNewElement(final InstantiationMethod instantiationMethod) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite()
				.createNewElement(instantiationMethod);
			}
		});
	}

	public void selectInstantiationMethodToLaunch() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().selectInstantiationMethodToLaunch();
			}
		});
	}

	public void save() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().save();
			}
		});
	}

	public void saveAs() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().saveAs();
			}
		});

	}

	public void addQueryColumn() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().addQueryColumn();
			}
		});

	}

	public void copySelectionToClipboard() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().copySelectionToClipboard();
			}
		});
	}

	public void deleteSelection() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().deleteSelection();
			}
		});
	}

	public void selectColumnsToHide() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().selectColumnsToHide();
			}
		});
	}

	public void setHideEmptyColumns(final boolean hideEmptyColumns) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite()
				.setHideEmptyColumns(hideEmptyColumns);
			}
		});
	}

	public void setOnlyShowCommonColumns(final boolean onlyShowCommonColumns) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite()
				.setOnlyShowCommonColumns(onlyShowCommonColumns);
			}
		});
	}

	public void sortColumnsByType() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().sortColumnsByType();
			}
		});
	}

	public void openSavedTable() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().openSavedTable();
			}
		});
	}

	public void removeLine() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().removeLine();
			}
		});

	}

	public void selectAll() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().selectAll();
			}
		});
	}

	public TableConfiguration getTableConfiguration() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<TableConfiguration>() {
			@Override
			public TableConfiguration safeRun() {
				return getSynchronizedComposite().getTableConfiguration();
			}
		});
	}

	public List<InstantiationMethod> getInstantionMethodHistory() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<List<InstantiationMethod>>() {
			@Override
			public List<InstantiationMethod> safeRun() {
				return getSynchronizedComposite().getInstantionMethodHistory();
			}
		});
	}

	public TableInstance getTableInstance() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<TableInstance>() {
			@Override
			public TableInstance safeRun() {
				return getSynchronizedComposite().getTableInstance();
			}
		});
	}

	public boolean isCellSelected() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>() {
			@Override
			public Boolean safeRun() {
				return getSynchronizedComposite().isCellSelected();
			}
		});
	}

	public boolean isColumnSelected() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>() {
			@Override
			public Boolean safeRun() {
				return getSynchronizedComposite().isColumnSelected();
			}
		});
	}

	public boolean isCellsDeletable() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>() {
			@Override
			public Boolean safeRun() {
				return getSynchronizedComposite().isCellsDeletable();
			}
		});
	}

	public boolean isSelectedColumnDeletable() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>() {
			@Override
			public Boolean safeRun() {
				return getSynchronizedComposite().isSelectedColumnDeletable();
			}
		});
	}

	public Control getComposite() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<Control>() {
			@Override
			public Control safeRun() {
				return getSynchronizedComposite().getComposite();
			}
		});
	}

	public void addRows(final List<EObject> newElements) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().addRows(newElements);
			}
		});

	}

	public void registerActionDelegate(final IActionDelegate action) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().registerActionDelegate(action);
			}
		});

	}

	public void unregisterActionDelegate(final IActionDelegate action) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().unregisterActionDelegate(action);
			}
		});

	}

	public Collection<ISelectionChangedListener> getSelectionChangedListeners() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<Collection<ISelectionChangedListener>>() {
			@Override
			public Collection<ISelectionChangedListener> safeRun() {
				return getSynchronizedComposite().getSelectionChangedListeners();
			}
		});
	}

	public void openLoadCustomizationDialog() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().openLoadCustomizationDialog();
			}
		});

	}

	public void openLoadFacetsDialog() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().openLoadFacetsDialog();
			}
		});

	}

	public void sortColumnByNameAtoZ() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().sortColumnByNameAtoZ();
			}
		});

	}

	public void sortColumnByNameZtoA() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().sortColumnByNameZtoA();
			}
		});

	}

	public void setFacets(final Collection<Facet> facets) throws CoreException {
		this.voidSyncExec(new AbstractVoidRunnable<CoreException>() {
			@Override
			public void voidRun() throws CoreException {
				getSynchronizedComposite().setFacets(facets);
			}
		});
	}

	public void selectDefaultLabelCell(final EObject eObject) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().selectDefaultLabelCell(eObject);
			}
		});

	}

	public void selectCell(final EObject eObject, final EStructuralFeature eStructuralFeature) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().selectCell(eObject,
						eStructuralFeature);
			}
		});

	}

	public void editSelectedCell() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().editSelectedCell();
			}
		});
	}

	public void showHideColumns(final List<Column> selectedColumns, final boolean putOnTheTop) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().showHideColumns(selectedColumns,
						putOnTheTop);
			}
		});
	}

	public boolean isOneOfTheLocalCustomizationsNotOnTheTop() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>() {
			@Override
			public Boolean safeRun() {
				return getSynchronizedComposite().isOneOfTheLocalCustomizationsNotOnTheTop();
			}
		});
	}

	public List<Column> getVisibleColumns(final boolean setAtTheTop) {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<List<Column>>() {
			@Override
			public List<Column> safeRun() {
				return getSynchronizedComposite().getVisibleColumns(setAtTheTop);
			}
		});
	}

	public void putLocalCustomizationOnTheTop() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().putLocalCustomizationOnTheTop();
			}
		});
	}

	public void putLocalCustomizationOnTheBottom() {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().putLocalCustomizationOnTheBottom();
			}
		});
	}

	public boolean isSelectedCellEditable() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>() {
			@Override
			public Boolean safeRun() {
				return getSynchronizedComposite().isSelectedCellEditable();
			}
		});
	}

	public void selectRows(final List<EObject> elementsToSelect, final boolean clearTheSelection) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().selectRows(elementsToSelect,
						clearTheSelection);
			}
		});
	}

	public IColumnsToHideDialog openColumnsToHideDialog() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<IColumnsToHideDialog>() {
			@Override
			public IColumnsToHideDialog safeRun() {
				return getSynchronizedComposite().openColumnsToHideDialog();
			}
		});
	}

	public TableLabelProvider getTableLabelProvider() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<TableLabelProvider>() {
			@Override
			public TableLabelProvider safeRun() {
				return getSynchronizedComposite().getTableLabelProvider();
			}
		});
	}

	public List<Column> getVisibleColumnsUsingTheLocalCustomizations(final TableInstance2 table,
			final boolean setToTheTop) {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<List<Column>>() {
			@Override
			public List<Column> safeRun() {
				return getSynchronizedComposite()
						.getVisibleColumnsUsingTheLocalCustomizations(table, setToTheTop);
			}
		});
	}

	public List<Column> getVisibleColumnsUsingTheLayer() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<List<Column>>() {
			@Override
			public List<Column> safeRun() {
				return getSynchronizedComposite()
						.getVisibleColumnsUsingTheLayer();
			}
		});
	}

	public void loadCustomizations(final List<MetamodelView> customizationsToLoad) {
		voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable() {
			@Override
			public void voidSafeRun() {
				getSynchronizedComposite().loadCustomizations(customizationsToLoad);
			}
		});
	}

	public Point getCellPositionRelativeToDisplay(final int columnPosition, final int rowPosition) {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<Point>() {
			@Override
			public Point safeRun() {
				return getSynchronizedComposite()
						.getCellPositionRelativeToDisplay(columnPosition, rowPosition);
			}
		});
	}

	public int waitForResfreshJob() {
		return getSynchronizedComposite().waitForResfreshJob();
	}

	public FacetContext getFacetContext() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<FacetContext>() {
			@Override
			public FacetContext safeRun() {
				return getSynchronizedComposite().getFacetContext();
			}
		});
	}

	public boolean usesTmpResource() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>() {
			@Override
			public Boolean safeRun() {
				return getSynchronizedComposite().usesTmpResource();
			}
		});
	}

	public List<PositionCoordinate> getSelectedCellsPositions() {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<List<PositionCoordinate>>() {
			@Override
			public List<PositionCoordinate> safeRun() {
				return getSynchronizedComposite()
						.getSelectedCellsPositions();
			}
		});
	}

	public IMustRemoveNonConformingElementsDialog setCanBePresentedInTheTable(final ModelQuery query) {
		return this.safeSyncExec(new AbstractExceptionFreeRunnable<IMustRemoveNonConformingElementsDialog>() {
			@Override
			public IMustRemoveNonConformingElementsDialog safeRun() {
						return getSynchronizedComposite().setCanBePresentedInTheTable(query);
			}
		});
	}

	public int waitForResfreshJob(final int lastState) {
		return getSynchronizedComposite().waitForResfreshJob(lastState);
	}

}
