/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Gregoire Dupe (Mia-Software) - Bug 340571 - To be able have more than one localCustomization
 */
package org.eclipse.emf.facet.widgets.nattable.tableconfiguration2.impl;

import java.util.Collection;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;

import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.impl.TableConfigurationImpl;

import org.eclipse.emf.facet.widgets.nattable.tableconfiguration2.TableConfiguration2;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration2.Tableconfiguration2Package;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Table Configuration2</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration2.impl.TableConfiguration2Impl#getDefaultLocalCustomizations <em>Default Local Customizations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 * @deprecated cf. Bug 371180 - [Deprecated] org.eclipse.emf.facet.widgets.nattable.tableconfiguration (https://bugs.eclipse.org/bugs/show_bug.cgi?id=371180).
 */
@Deprecated 
public class TableConfiguration2Impl extends TableConfigurationImpl implements TableConfiguration2 {
	/**
	 * The cached value of the '{@link #getDefaultLocalCustomizations() <em>Default Local Customizations</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefaultLocalCustomizations()
	 * @generated
	 * @ordered
	 */
	protected EList<MetamodelView> defaultLocalCustomizations;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TableConfiguration2Impl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Tableconfiguration2Package.Literals.TABLE_CONFIGURATION2;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<MetamodelView> getDefaultLocalCustomizations() {
		if (defaultLocalCustomizations == null) {
			defaultLocalCustomizations = new EObjectResolvingEList<MetamodelView>(MetamodelView.class, this, Tableconfiguration2Package.TABLE_CONFIGURATION2__DEFAULT_LOCAL_CUSTOMIZATIONS);
		}
		return defaultLocalCustomizations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Tableconfiguration2Package.TABLE_CONFIGURATION2__DEFAULT_LOCAL_CUSTOMIZATIONS:
				return getDefaultLocalCustomizations();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Tableconfiguration2Package.TABLE_CONFIGURATION2__DEFAULT_LOCAL_CUSTOMIZATIONS:
				getDefaultLocalCustomizations().clear();
				getDefaultLocalCustomizations().addAll((Collection<? extends MetamodelView>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Tableconfiguration2Package.TABLE_CONFIGURATION2__DEFAULT_LOCAL_CUSTOMIZATIONS:
				getDefaultLocalCustomizations().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Tableconfiguration2Package.TABLE_CONFIGURATION2__DEFAULT_LOCAL_CUSTOMIZATIONS:
				return defaultLocalCustomizations != null && !defaultLocalCustomizations.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //TableConfiguration2Impl
