/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ContextColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.ValueColumn;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.internal.Messages;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;

@Deprecated
public final class NatTableWidgetInternalUtils {
    private NatTableWidgetInternalUtils() {
    }

    public static String getColumnName(Column columnDescription) {
        String columnName;
        if (columnDescription instanceof DefaultLabelColumn) {
            columnName = Messages.NatTableWidget_label;
        } else if (columnDescription instanceof MetaClassColumn) {
            columnName = Messages.NatTableWidget_metaclass;
        } else if (columnDescription instanceof ContextColumn) {
            columnName = Messages.NatTableWidget_queryContext;
        } else if (columnDescription instanceof EContainerColumn) {
            columnName = "/eContainer";
        } else if (columnDescription instanceof QueryColumn) {
            QueryColumn queryColumn = (QueryColumn)columnDescription;
            columnName = queryColumn.getQuery().getName();
        } else if (columnDescription instanceof AttributeColumn) {
            AttributeColumn attributeColumn = (AttributeColumn)columnDescription;
            EAttribute attribute = attributeColumn.getAttribute();
            columnName = attribute.isDerived() ? "/" + attribute.getName() : attribute.getName();
        } else if (columnDescription instanceof ReferenceColumn) {
            ReferenceColumn referenceColumn = (ReferenceColumn)columnDescription;
            EReference reference = referenceColumn.getReference();
            String multiplicity = "";
            columnName = reference.isDerived() ? "/" + reference.getName() + multiplicity : String.valueOf(reference.getName()) + multiplicity;
        } else if (columnDescription instanceof FacetReferenceColumn) {
            FacetReferenceColumn facetReferenceColumn = (FacetReferenceColumn)columnDescription;
            columnName = facetReferenceColumn.getReference().getName();
        } else if (columnDescription instanceof FacetAttributeColumn) {
            FacetAttributeColumn facetAttributeColumn = (FacetAttributeColumn)columnDescription;
            columnName = facetAttributeColumn.getAttribute().getName();
        } else if (columnDescription instanceof ValueColumn) {
            columnName = "Value";
        } else {
            Logger.logWarning((String)"Unhandled column description type", (Plugin)Activator.getDefault());
            columnName = "";
        }
        return columnName;
    }

    public static boolean acceptsElement(Object element, TableConfiguration tableConfiguration) {
        if (tableConfiguration == null) {
            return true;
        }
        ModelQuery query = tableConfiguration.getCanBePresentedInTheTable();
        if (query != null) {
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                try {
                    AbstractModelQuery modelQueryImpl = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(query);
                    Object result = modelQueryImpl.basicEvaluate(eObject);
                    if (result instanceof Boolean) {
                        return (Boolean)result;
                    }
                }
                catch (ModelQueryException e) {
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

