/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.aggregate.tests.internal;

import org.eclipse.emf.facet.common.ui.internal.views.ElementsView;
import org.eclipse.emf.facet.efacet.ui.internal.exported.EFacetUIConstants;
import org.eclipse.emf.facet.util.swt.internal.exported.TestUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;

public class FacetSetsCatalogViewTests {
    private static final String AGGREGATE_NAME = "Bug372626_Aggregates_aggregate";
    private static final String FACET_SET_NAME = "Bug372626_Aggregates_facetSet";
    private static final String CUSTOM_NAME = "Bug372626_Aggregates_custom";
    private ElementsView elementsView;

    protected void setElementsView(ElementsView elementsView) {
        this.elementsView = elementsView;
    }

    public ElementsView getElementsView() {
        return this.elementsView;
    }

    private void openView() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    FacetSetsCatalogViewTests.this.setElementsView((ElementsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(EFacetUIConstants.getFacetSetsCatalogViewId()));
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testCustomizationsView() throws Exception {
        TestUtils.closeWelcomePage();
        this.openView();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                FacetSetsCatalogViewTests.this.testView();
            }
        });
    }

    protected void testView() {
        TreeViewer treeViewer = this.getElementsView().getViewer();
        treeViewer.expandAll();
        TreeItem[] items = treeViewer.getTree().getItems();
        TreeItem aggregate = this.findTreeItem(AGGREGATE_NAME, items);
        SWTBotUtils.captureScreenShot((String)"Facet sets catalog view with aggregates");
        Assert.assertNotNull((String)"The aggregate must be in the view", (Object)aggregate);
        Assert.assertNotNull((String)"The custom must be in the view", (Object)this.findTreeItem(CUSTOM_NAME, items));
        Assert.assertNotNull((String)"The FacetSet must be in the view", (Object)this.findTreeItem(FACET_SET_NAME, items));
        Assert.assertNotNull((String)"The custom must appear under the aggregate", (Object)this.findTreeItem(CUSTOM_NAME, aggregate.getItems()));
        Assert.assertNotNull((String)"The FacetSet must appear under the aggregate", (Object)this.findTreeItem(FACET_SET_NAME, aggregate.getItems()));
    }

    protected TreeItem findTreeItem(String text, TreeItem[] items) {
        TreeItem result = null;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (text.equals(item.getText())) {
                result = item;
            }
            ++n2;
        }
        return result;
    }
}

