/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.custom.tests.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.infra.browser.custom.CustomViewFeature;
import org.eclipse.emf.facet.infra.browser.custom.CustomizableFeatures;
import org.eclipse.emf.facet.infra.browser.custom.DerivedFeatureValue;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.StaticFeatureValue;
import org.eclipse.emf.facet.infra.browser.custom.TypeView;
import org.eclipse.emf.facet.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.emf.facet.infra.browser.custom.tests.internal.Activator;
import org.eclipse.emf.facet.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.emf.facet.infra.browser.uicore.internal.customization.CustomizationEngine;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.AttributeItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ItemsFactory;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.emf.facet.infra.common.core.internal.builder.AbstractEmfFacetCatalog;
import org.eclipse.emf.facet.infra.common.core.internal.utils.FileUtils;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ProjectUtils;
import org.eclipse.emf.facet.infra.facet.FacetAttribute;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

@Deprecated
public class BrowserCustomTest {
    public static final String FILE_EXT = ".uiCustom";

    @Test
    public void testUICustom() throws Exception {
        CustomizationEngine customizationEngine = new CustomizationEngine();
        customizationEngine.registerCustomization(this.getCustomization("testCustomization"));
        customizationEngine.loadCustomizations();
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
        EClass someEClass = (EClass)ePackage.getEClassifier("EOperation");
        Assert.assertTrue((boolean)customizationEngine.isTypeUnderlined(someEClass.eClass(), (EObject)someEClass));
        Assert.assertFalse((boolean)customizationEngine.isTypeStruckthrough(someEClass.eClass(), (EObject)someEClass));
    }

    @Test
    public void testUICustomWithCondition() throws Exception {
        this.refreshWorkspace();
        ModelQuerySetCatalog.getSingleton();
        CustomizationEngine customizationEngine = new CustomizationEngine();
        customizationEngine.registerCustomization(this.getCustomization("testCustomization"));
        customizationEngine.loadCustomizations();
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
        EClass classFalse = (EClass)ePackage.getEClassifier("EOperation");
        EClass classTrue = (EClass)ePackage.getEClassifier("EPackage");
        Assert.assertFalse((String)"shouldn't be struckthrough", (boolean)customizationEngine.isTypeStruckthrough(classFalse.eClass(), (EObject)classFalse));
        Assert.assertTrue((String)"should be struckthrough", (boolean)customizationEngine.isTypeStruckthrough(classTrue.eClass(), (EObject)classTrue));
    }

    @Test
    public void checkDisplay() {
        Display.getCurrent();
    }

    @Test
    public void testWorkspaceCustomizationHidesRegistryCustomization() throws Exception {
        this.refreshWorkspace();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testWorkspaceCustomizationHidesRegistryCustomization");
        ProjectUtils.create((IProject)project, (IProgressMonitor)new NullProgressMonitor());
        FileUtils.copyFileFromBundle((String)"workspaceCustomization.uiCustom", (IProject)project, (String)"testCustomization.uiCustom", (Bundle)Activator.getDefault().getBundle());
        ResourcesPlugin.getWorkspace().build(15, (IProgressMonitor)new NullProgressMonitor());
        ProjectUtils.refresh((IProject)project);
        CustomizationsCatalog.getInstance().waitUntilBuilt();
        MetamodelView customization = null;
        Collection allCustomizations = CustomizationsCatalog.getInstance().getAllCustomizations();
        for (MetamodelView metamodelView : allCustomizations) {
            if (!"testCustomization".equals(metamodelView.getName())) continue;
            Assert.assertTrue((String)"several customizations with the same name", (customization == null ? 1 : 0) != 0);
            customization = metamodelView;
        }
        try {
            EList types = customization.getTypes();
            boolean found = false;
            for (TypeView typeView : types) {
                if (!"ecore.EParameter".equals(typeView.getMetaclassName())) continue;
                found = true;
                CustomViewFeature customViewFeature = (CustomViewFeature)typeView.getCustomizedFeatures().get(0);
                Assert.assertTrue((customViewFeature.getCustomizedFeature() == CustomizableFeatures.LABEL ? 1 : 0) != 0);
                StaticFeatureValue defaultValue = (StaticFeatureValue)customViewFeature.getDefaultValue();
                Assert.assertTrue((boolean)defaultValue.getValue().equals("testWorkspaceCustomizationHidesRegistryCustomization"));
            }
            Assert.assertTrue((String)"Customization for ecore.EParameter not found", (boolean)found);
        }
        catch (Exception e) {
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource r = rs.createResource(URI.createURI((String)("tmp://" + System.currentTimeMillis())));
            r.getContents().add((Object)customization);
            ByteArrayOutputStream outputstream = new ByteArrayOutputStream();
            r.save((OutputStream)outputstream, Collections.emptyMap());
            throw new RuntimeException(outputstream.toString(), e);
        }
    }

    private void refreshWorkspace() throws CoreException {
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testBug304018() {
        CustomizationEngine customizationEngine = new CustomizationEngine();
        customizationEngine.registerCustomization(this.getCustomization("testBug304018"));
        customizationEngine.loadCustomizations();
        EClass anEClass = EcoreFactory.eINSTANCE.createEClass();
        EPackage anEPackage = EcoreFactory.eINSTANCE.createEPackage();
        Assert.assertFalse((boolean)customizationEngine.isAttributeUnderlined(anEClass.eClass(), "name", (EObject)anEClass));
        Assert.assertTrue((boolean)customizationEngine.isAttributeUnderlined(anEPackage.eClass(), "name", (EObject)anEPackage));
    }

    @Test
    public void testBug299277() throws CoreException, IOException, InterruptedException, ModelQueryException {
        String projectName = "testBug299277";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        ProjectUtils.create((IProject)project, (IProgressMonitor)new NullProgressMonitor());
        FileUtils.copyFileFromBundle((String)(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + FILE_EXT), (IProject)project, (String)(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + FILE_EXT), (Bundle)Activator.getDefault().getBundle());
        ResourcesPlugin.getWorkspace().build(15, (IProgressMonitor)new NullProgressMonitor());
        ProjectUtils.refresh((IProject)project);
        MetamodelView metamodelView = null;
        Assert.assertTrue((CustomizationsCatalog.getInstance().getWorkspaceCustomizations().size() >= 1 ? 1 : 0) != 0);
        StringBuffer listOfWorkspaceCustomization = new StringBuffer();
        for (MetamodelView currentMetamodelView : CustomizationsCatalog.getInstance().getWorkspaceCustomizations()) {
            listOfWorkspaceCustomization.append(currentMetamodelView.getName());
            if (!currentMetamodelView.getName().equals(Activator.getDefault().getBundle().getSymbolicName())) continue;
            metamodelView = currentMetamodelView;
        }
        if (metamodelView == null) {
            throw new RuntimeException(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + "not found. Available customizations are : \n" + listOfWorkspaceCustomization.toString());
        }
        Assert.assertNotNull(metamodelView);
        DerivedFeatureValue derivedFeatureValue = (DerivedFeatureValue)((CustomViewFeature)((TypeView)metamodelView.getTypes().get(0)).getCustomizedFeatures().get(0)).getDefaultValue();
        ModelQuery modelQuery = derivedFeatureValue.getValueCalculator();
        ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
        AbstractModelQuery myModelQuery = catalog.getModelQueryImpl(modelQuery);
        String result = (String)myModelQuery.basicEvaluate((EObject)modelQuery);
        Assert.assertEquals((Object)"org.eclipse.emf.facet.infra.browser.custom.tests", (Object)result);
    }

    @Test
    public void test001() throws CoreException, IOException, InterruptedException {
        String projectName = "test001";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        ProjectUtils.create((IProject)project, (IProgressMonitor)new NullProgressMonitor());
        FileUtils.copyFileFromBundle((String)(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + FILE_EXT), (IProject)project, (String)(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + FILE_EXT), (Bundle)Activator.getDefault().getBundle());
        ResourcesPlugin.getWorkspace().build(15, (IProgressMonitor)new NullProgressMonitor());
        ProjectUtils.refresh((IProject)project);
        CustomizationsCatalog.getInstance().waitUntilBuilt();
        MetamodelView metamodelView = null;
        Assert.assertTrue((CustomizationsCatalog.getInstance().getWorkspaceCustomizations().size() >= 1 ? 1 : 0) != 0);
        for (MetamodelView currentMetamodelView : CustomizationsCatalog.getInstance().getWorkspaceCustomizations()) {
            if (!currentMetamodelView.getName().equals(Activator.getDefault().getBundle().getSymbolicName())) continue;
            metamodelView = currentMetamodelView;
        }
        Assert.assertNotNull(metamodelView);
        DerivedFeatureValue derivedFeatureValue = (DerivedFeatureValue)((CustomViewFeature)((TypeView)metamodelView.getTypes().get(0)).getCustomizedFeatures().get(0)).getDefaultValue();
        ModelQuery modelQuery = derivedFeatureValue.getValueCalculator();
        ModelQuerySetCatalog modelQuerySetCatalog = ModelQuerySetCatalog.getSingleton();
        ModelQuerySet modelQuerySet2 = modelQuerySetCatalog.getModelQuerySet(modelQuery.getModelQuerySet().getName());
        ModelQuery modelQuery2 = modelQuerySet2.getQuery(modelQuery.getName());
        Assert.assertEquals((Object)modelQuery2, (Object)modelQuery);
    }

    private MetamodelView getCustomization(String name) {
        Collection allCustomizations = CustomizationsCatalog.getInstance().getAllCustomizations();
        for (MetamodelView metamodelView : allCustomizations) {
            if (!name.equals(metamodelView.getName())) continue;
            return metamodelView;
        }
        throw new IllegalStateException("Customization not found: " + name);
    }

    private FacetSet getFacetSet(String name) {
        FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet(name);
        if (facetSet != null) {
            return facetSet;
        }
        throw new IllegalStateException("FacetSet not found: " + name);
    }

    @Test
    public void bug309657() throws Exception {
        IProject project = ProjectUtils.createTestProject((String)"bug309657", (Bundle)Activator.getDefault().getBundle(), (String)".");
        FileUtils.copyFileFromBundle((String)"bug309657.uiCustom", (IProject)project, (String)"bug309657.uiCustom", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)project);
        IFolder folder = project.getFolder("f1");
        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IFile sourceFile = project.getFile("bug309657.uiCustom");
        IPath sourcePath = sourceFile.getFullPath();
        Path targetPath = new Path(folder.getFullPath() + "/" + "bug309657" + FILE_EXT);
        sourceFile.move((IPath)targetPath, true, (IProgressMonitor)new NullProgressMonitor());
        ProjectUtils.refresh((IProject)project);
        IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)targetPath);
        IMarker[] markers = targetFile.findMarkers(AbstractEmfFacetCatalog.PROBLEM_MARKER, true, 2);
        Assert.assertEquals((long)0L, (long)markers.length);
        targetFile.move(sourcePath, true, (IProgressMonitor)new NullProgressMonitor());
        ProjectUtils.refresh((IProject)project);
        markers = sourceFile.findMarkers(AbstractEmfFacetCatalog.PROBLEM_MARKER, true, 2);
        Assert.assertEquals((long)0L, (long)markers.length);
    }

    @Test
    public void emffacetProtocol() {
        URI uri = URI.createURI((String)"emffacet:/customization/testCustomization");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource r = resourceSet.getResource(uri, true);
        EObject root = (EObject)r.getContents().get(0);
        Assert.assertTrue((String)"A MetamodelView instance is expected as root element.", (boolean)(root instanceof MetamodelView));
        MetamodelView metamodelView = (MetamodelView)root;
        Assert.assertEquals((Object)"testCustomization", (Object)metamodelView.getName());
    }

    @Test
    public void bug306724() throws Exception {
        String name = "bug306724";
        IProject project = ProjectUtils.createTestProject((String)name, (Bundle)Activator.getDefault().getBundle(), (String)".");
        FileUtils.copyFileFromBundle((String)(String.valueOf(name) + FILE_EXT), (IProject)project, (String)(String.valueOf(name) + FILE_EXT), (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)project);
        CustomizationsCatalog.getInstance().waitUntilBuilt();
        MetamodelView customization = (MetamodelView)CustomizationsCatalog.getInstance().getRootObject(name);
        Assert.assertNotNull((Object)customization);
        project.close((IProgressMonitor)new NullProgressMonitor());
        CustomizationsCatalog.getInstance().waitUntilBuilt();
        customization = (MetamodelView)CustomizationsCatalog.getInstance().getRootObject(name);
        Assert.assertNull((Object)customization);
        project.open((IProgressMonitor)new NullProgressMonitor());
        CustomizationsCatalog.getInstance().waitUntilBuilt();
        customization = (MetamodelView)CustomizationsCatalog.getInstance().getRootObject(name);
        Assert.assertNotNull((Object)customization);
        project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        CustomizationsCatalog.getInstance().waitUntilBuilt();
        customization = (MetamodelView)CustomizationsCatalog.getInstance().getRootObject(name);
        Assert.assertNull((Object)customization);
    }

    @Test
    public void bug307187() throws Exception {
        IProject project = ProjectUtils.createTestProject((String)"bug307187", (Bundle)Activator.getDefault().getBundle(), (String)".");
        FileUtils.copyFileFromBundle((String)"bug307187.uiCustom", (IProject)project, (String)"1/bug307187.uiCustom", (Bundle)Activator.getDefault().getBundle());
        FileUtils.copyFileFromBundle((String)"bug307187.uiCustom", (IProject)project, (String)"2/bug307187.uiCustom", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)project);
        CustomizationsCatalog.getInstance().waitUntilBuilt();
        IFile customizationFile1 = project.getFile((IPath)new Path("1/bug307187.uiCustom"));
        IFile customizationFile2 = project.getFile((IPath)new Path("2/bug307187.uiCustom"));
        IMarker[] markers1 = customizationFile1.findMarkers(null, true, 2);
        IMarker[] markers2 = customizationFile2.findMarkers(null, true, 2);
        Assert.assertEquals((long)1L, (long)(markers1.length + markers2.length));
    }

    @Test
    public void bug336502() throws Exception {
        ModelQuerySetCatalog.getSingleton();
        CustomizationEngine customizationEngine = new CustomizationEngine();
        customizationEngine.registerCustomization(this.getCustomization("testBug304018"));
        customizationEngine.loadCustomizations();
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
        EClass anEclass = (EClass)ePackage.getEClassifier("EOperation");
        AppearanceConfiguration appearanceConfiguration = new AppearanceConfiguration(new ItemsFactory());
        appearanceConfiguration.setShowAttributes(true);
        appearanceConfiguration.getFacetContext().addFacetSet(this.getFacetSet("bug336502"));
        appearanceConfiguration.getCustomizationEngine().registerCustomization(this.getCustomization("bug336502"));
        appearanceConfiguration.getCustomizationEngine().loadCustomizations();
        ModelElementItem modelElementItem = new ModelElementItem((EObject)anEclass, null, appearanceConfiguration);
        List children = modelElementItem.getChildren();
        boolean foundSelf = false;
        for (Object object : children) {
            AttributeItem attributeItem;
            ModelElementItem elementItem;
            if (object instanceof ModelElementItem && (elementItem = (ModelElementItem)object).getEObject() == anEclass) {
                foundSelf = true;
            }
            if (!(object instanceof AttributeItem) || !((attributeItem = (AttributeItem)object).getAttribute() instanceof FacetAttribute)) continue;
            Assert.fail((String)"The customization should hide the FacetAttribute");
        }
        Assert.assertTrue((String)"The element should appear directly in its own children with 'collapse links' on a FacetReference with the 'identity' query", (boolean)foundSelf);
    }

    @Test
    public void bug341222() throws Exception {
        CustomizationEngine customizationEngine = new CustomizationEngine();
        customizationEngine.registerCustomization(this.getCustomization("bug341222"));
        customizationEngine.registerMetamodel("http://www.eclipse.org/uml2/3.0.0/UML");
        customizationEngine.loadCustomizations();
        EPackage umlPackage = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/uml2/3.0.0/UML");
        EClass anEclass = (EClass)umlPackage.getEClassifier("Class");
        Assert.assertTrue((String)"customization defined on ecore.EModelElement should also apply to uml.Class", (boolean)customizationEngine.isReferenceUnderlinedStatic(anEclass, "eAnnotations"));
    }
}

