/*******************************************************************************
 * Copyright (c) 2009, 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.emf.facet.infra.browser.editors;

import org.eclipse.emf.facet.infra.browser.core.MetaclassList;
import org.eclipse.emf.facet.infra.browser.core.SearchResults;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BrowserContentProvider implements ITreeContentProvider {

	public Object[] getElements(final Object inputElement) {
		if (inputElement instanceof MetaclassList) {
			final MetaclassList metaclassList = (MetaclassList) inputElement;
			return metaclassList.getElements().toArray();
		} else if (inputElement instanceof SearchResults) {
			final SearchResults searchResults = (SearchResults) inputElement;
			return searchResults.getElements().toArray();
		} else if (inputElement == EcoreBrowser.LOADING_MESSAGE) {
			return new Object[] { EcoreBrowser.LOADING_MESSAGE };
		}
		return null;
	}

	public Object[] getChildren(final Object parentElement) {
		if (parentElement instanceof ITreeElement) {
			final ITreeElement treeElement = (ITreeElement) parentElement;
			return treeElement.getChildren().toArray();
		}
		return null;
	}

	public Object getParent(final Object element) {
		if (element instanceof ITreeElement) {
			final ITreeElement treeElement = (ITreeElement) element;
			return treeElement.getTreeParent();
		}
		return null;
	}

	public boolean hasChildren(final Object element) {
		if (element instanceof ITreeElement) {
			final ITreeElement treeElement = (ITreeElement) element;
			return treeElement.hasChildren();
		}
		return false;
	}

	public void dispose() {
		// nothing
	}

	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
		// nothing
	}
}
