/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.facet.infra.common.core.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.facet.infra.common.core.internal.CommonEmfFacetActivator;
import org.eclipse.emf.facet.infra.common.core.logging.Logger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/**
 * @deprecated The class
 *             org.eclipse.emf.facet.infra.common.core.internal.utils.PluginUtils
 *             has been replaced by
 *             org.eclipse.emf.facet.util.core.internal.PluginUtils.
 * @see org.eclipse.emf.facet.util.core.internal.PluginUtils
 * Cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=339259
 */
@Deprecated
public final class PluginUtils {

	private PluginUtils() {
		// utilities class
	}

	/**
	 * Returns whether the given file is registered in the plugin.xml of the
	 * given project, using the given extension point.
	 * 
	 * @param extensionPoint
	 *            the extension point that is used to register elements of this
	 *            kind (elements must be declared with a "file" attribute)
	 */
	public static boolean isRegistered(final IFile elementFile, final String extensionPoint) {
		final IProject project = elementFile.getProject();
		IPluginModelBase pluginModel = PluginRegistry.findModel(project);
		if (pluginModel != null) {
			IPluginExtension[] extensions = pluginModel.getExtensions().getExtensions();
			for (IPluginExtension pluginExtension : extensions) {
				if (extensionPoint.equals(pluginExtension.getPoint())) {
					IPluginObject[] children = pluginExtension.getChildren();
					for (IPluginObject child : children) {
						if (child instanceof IPluginElement) {
							IPluginElement pluginElement = (IPluginElement) child;
							IPluginAttribute[] attributes = pluginElement.getAttributes();
							for (IPluginAttribute pluginAttribute : attributes) {
								if ("file".equalsIgnoreCase(pluginAttribute.getName())) { //$NON-NLS-1$
									String strFile = pluginAttribute.getValue();
									if (strFile != null && strFile.length() > 0) {
										IFile file = project.getFile(strFile);
										if (file.exists() && elementFile.equals(file)) {
											return true;
										}
									}
								}
							}
						}
					}
				}
			}
		}
		return false;
	}

	/**
	 * Registers the given file in the plugin.xml of the given project, using
	 * the given extension point.
	 * 
	 * @param project
	 *            the project in which the element should be registered
	 * @param extensionToCheck
	 *            the file extension of the element that should be registered
	 * @param extensionPoint
	 *            the extension point that is used to register elements of this
	 *            kind (elements must be declared with a "file" attribute)
	 */
	/**
	 * Registers the given file in the plugin.xml of the given project, using
	 * the given extension point.
	 * 
	 * @param file
	 *            the file to register
	 * @param extensionPointId
	 *            the extension point that is used to register the file
	 * @param elementName
	 *            the name of the XML element in which an attribute named "file"
	 *            will be set to the path of the file
	 */
	public static void register(final IFile file, final String extensionPointId,
			final String elementName) {
		if (isRegistered(file, extensionPointId)) {
			return;
		}

		IPath filePath = file.getFullPath().removeFirstSegments(1);
		final IProject project = file.getProject();

		IFile pluginXML = project.getFile("plugin.xml"); //$NON-NLS-1$
		if (pluginXML.exists()) {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder docBuilder;

			// <extension
			// point="org.eclipse.emf.facet.infra.query.registration">
			// <modelqueryset file="abc.querySet"/>
			// </extension>

			try {
				docBuilder = docFactory.newDocumentBuilder();
				Document doc = docBuilder.parse(pluginXML.getLocation().toOSString());
				Element root = doc.getDocumentElement();

				Text whitespace = doc.createTextNode("   "); //$NON-NLS-1$
				root.appendChild(whitespace);

				Node extensionNode = doc.createElement("extension"); //$NON-NLS-1$
				Attr pointAttr = doc.createAttribute("point"); //$NON-NLS-1$
				pointAttr.setValue(extensionPointId);
				extensionNode.getAttributes().setNamedItem(pointAttr);
				root.appendChild(extensionNode);

				Node elementNode = doc.createElement(elementName);
				Attr fileAttr = doc.createAttribute("file"); //$NON-NLS-1$
				fileAttr.setValue(filePath.toString());
				elementNode.getAttributes().setNamedItem(fileAttr);
				extensionNode.appendChild(elementNode);

				TransformerFactory transformerFactory = TransformerFactory.newInstance();
				final int indent = 3;
				transformerFactory.setAttribute("indent-number", new Integer(indent)); //$NON-NLS-1$
				Transformer transformer = transformerFactory.newTransformer();
				transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8"); //$NON-NLS-1$
				transformer.setOutputProperty(OutputKeys.INDENT, "yes"); //$NON-NLS-1$
				StreamResult result = new StreamResult(new StringWriter());
				DOMSource source = new DOMSource(doc);
				transformer.transform(source, result);
				String xmlString = result.getWriter().toString();

				byte[] byteArray = xmlString.getBytes("UTF-8"); //$NON-NLS-1$
				pluginXML.setContents(new ByteArrayInputStream(byteArray), true, true,
						new NullProgressMonitor());

			} catch (Exception e) {
				Logger.logError(e, CommonEmfFacetActivator.getDefault());
			}
		} else {
			try {
				// create plugin.xml
				final String template = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" //$NON-NLS-1$
						+ "<?eclipse version=\"3.4\"?>\n" + "<plugin>\n" //$NON-NLS-1$ //$NON-NLS-2$
						+ "   <extension point=\"{0}\">\n" + "      <{1} file=\"{2}\"/>\n" //$NON-NLS-1$ //$NON-NLS-2$
						+ "   </extension>\n" //$NON-NLS-1$
						+ "</plugin>\n"; //$NON-NLS-1$

				String content = NLS.bind(template, new Object[] { extensionPointId, elementName,
						filePath.toString() });
				byte[] byteArray;
				byteArray = content.getBytes("UTF-8"); //$NON-NLS-1$
				pluginXML.create(new ByteArrayInputStream(byteArray), true,
						new NullProgressMonitor());
				try {
					BuildPropertiesUtils.addToBuild(pluginXML);
				} catch (Exception e) {
					Logger.logError(e, "Error adding file " + pluginXML.getFullPath() //$NON-NLS-1$
							+ " to the build.properties", null); //$NON-NLS-1$
				}
			} catch (Exception e) {
				Logger.logError(e, CommonEmfFacetActivator.getDefault());
			}
		}

		// try {
		// IPluginModelBase pluginModel = PluginRegistry.findModel(project);
		// IExtensionsModelFactory factory = pluginModel.getFactory();
		// IPluginExtension extension = factory.createExtension();
		// extension.setPoint(extensionPointId);
		// IPluginElement element = factory.createElement(extension);
		// element.setName(elementName);
		//			element.setAttribute("file", filePath.toPortableString()); //$NON-NLS-1$
		// pluginModel.getExtensions().add(extension);
		// ((IEditableModel) pluginModel).save();
		// } catch (Exception e) {
		// Logger.logError(e, CommonEmfFacetActivator.getDefault());
		// }
	}
}
