/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.tests.internal.notuithread;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget2;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.internal.INatTableWidgetInternal;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.UnsatisfiedConfigurationConstraint;
import org.eclipse.emf.facet.widgets.nattable.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.editor.NatTableEditorFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Bug354224Test {
    private static final int TIMEOUT = 30000;
    private static final String BUG_ID = Bug354224Test.class.getSimpleName().replaceAll("Test", new String());
    private static final String RESOURCE_FOLDER = "resources/" + BUG_ID + '/';
    private static final String UML_FILE_PATH = String.valueOf(RESOURCE_FOLDER) + BUG_ID + ".uml";
    private static final String PROJECT_NAME = Bug354224Test.class.getName();
    private static final String FACET_VISIBILITY_SYMBOL = "Bug354224_visibilitySymbol";
    private static final String FACET_ENUM = "Bug354224_enum";
    private INatTableWidget2 iNatTableWidget2;
    private List<EObject> initialContent;
    private final List<CoreException> exceptionList = new ArrayList<CoreException>();
    private TableInstance tableInstance;
    private int nbNonFacetColumns;

    @Before
    public void init() throws CoreException, IOException {
        this.exceptionList.clear();
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        SWTBotUtils.deleteAllProjects();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)(String.valueOf('/') + UML_FILE_PATH), (IProject)project, (String)(String.valueOf('/') + UML_FILE_PATH), (Bundle)bundle);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI umlFileUri = URI.createPlatformResourceURI((String)(String.valueOf(PROJECT_NAME) + '/' + UML_FILE_PATH), (boolean)false);
        Resource umlModelResource = resourceSet.getResource(umlFileUri, true);
        this.initialContent = new ArrayList<EObject>();
        TreeIterator iterator = umlModelResource.getAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof Class)) continue;
            this.initialContent.add(eObject);
        }
        Assert.assertTrue((this.initialContent.size() > 0 ? 1 : 0) != 0);
        final EditingDomain finalEditingDomain = this.initEditingDomain((ResourceSet)resourceSet);
        final List<EObject> eObjectsToAddInTheTable = this.initialContent;
        final INatTableWidget2[] finalNatTableWidgetList = new INatTableWidget2[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    NatTableEditorFactory.getInstance().openOn(eObjectsToAddInTheTable, finalEditingDomain, "", null, null, null);
                }
                catch (UnsatisfiedConfigurationConstraint e) {
                    throw new RuntimeException(e);
                }
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = activePage.getActiveEditor();
                INatTableWidgetProvider iNatTableWidgetProvider = (INatTableWidgetProvider)editor.getAdapter(INatTableWidgetProvider.class);
                finalNatTableWidgetList[0] = (INatTableWidget2)iNatTableWidgetProvider.getNatTableWidget();
            }
        });
        this.iNatTableWidget2 = finalNatTableWidgetList[0];
        this.tableInstance = this.iNatTableWidget2.getTableInstance();
        this.nbNonFacetColumns = this.tableInstance.getColumns().size();
    }

    protected abstract EditingDomain initEditingDomain(ResourceSet var1);

    @After
    public void closeAllEditors() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
                }
            }
        });
    }

    @Test(timeout=30000L)
    public void test() {
        FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet(BUG_ID);
        Facet facetVisibility = facetSet.getFacet(FACET_VISIBILITY_SYMBOL);
        Facet facetEnum = facetSet.getFacet(FACET_ENUM);
        ArrayList<Facet> facets = new ArrayList<Facet>();
        facets.add(facetEnum);
        this.check(facets);
        facets.add(facetVisibility);
        this.check(facets);
        facets.remove(facetEnum);
        this.check(facets);
        facets.remove(facetVisibility);
        this.check(facets);
        facets.add(facetEnum);
        this.check(facets);
        facets.add(facetVisibility);
        this.check(facets);
    }

    private void check(final List<Facet> facets) {
        final INatTableWidget2 finalInINatTableWidget2 = this.iNatTableWidget2;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    finalInINatTableWidget2.setFacets((Collection)facets);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ((INatTableWidgetInternal)finalInINatTableWidget2).waitForResfreshJob();
            }
        });
        int nbColumns = this.tableInstance.getColumns().size();
        Assert.assertEquals((long)(this.nbNonFacetColumns + facets.size()), (long)nbColumns);
        if (this.tableInstance instanceof INatTableWidgetInternal) {
            INatTableWidgetInternal iNatTableWidgetInternal = (INatTableWidgetInternal)this.tableInstance;
            int nbVisibleColumnsUsingTheLayer = iNatTableWidgetInternal.getVisibleColumnsUsingTheLayer().size();
            Assert.assertEquals((long)(this.nbNonFacetColumns + facets.size()), (long)nbVisibleColumnsUsingTheLayer);
        }
    }
}

