/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.facet.util.core.internal.AbstractLogListenerTest;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.TableUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.ITableEditorFactory;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bug345730Test
extends AbstractLogListenerTest {
    private static final int TIMEOUT = 30000;
    private static final String CORE_JOBS_PLUGIN_ID = "org.eclipse.core.jobs";
    private static final String WIDGET_NATTABLE_PLUGIN_ID = "org.eclipse.emf.facet.widgets.nattable";
    private static final boolean DEBUG = Platform.inDebugMode();
    private static final String BUG_ID = "345730";
    private static final String RESOURCE_FOLDER = "resources/v0_2/Bug345730/";
    private static final String ECORE_FILE_PATH = "resources/v0_2/Bug345730/_Bug345730_EcoreModel.ecore";
    private static final String PROJECT_NAME = Bug345730Test.class.getName();
    private static final String TABLE_FILE_PATH = "tmp.table";
    private ITableWidget tableWidget;
    private List<EObject> initialContent;
    private EPackage ePackage;
    private ResourceSetImpl resourceSet;
    private final List<CoreException> exceptionList = new ArrayList<CoreException>();

    @Before
    public void init() throws CoreException, IOException {
        this.exceptionList.clear();
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        SWTBotUtils.deleteAllProjects();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/Bug345730/_Bug345730_EcoreModel.ecore", (IProject)project, (String)"/resources/v0_2/Bug345730/_Bug345730_EcoreModel.ecore", (Bundle)bundle);
        this.resourceSet = new ResourceSetImpl();
        URI ecoreFileUri = URI.createPlatformResourceURI((String)(String.valueOf(PROJECT_NAME) + '/' + ECORE_FILE_PATH), (boolean)false);
        Resource ecoreModelResource = this.resourceSet.getResource(ecoreFileUri, true);
        this.ePackage = (EPackage)ecoreModelResource.getContents().get(0);
        this.initialContent = new ArrayList<EObject>();
        this.initialContent.addAll((Collection<EObject>)this.ePackage.eContents());
    }

    protected void initVariables() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = activePage.getActiveEditor();
        ITableWidgetProvider tTableWidgetProvider = (ITableWidgetProvider)editor.getAdapter(ITableWidgetProvider.class);
        junit.framework.Assert.assertNotNull((Object)tTableWidgetProvider);
        this.tableWidget = tTableWidgetProvider.getTableWidget();
    }

    @Test(timeout=30000L)
    public void deleteOneElementWithTransactionnalEditingDomain() throws CoreException {
        ArrayList<EObject> elementsToDelete = new ArrayList<EObject>();
        elementsToDelete.add(this.initialContent.get(0));
        this.deleteElementWithTransactionnalEditingDomain(elementsToDelete);
    }

    @Test(timeout=30000L)
    public void deleteAllElementWithTransactionnalEditingDomain() throws CoreException {
        ArrayList<EObject> elementsToDelete = new ArrayList<EObject>();
        elementsToDelete.addAll(this.initialContent);
        this.deleteElementWithTransactionnalEditingDomain(elementsToDelete);
    }

    @Test(timeout=30000L)
    public void deleteAllExceptOneElementWithTransactionnalEditingDomain() throws CoreException {
        ArrayList<EObject> elementsToDelete = new ArrayList<EObject>();
        elementsToDelete.addAll(this.initialContent);
        elementsToDelete.remove(0);
        this.deleteElementWithTransactionnalEditingDomain(elementsToDelete);
    }

    private void deleteElementWithTransactionnalEditingDomain(List<EObject> elementsToDelete) throws CoreException {
        if (DEBUG) {
            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".deleteElementWithTransactionnalEditingDoamin()");
        }
        URI uri = URI.createPlatformPluginURI((String)(String.valueOf(PROJECT_NAME) + '/' + TABLE_FILE_PATH), (boolean)false);
        Resource tableResource = this.resourceSet.createResource(uri);
        final Table tableInstance = TableUtils.createTableInstance(this.initialContent, (String)new String(), null, null, null);
        tableResource.getContents().add((Object)tableInstance);
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)this.resourceSet);
        Display.getDefault().syncExec(new Runnable((EditingDomain)editingDomain){
            private final /* synthetic */ EditingDomain val$editingDomain;
            {
                this.val$editingDomain = editingDomain;
            }

            public void run() {
                ITableEditorFactory.DEFAULT.openOn(tableInstance, this.val$editingDomain);
                Bug345730Test.this.initVariables();
            }
        });
        List<CoreException> finalExceptionList = this.exceptionList;
        DeleteRunnable runnable = new DeleteRunnable((EditingDomain)editingDomain, (EditingDomain)editingDomain, finalExceptionList){
            private final /* synthetic */ EditingDomain val$editingDomain;
            private final /* synthetic */ List val$finalExceptionList;
            {
                this.val$editingDomain = editingDomain;
                this.val$finalExceptionList = list;
                super($anonymous0);
            }

            public void executeInStack(Command command) {
                TransactionalCommandStack transactionalCommandStack = (TransactionalCommandStack)this.val$editingDomain.getCommandStack();
                try {
                    transactionalCommandStack.execute(command, Collections.EMPTY_MAP);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (RollbackException e) {
                    this.val$finalExceptionList.add(new CoreException(e.getStatus()));
                }
            }
        };
        this.deleteElement((EditingDomain)editingDomain, runnable, elementsToDelete);
    }

    @Test(timeout=30000L)
    public void deleteOneElementWithRegularEditingDomain() throws CoreException {
        ArrayList<EObject> elementsToDelete = new ArrayList<EObject>();
        elementsToDelete.add(this.initialContent.get(0));
        this.deleteElementWithRegularEditingDomain(elementsToDelete);
    }

    @Test(timeout=30000L)
    public void deleteAllElementWithRegularEditingDomain() throws CoreException {
        ArrayList<EObject> elementsToDelete = new ArrayList<EObject>();
        elementsToDelete.addAll(this.initialContent);
        this.deleteElementWithRegularEditingDomain(elementsToDelete);
    }

    private void deleteElementWithRegularEditingDomain(List<EObject> elementsToDelete) throws CoreException {
        if (DEBUG) {
            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".deleteElementWithRegularEditingDoamin()");
        }
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
        final List<EObject> finalInitialContents = this.initialContent;
        Display.getDefault().syncExec(new Runnable((EditingDomain)editingDomain){
            private final /* synthetic */ EditingDomain val$editingDomain;
            {
                this.val$editingDomain = editingDomain;
            }

            public void run() {
                ITableEditorFactory.DEFAULT.openOn(finalInitialContents, this.val$editingDomain, "", null, null, null);
                Bug345730Test.this.initVariables();
            }
        });
        DeleteRunnable runnable = new DeleteRunnable((EditingDomain)editingDomain, (EditingDomain)editingDomain){
            private final /* synthetic */ EditingDomain val$editingDomain;
            {
                this.val$editingDomain = editingDomain;
                super($anonymous0);
            }

            public void executeInStack(Command command) {
                this.val$editingDomain.getCommandStack().execute(command);
            }
        };
        this.deleteElement((EditingDomain)editingDomain, runnable, elementsToDelete);
    }

    private void deleteElement(EditingDomain editingDomain, DeleteRunnable commmandExecution, List<EObject> elementToDelete) throws CoreException {
        this.deleteElementCore(editingDomain, commmandExecution, elementToDelete);
        this.deleteElementCore(editingDomain, commmandExecution, elementToDelete);
    }

    private void deleteElementCore(EditingDomain editingDomain, DeleteRunnable commmandExecution, List<EObject> elementToDelete) throws CoreException {
        int initialContentSize = this.initialContent.size();
        Assert.assertNotNull((Object)this.tableWidget);
        EList rows = this.tableWidget.getTable().getRows();
        junit.framework.Assert.assertEquals((int)initialContentSize, (int)rows.size());
        junit.framework.Assert.assertEquals((int)initialContentSize, (int)this.ePackage.getEClassifiers().size());
        if (DEBUG) {
            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + ": Remove element");
        }
        commmandExecution.setElementToDelete(elementToDelete);
        commmandExecution.run();
        if (!this.exceptionList.isEmpty()) {
            throw this.exceptionList.get(0);
        }
        junit.framework.Assert.assertEquals((int)(initialContentSize - elementToDelete.size()), (int)this.ePackage.getEClassifiers().size());
        rows = this.tableWidget.getTable().getRows();
        junit.framework.Assert.assertEquals((int)(initialContentSize - elementToDelete.size()), (int)rows.size());
        this.checkUndo(editingDomain, initialContentSize);
        this.checkRedo(editingDomain, elementToDelete, initialContentSize);
        this.checkUndo(editingDomain, initialContentSize);
        this.checkRedo(editingDomain, elementToDelete, initialContentSize);
        this.checkUndo(editingDomain, initialContentSize);
    }

    private void checkRedo(EditingDomain editingDomain, List<EObject> elementToDelete, int initialContentSize) {
        if (DEBUG) {
            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".deleteElementCore(): redo");
        }
        editingDomain.getCommandStack().redo();
        junit.framework.Assert.assertEquals((int)(initialContentSize - elementToDelete.size()), (int)this.ePackage.getEClassifiers().size());
        EList rows = this.tableWidget.getTable().getRows();
        junit.framework.Assert.assertEquals((int)(initialContentSize - elementToDelete.size()), (int)rows.size());
    }

    private void checkUndo(EditingDomain editingDomain, int initialContentSize) {
        if (DEBUG) {
            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".deleteElementCore(): undo");
        }
        editingDomain.getCommandStack().undo();
        EList rows = this.tableWidget.getTable().getRows();
        EList classifiers = this.ePackage.getEClassifiers();
        junit.framework.Assert.assertEquals((int)initialContentSize, (int)rows.size());
        junit.framework.Assert.assertEquals((int)initialContentSize, (int)classifiers.size());
    }

    @After
    public void closeAllEditors() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
                }
            }
        });
    }

    protected Bundle[] getPluginsToListen() {
        return new Bundle[]{Platform.getBundle((String)CORE_JOBS_PLUGIN_ID), Platform.getBundle((String)WIDGET_NATTABLE_PLUGIN_ID)};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class DeleteRunnable
    implements Runnable {
        private List<EObject> elementsToDelete;
        private final EditingDomain editingDomain;

        public DeleteRunnable(EditingDomain editingDomain) {
            this.editingDomain = editingDomain;
        }

        protected void setElementToDelete(List<EObject> pElementsToDelete) {
            this.elementsToDelete = pElementsToDelete;
        }

        @Override
        public void run() {
            Command command = null;
            ICommandFactory commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor(this.editingDomain);
            if (this.elementsToDelete.size() == 1) {
                command = commandFactory.createDeleteCommand(this.editingDomain, (Object)this.elementsToDelete.get(0));
            } else if (this.elementsToDelete.size() > 1) {
                ArrayList<Command> commandList = new ArrayList<Command>();
                for (EObject eObjectToDelete : this.elementsToDelete) {
                    Command deleteCommand = commandFactory.createDeleteCommand(this.editingDomain, (Object)eObjectToDelete);
                    commandList.add(deleteCommand);
                }
                command = new CompoundCommand(commandList);
            }
            if (command != null) {
                junit.framework.Assert.assertTrue((boolean)command.canExecute());
                this.executeInStack(command);
            }
        }

        public abstract void executeInStack(Command var1);
    }
}

