/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.sdk.ui.internal.query;

import java.util.LinkedList;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.Messages;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.exported.IQueryContext;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.exported.IQueryDialogFactoryStrategy;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.exported.widget.component.query.ICreateQueryWidget;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.query.GetQueryDialog;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.query.IQueryCreationResult;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.query.IQueryWidgetCompositeFactoryFactory;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialog;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IWithResultDialogCallback;
import org.eclipse.emf.facet.util.ui.internal.exported.util.dialog.SynchronizedAbstractDialog;
import org.eclipse.emf.facet.util.ui.internal.exported.util.widget.AbstractWidget;
import org.eclipse.emf.facet.util.ui.utils.PropertyElement;
import org.eclipse.emf.facet.util.ui.utils.UIUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectQueryTypeWidget
extends AbstractWidget {
    private static final int COLUMN_NUMBER = 2;
    private Combo combobox;
    private final PropertyElement queryProp;
    private Text textField;
    private final GridLayout gridLayout;
    private String alertMessage;
    private final boolean comboboxEnabled;
    private final IQueryContext queryContext;

    public SelectQueryTypeWidget(Composite parent, PropertyElement propertyElement, IQueryContext queryContext) {
        this(parent, propertyElement, false, queryContext);
    }

    public SelectQueryTypeWidget(Composite parent, PropertyElement queryProperty, boolean comboboxEnabled, IQueryContext queryContext) {
        super(parent);
        this.queryProp = queryProperty;
        this.comboboxEnabled = comboboxEnabled;
        this.gridLayout = new GridLayout(2, false);
        this.gridLayout.marginWidth = 0;
        this.queryContext = queryContext;
    }

    protected void addSubWidgets() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)this.gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        boolean enabled = this.comboboxEnabled;
        if (!this.comboboxEnabled) {
            enabled = this.queryProp.getValue() != null;
        }
        LinkedList<String> elements = new LinkedList<String>();
        elements.add(Messages.Select_query_type);
        elements.addAll(IQueryWidgetCompositeFactoryFactory.INSTANCE.getRegisteredQueryWidgetsComposite());
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SelectQueryTypeWidget.this.onSelection();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        };
        this.combobox = UIUtils.createCombobox((Composite)composite, (boolean)enabled, elements, (String)Messages.SelectQueryTypeWizardPage_Query_Type, (SelectionListener)listener);
        this.textField = UIUtils.createTextField((Composite)composite, (String)"", (boolean)false, null);
        this.refresh();
    }

    public IDialog<ICreateQueryWidget> selectQueryType(String selection) {
        IDialog<ICreateQueryWidget> result = null;
        int index = 0;
        String[] stringArray = this.combobox.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(selection)) {
                this.combobox.select(index);
                result = this.onSelection();
                break;
            }
            ++index;
            ++n2;
        }
        return result;
    }

    public String getError() {
        String result = null;
        if (this.queryProp.getValue() == null) {
            result = Messages.Facet_mustSelectQuery;
        }
        return result;
    }

    private void refresh() {
        this.combobox.select(0);
        if (this.combobox.isEnabled()) {
            if (this.queryProp.getValue() != null) {
                Query query = (Query)this.queryProp.getValue();
                this.textField.setText(query.toString());
            }
        } else {
            this.queryProp.setValue(null);
            if (this.alertMessage != null) {
                this.textField.setText(this.alertMessage);
            }
        }
    }

    public void setSelectionEnabled(boolean enabled) {
        this.combobox.setEnabled(enabled);
        this.refresh();
    }

    public boolean isSelectionEnabled() {
        return this.combobox.isEnabled();
    }

    public void setAlertMessage(String alertMessage) {
        this.alertMessage = alertMessage;
    }

    protected IDialog<ICreateQueryWidget> onSelection() {
        SynchronizedAbstractDialog result = null;
        int selectionIndex = this.combobox.getSelectionIndex();
        if (selectionIndex == 0) {
            this.queryProp.setValue(null);
            this.textField.setText(this.alertMessage);
        } else {
            String selectionName = this.combobox.getItem(selectionIndex);
            IQueryDialogFactoryStrategy strategy = IQueryWidgetCompositeFactoryFactory.INSTANCE.getQueryDialogFactoryStrategy(selectionName);
            IWithResultDialogCallback<IQueryCreationResult> callback = new IWithResultDialogCallback<IQueryCreationResult>(){

                public void commited(IQueryCreationResult qcResult) {
                    SelectQueryTypeWidget.this.onDialogCommitted(qcResult);
                }

                public void canceled(IQueryCreationResult qcResult) {
                    SelectQueryTypeWidget.this.checkQuery(null);
                }
            };
            GetQueryDialog dialog = new GetQueryDialog(callback, strategy, this.queryContext);
            Display.getDefault().asyncExec(new Runnable((IDialog)dialog){
                private final /* synthetic */ IDialog val$dialog;
                {
                    this.val$dialog = iDialog;
                }

                public void run() {
                    this.val$dialog.open();
                }
            });
            result = new SynchronizedAbstractDialog((IDialog)dialog, Display.getDefault());
        }
        return result;
    }

    public void notifyChanged() {
    }

    protected void onDialogCommitted(IQueryCreationResult qcResult) {
        if (this.checkQuery(qcResult.getQuery()) && qcResult.getLabel() != null) {
            this.textField.setText(qcResult.getLabel());
        }
    }

    protected boolean checkQuery(Query query) {
        if (query == null) {
            this.combobox.select(0);
            if (this.alertMessage != null) {
                this.textField.setText(this.alertMessage);
            }
        }
        if (query != null) {
            this.queryProp.setValue((Object)query);
        }
        return query != null;
    }

    public String getText() {
        return this.textField.getText();
    }
}

