/*******************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * 	  Gregoire Dupe (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *    Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *    Nicolas Guyomar (Mia-Software) - Bug 337454 - We can't delete a query Column
 *    Nicolas Guyomar (Mia-Software) - Bug 339922 - INatTableWidget method isCellSelected should use the plural
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.InstantiationMethod;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

/**
 * This interface defines every public action a user can perform on the EMF
 * Facet table widget
 * 
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public interface INatTableWidget extends ISelectionProvider {

	/**
	 * This method calls the last launched {@link InstantiationMethod} and adds
	 * the result to the table if any.
	 * 
	 * If no {@link InstantiationMethod} is saved, then a selection popup is
	 * opened for the user to choose one via
	 * {@link INatTableWidget#selectInstantiationMethodToLaunch()}
	 */
	public void createNewElement();

	/**
	 * This method calls the given {@link InstantiationMethod} and adds the
	 * result to the table if any.
	 * 
	 * @param instantiationMethod
	 *            an {@link InstantiationMethod}
	 */
	public void createNewElement(final InstantiationMethod instantiationMethod);

	/**
	 * Open a dialog to choose the default instantiationMethod to perform when
	 * clicking on the "Create" button.
	 */
	public void selectInstantiationMethodToLaunch();

	/**
	 * Performs the usual save action.
	 */
	public void save();

	/**
	 * Open a "Save As" dialog to serialize the table.
	 */
	public void saveAs();

	/**
	 * Open the query selection dialog. Add a column which contains the result
	 * of the selected query.
	 */
	public void addQueryColumn();

	/**
	 * This method performs to usual "copy to clipboard" action.
	 */
	public void copySelectionToClipboard();

	/**
	 * Delete the selected elements from their respective models and remove the
	 * corresponding line in the table.
	 */
	public void deleteSelection();

	/**
	 * Open a selection popup to select which columns to show/hide.
	 */
	public void selectColumnsToHide();

	/**
	 * Whether to hide columns which don't contain any elements.
	 * 
	 * @param hideEmptyColumns
	 *            <code>true</code> to hide columns which don't contain any
	 *            elements.
	 */
	public void setHideEmptyColumns(boolean hideEmptyColumns);

	/**
	 * Whether to show columns which are specific to a few elements (false), or
	 * only columns which are common to all the elements (true).
	 * 
	 * @param onlyShowCommonColumns
	 *            Whether to show columns which are specific to a few elements
	 *            (false), or only columns which are common to all the elements
	 *            (true)
	 */
	public void setOnlyShowCommonColumns(boolean onlyShowCommonColumns);

	/**
	 * Whether to sort columns by type of link (attributes first, then
	 * references, then derived references, ...).
	 * 
	 * @param sortColumnsByType
	 *            {@link Boolean} to sort columns by type of link
	 */
	public void sortColumnsByType();

	/**
	 * Allow the opening of an existing saved .table file within the current
	 * table widget.
	 */
	public void openSavedTable();

	/**
	 * Remove the selected lines from the table. The actual elements are not
	 * deleted. See {@link INatTableWidget#deleteSelection()} for that case.
	 */
	public void removeLine();

	/**
	 * Perform the usual "Select All" action on the table's cells
	 */
	public void selectAll();

	/**
	 * This method returns the {@link TableConfiguration} attached to the table.
	 * 
	 * @return the {@link TableConfiguration} attached to the table.
	 */
	public TableConfiguration getTableConfiguration();

	/**
	 * @return The history of launched instantiation methods.
	 */
	public List<InstantiationMethod> getInstantionMethodHistory();

	/**
	 * This method returns the {@link TableInstance} attached to the table.
	 * 
	 * @return returns the {@link TableInstance} attached to the table.
	 */
	public TableInstance getTableInstance();

	/**
	 * Return whether there is at least a cell selected in the table
	 * 
	 * @return Whether there is at least a cell selected in the table
	 */
	public boolean isCellSelected();

	/**
	 * Return whether there is at least a column selected in the table
	 * 
	 * @return whether there is at least a column selected in the table
	 */
	public boolean isColumnSelected();

	/**
	 * Return whether the selection of cells can be deleted.
	 * 
	 * @return Whether the selection of cells can be deleted.
	 */
	public boolean isCellsDeletable();

	/**
	 * Return whether the selected column can be deleted.
	 * 
	 * @return whether the selected column can be deleted.
	 */
	public boolean isSelectedColumnDeletable();

	/**
	 * @return the widget composite itself.
	 */
	public Control getComposite();

	/**
	 * Add a new row in the table for each given element.
	 * 
	 * @param newElements
	 *            the list of elements to add to the table
	 */
	public void addRows(List<EObject> newElements);

	/**
	 * Register an {@link ActionDelegate}. It will be notified after the opening
	 * of a saved table in a view.
	 * 
	 * @param action
	 *            the action to be registered
	 */
	public void registerActionDelegate(IActionDelegate action);

	/**
	 * Unregister an {@link ActionDelegate}
	 * 
	 * @param action
	 *            the action to be unregistered
	 */
	public void unregisterActionDelegate(IActionDelegate action);

	public Collection<ISelectionChangedListener> getSelectionChangedListeners();

	public void openLoadCustomizationDialog();

	public void openLoadFacetsDialog();

}
