/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.tests.internal;

import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.widgets.nattable.internal.INatTableWidget3;
import org.eclipse.emf.facet.widgets.nattable.internal.exported.ICanBePesentedQueryDialog;
import org.eclipse.emf.facet.widgets.nattable.internal.exported.IMustRemoveNonConformingElementsDialog;
import org.junit.Assert;
import org.junit.Test;

public class CanBePresentedInTheTableDialogTest {
    private INatTableWidget3 iNatTableWidget3;

    @Test
    public void notRejectingQuery() {
        this.iNatTableWidget3 = this.init();
        int initNbElement = this.iNatTableWidget3.getTableInstance().getElements().size();
        ICanBePesentedQueryDialog dialog1 = this.iNatTableWidget3.openCanBePresentedInTheTableDialog();
        Assert.assertEquals((String)"The selected query in the dialog must be the current canBePresentedQuery of the table widget", (Object)this.iNatTableWidget3.getCanBePresentedInTheTable(), (Object)dialog1.getSelectedQuery());
        ModelQuery newQuery = this.getNotRejectingQuery();
        dialog1.select(newQuery);
        IMustRemoveNonConformingElementsDialog dialog2 = dialog1.pressOk();
        Assert.assertNull((String)"The IMustRemoveNonConformingElementsDialog dialog must not be opened.", (Object)dialog2);
        int currentNbElement = this.iNatTableWidget3.getTableInstance().getElements().size();
        Assert.assertTrue((String)"The number of elements in the table must not change.", (initNbElement == currentNbElement ? 1 : 0) != 0);
    }

    @Test
    public void rejectingQueryAndRemoveElements() {
        this.iNatTableWidget3 = this.init();
        int initNbElement = this.iNatTableWidget3.getTableInstance().getElements().size();
        this.rejectingQueryAndRemoveElements(true);
        int currentNbElement = this.iNatTableWidget3.getTableInstance().getElements().size();
        Assert.assertTrue((String)"The number of elements in the table must have decrease.", (initNbElement > currentNbElement ? 1 : 0) != 0);
    }

    @Test
    public void rejectingQueryAndNotRemoveElements() {
        this.iNatTableWidget3 = this.init();
        int initNbElement = this.iNatTableWidget3.getTableInstance().getElements().size();
        this.rejectingQueryAndRemoveElements(false);
        int currentNbElement = this.iNatTableWidget3.getTableInstance().getElements().size();
        Assert.assertTrue((String)"The number of elements in the table must not change.", (initNbElement == currentNbElement ? 1 : 0) != 0);
    }

    public void rejectingQueryAndRemoveElements(boolean removeRejectedElements) {
        ICanBePesentedQueryDialog dialog1 = this.iNatTableWidget3.openCanBePresentedInTheTableDialog();
        Assert.assertEquals((String)"The selected query in the dialog must be the current canBePresentedQuery of the table widget", (Object)this.iNatTableWidget3.getCanBePresentedInTheTable(), (Object)dialog1.getSelectedQuery());
        ModelQuery newQuery = this.getRejectingQuery();
        dialog1.select(newQuery);
        IMustRemoveNonConformingElementsDialog dialog2 = dialog1.pressOk();
        Assert.assertNotNull((String)"The IMustRemoveNonConformingElementsDialog dialog must be opened.", (Object)dialog2);
        if (removeRejectedElements) {
            dialog2.pressYes();
            Assert.assertTrue((boolean)dialog2.getMustRemoveNonConformingElements());
        } else {
            dialog2.pressNo();
            Assert.assertFalse((boolean)dialog2.getMustRemoveNonConformingElements());
        }
    }

    private INatTableWidget3 init() {
        return null;
    }

    private ModelQuery getNotRejectingQuery() {
        return null;
    }

    private ModelQuery getRejectingQuery() {
        return null;
    }
}

