/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.data.convert;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import net.sourceforge.nattable.data.convert.IDisplayConverter;
import net.sourceforge.nattable.util.ObjectUtils;

public class DefaultDateDisplayConverter
implements IDisplayConverter {
    private DateFormat dateFormat;

    public DefaultDateDisplayConverter(String dateFormat) {
        this.dateFormat = new SimpleDateFormat(dateFormat);
    }

    public DefaultDateDisplayConverter() {
        this.dateFormat = new SimpleDateFormat();
    }

    public Object canonicalToDisplayValue(Object canonicalValue) {
        try {
            if (ObjectUtils.isNotNull(canonicalValue)) {
                return this.dateFormat.format(canonicalValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return canonicalValue;
    }

    public Object displayToCanonicalValue(Object displayValue) {
        try {
            return this.dateFormat.parse(displayValue.toString());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return displayValue;
        }
    }
}

