/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.custom.ui.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.TypeView;
import org.eclipse.emf.facet.infra.browser.custom.ui.Activator;
import org.eclipse.emf.facet.infra.browser.custom.ui.dialogs.LoadCustomizationsDialog;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLoadCustomizationsAction
extends Action {
    private static final String ICON_UI_CUSTOM = "icons/uiCustom.gif";

    public AbstractLoadCustomizationsAction() {
        super("Load Customizations", 1);
        this.setToolTipText("Load Customizations");
        this.setImageDescriptor(Activator.createImageDescriptor(ICON_UI_CUSTOM));
    }

    public void run() {
        List<MetamodelView> registeredCustomizations = this.getRegisteredCustomizations();
        LoadCustomizationsDialog loadCustomizationsDialog = this.createLoadCustomizationDialog(registeredCustomizations);
        if (loadCustomizationsDialog.open() == 0) {
            try {
                List<MetamodelView> selectedCustomizations = loadCustomizationsDialog.getSelectedCustomizations();
                if (loadCustomizationsDialog.isLoadRequiredFacetsSelected()) {
                    this.loadFacetsForCustomizations(selectedCustomizations);
                }
                this.loadCustomizations(selectedCustomizations);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
    }

    protected LoadCustomizationsDialog createLoadCustomizationDialog(List<MetamodelView> registeredCustomizations) {
        return new LoadCustomizationsDialog(this.getShell(), registeredCustomizations, this.getReferencedEPackages());
    }

    protected abstract List<MetamodelView> getRegisteredCustomizations();

    protected abstract void loadCustomizations(List<MetamodelView> var1);

    protected abstract Shell getShell();

    protected abstract Collection<EPackage> getReferencedEPackages();

    private void loadFacetsForCustomizations(List<MetamodelView> customizations) {
        HashSet<Facet> referencedFacets = new HashSet<Facet>();
        Collection facetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
        for (MetamodelView customization : customizations) {
            String metamodelURI = customization.getMetamodelURI();
            FacetSet customizedFacetSet = null;
            if (metamodelURI != null) {
                for (FacetSet facetSet : facetSets) {
                    if (!metamodelURI.equals(facetSet.getNsURI())) continue;
                    customizedFacetSet = facetSet;
                    break;
                }
            }
            if (customizedFacetSet == null) continue;
            EList types = customization.getTypes();
            for (TypeView typeView : types) {
                String metaclassName = typeView.getMetaclassName();
                Facet facet = this.findFacetWithFullyQualifiedName(metaclassName, customizedFacetSet);
                if (facet != null) {
                    referencedFacets.add(facet);
                    continue;
                }
                Logger.logError((String)NLS.bind((String)"Missing required Facet: {0} in FacetSet {1}, for customization {2}", (Object[])new Object[]{metaclassName, customizedFacetSet.getName(), customization.getName()}), (Plugin)Activator.getDefault());
            }
            for (Facet referencedFacet : referencedFacets) {
                this.loadFacet(referencedFacet);
            }
        }
        this.facetsLoaded(referencedFacets);
    }

    protected void facetsLoaded() {
    }

    protected void facetsLoaded(Set<Facet> referencedFacets) {
    }

    protected abstract void loadFacet(Facet var1);

    protected Facet findFacetWithFullyQualifiedName(String metaclassName, FacetSet customizedFacetSet) {
        EList facets = customizedFacetSet.getFacets();
        for (Facet facet : facets) {
            String facetName = ModelUtils.getMetaclassQualifiedName((EClassifier)facet);
            if (!metaclassName.equals(facetName)) continue;
            return facet;
        }
        return null;
    }
}

