/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.query.core.java.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.infra.common.core.internal.builder.AbstractEmfFacetCatalog;
import org.eclipse.emf.facet.infra.common.core.internal.builder.CatalogJob;
import org.eclipse.emf.facet.infra.query.JavaModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.internal.Activator;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class JavaQueryImplMarkerChangeListener
implements IResourceChangeListener,
AbstractEmfFacetCatalog.EmfFacetCatalogChangeListener,
AbstractEmfFacetCatalog.NonValidFileListener {
    private static JavaQueryImplMarkerChangeListener singleton;
    private final Map<IFile, IFile> javaFileToJavaQueryFileMap = new HashMap<IFile, IFile>();
    private final Map<IFile, List<IFile>> querySetToJavaQueriesMap = new HashMap<IFile, List<IFile>>();
    private final List<IFile> nonValidFiles = new ArrayList<IFile>();

    private JavaQueryImplMarkerChangeListener() {
        ModelQuerySetCatalog.getSingleton().addChangeListener(this);
        ModelQuerySetCatalog.getSingleton().addNonValidFileListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public static JavaQueryImplMarkerChangeListener getSingleton() {
        if (singleton == null) {
            singleton = new JavaQueryImplMarkerChangeListener();
        }
        return singleton;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
        final HashSet<IFile> toBeUpdated = new HashSet<IFile>();
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas;
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
            IResource resource = markerDelta.getResource();
            String fileExtension = resource.getFileExtension();
            if (resource instanceof IFile && fileExtension != null && fileExtension.equals("java")) {
                try {
                    IProject project = resource.getProject();
                    if (project != null && project.exists() && project.isOpen() && project.getNature("org.eclipse.emf.facet.common.ProjectNature") != null) {
                        IFile javaFile = (IFile)resource;
                        IFile querySetFile = this.javaFileToJavaQueryFileMap.get(javaFile);
                        if (querySetFile != null) {
                            toBeUpdated.add(querySetFile);
                        }
                        for (IFile nonValidFile : this.nonValidFiles) {
                            toBeUpdated.add(nonValidFile);
                        }
                    }
                }
                catch (CoreException e) {
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
            ++n2;
        }
        if (!toBeUpdated.isEmpty()) {
            Runnable action = new Runnable(){

                public void run() {
                    HashSet<IProject> projectsToUpdate = new HashSet<IProject>();
                    for (IFile file : toBeUpdated) {
                        ModelQuerySetCatalog.getSingleton().scheduleUpdateWSFile(file);
                        projectsToUpdate.add(file.getProject());
                    }
                    for (IProject project : projectsToUpdate) {
                        ModelQuerySetCatalog.getSingleton().revalidateAll(project);
                    }
                }
            };
            CatalogJob.getInstance().addAction(action);
        }
    }

    public void changed(EObject eObject, IFile file) {
    }

    public void added(EObject eObject, IFile queryFile) {
        if (eObject instanceof ModelQuerySet) {
            ModelQuerySet modelQuerySet = (ModelQuerySet)eObject;
            for (ModelQuery query : modelQuerySet.getQueries()) {
                if (!(query instanceof JavaModelQuery)) continue;
                JavaModelQuery javaModelQuery = (JavaModelQuery)query;
                String implementationClassName = javaModelQuery.getImplementationClassName();
                if (queryFile == null) continue;
                try {
                    IProject project = queryFile.getProject();
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IType type = javaProject.findType(javaModelQuery.getImplementationClassName());
                    IPath cuPath = type.getCompilationUnit().getPath();
                    IFile javaFile = project.getFile(cuPath);
                    this.associate(queryFile, javaFile);
                }
                catch (JavaModelException e) {
                    Logger.logError((Throwable)e, (String)("Failed to find the Java class associated to the query: " + implementationClassName), (Plugin)Activator.getDefault());
                }
            }
        }
    }

    private void associate(IFile queryFile, IFile javaFile) {
        this.javaFileToJavaQueryFileMap.put(javaFile, queryFile);
        List<IFile> javaFiles = this.querySetToJavaQueriesMap.get(queryFile);
        if (javaFiles == null) {
            javaFiles = new ArrayList<IFile>();
            this.querySetToJavaQueriesMap.put(queryFile, javaFiles);
        }
        javaFiles.add(javaFile);
    }

    public void removed(IFile file) {
        List<IFile> javaFiles = this.querySetToJavaQueriesMap.get(file);
        this.javaFileToJavaQueryFileMap.remove(javaFiles);
    }

    public void nonValidFile(IFile file, Resource resource) {
        this.nonValidFiles.add(file);
    }
}

