/*******************************************************************************
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Nicolas Guyomar (Mia-Software) - Bug 342451 - To be able to edit derived facet attributes and derived facet references in a table
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.examples.ecore.internal.query.eclassifier;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.emf.facet.infra.query.core.java.IJavaModelQueryWithEditingDomain;
import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue;

/** set the abstract attribute */
public class SetIsAbstract implements IJavaModelQueryWithEditingDomain<EClassifier, EObject> {

	public EObject evaluate(final EClassifier context, final ParameterValueList parameterValues)
			throws ModelQueryExecutionException {
		return null;
	}

	public EObject evaluate(final EClassifier context, final ParameterValueList parameterValues,
			final EditingDomain editingDomain) throws ModelQueryExecutionException {
		if (context instanceof EClass) {
			ModelQueryParameterValue model = parameterValues
					.getParameterValueByName(FacetContext.NEW_VALUE);
			Object value = model.getValue();

			if (value instanceof String) {
				if (value.toString().equals("Abstract")) { //$NON-NLS-1$
					Command command = new SetCommand(editingDomain, context,
							EcorePackage.eINSTANCE.getEClass_Abstract(), new Boolean(true));
					editingDomain.getCommandStack().execute(command);
				} else if (value.toString().equals("Not Abstract")) { //$NON-NLS-1$
					Command command = new SetCommand(editingDomain, context,
							EcorePackage.eINSTANCE.getEClass_Abstract(), new Boolean(false));
					editingDomain.getCommandStack().execute(command);
				}
			}
		}
		return null;
	}
}
