/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 332226 - To be able to create or delete model element from the table - initial API and implementation
 */
package org.eclipse.emf.facet.widgets.nattable.tableconfiguration;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.widgets.celleditors.modelCellEditor.AbstractModelCellEditor;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Table Configuration</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration#getCanBePresentedInTheTable <em>Can Be Presented In The Table</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration#getForcedCellEditors <em>Forced Cell Editors</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration#getDefaultFacets <em>Default Facets</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration#getDefaultCustomizations <em>Default Customizations</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration#getInstantiationMethod <em>Instantiation Method</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration#getDefaultLocalCustomization <em>Default Local Customization</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableconfigurationPackage#getTableConfiguration()
 * @model
 * @generated
 */
public interface TableConfiguration extends EObject {
	/**
	 * Returns the value of the '<em><b>Can Be Presented In The Table</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Can Be Presented In The Table</em>' reference
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Can Be Presented In The Table</em>' reference.
	 * @see #setCanBePresentedInTheTable(ModelQuery)
	 * @see org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableconfigurationPackage#getTableConfiguration_CanBePresentedInTheTable()
	 * @model
	 * @generated
	 */
	ModelQuery getCanBePresentedInTheTable();

	/**
	 * Sets the value of the '{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration#getCanBePresentedInTheTable <em>Can Be Presented In The Table</em>}' reference.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Can Be Presented In The Table</em>' reference.
	 * @see #getCanBePresentedInTheTable()
	 * @generated
	 */
	void setCanBePresentedInTheTable(ModelQuery value);

	/**
	 * Returns the value of the '<em><b>Forced Cell Editors</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.emf.facet.widgets.celleditors.modelCellEditor.AbstractModelCellEditor}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Forced Cell Editors</em>' reference list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Forced Cell Editors</em>' reference list.
	 * @see org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableconfigurationPackage#getTableConfiguration_ForcedCellEditors()
	 * @model
	 * @generated
	 */
	EList<AbstractModelCellEditor> getForcedCellEditors();

	/**
	 * Returns the value of the '<em><b>Default Facets</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.emf.facet.infra.facet.Facet}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Default Facets</em>' reference list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Default Facets</em>' reference list.
	 * @see org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableconfigurationPackage#getTableConfiguration_DefaultFacets()
	 * @model
	 * @generated
	 */
	EList<Facet> getDefaultFacets();

	/**
	 * Returns the value of the '<em><b>Default Customizations</b></em>'
	 * reference list. The list contents are of type
	 * {@link org.eclipse.emf.facet.infra.browser.custom.MetamodelView}. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Default Customizations</em>' reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Default Customizations</em>' reference
	 *         list.
	 * @see org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableconfigurationPackage#getTableConfiguration_DefaultCustomizations()
	 * @model
	 * @generated
	 */
	EList<MetamodelView> getDefaultCustomizations();

	/**
	 * Returns the value of the '<em><b>Instantiation Method</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.InstantiationMethod}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Instantiation Method</em>' reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Instantiation Method</em>' containment reference list.
	 * @see org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableconfigurationPackage#getTableConfiguration_InstantiationMethod()
	 * @model containment="true"
	 * @generated
	 */
	EList<InstantiationMethod> getInstantiationMethod();

	/**
	 * Returns the value of the '<em><b>Default Local Customization</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Default Local Customization</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Default Local Customization</em>' reference.
	 * @see #setDefaultLocalCustomization(MetamodelView)
	 * @see org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableconfigurationPackage#getTableConfiguration_DefaultLocalCustomization()
	 * @model
	 * @generated
	 */
	MetamodelView getDefaultLocalCustomization();

	/**
	 * Sets the value of the '{@link org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration#getDefaultLocalCustomization <em>Default Local Customization</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Default Local Customization</em>' reference.
	 * @see #getDefaultLocalCustomization()
	 * @generated
	 */
	void setDefaultLocalCustomization(MetamodelView value);

} // TableConfiguration
