/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.List;
import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.coordinate.ColumnPositionCoordinate;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.ImagePainter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.facet.widgets.internal.ImageProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderImagePainter
extends ImagePainter {
    private final NatTableWidget.BodyLayerStack bodyLayer;
    private final List<Column> columns;
    private final LabelProvider labelProvider;

    public HeaderImagePainter(NatTableWidget.BodyLayerStack bodyLayer, List<Column> columns, LabelProvider labelProvider) {
        super(null, false);
        this.bodyLayer = bodyLayer;
        this.columns = columns;
        this.labelProvider = labelProvider;
    }

    protected Image getImage(LayerCell cell, IConfigRegistry configRegistry) {
        ColumnPositionCoordinate converted = LayerCommandUtil.convertColumnPositionToTargetContext((ColumnPositionCoordinate)new ColumnPositionCoordinate(cell.getLayer(), cell.getColumnPosition()), (ILayer)this.bodyLayer.getBodyDataLayer());
        if (converted != null && converted.columnPosition >= 0 && converted.columnPosition < this.columns.size()) {
            return this.getColumnImage(this.columns.get(converted.columnPosition));
        }
        return null;
    }

    private Image getColumnImage(Column column) {
        if (column instanceof AttributeColumn) {
            return ImageProvider.getInstance().getAttributeIcon();
        }
        if (column instanceof ReferenceColumn) {
            ReferenceColumn referenceColumn = (ReferenceColumn)column;
            EReference reference = referenceColumn.getReference();
            return this.labelProvider.getImage((Object)reference);
        }
        if (column instanceof QueryColumn) {
            return ImageProvider.getInstance().getQueryIcon();
        }
        if (column instanceof FacetAttributeColumn) {
            return ImageProvider.getInstance().getFacetAttributeIcon();
        }
        if (column instanceof FacetReferenceColumn) {
            return ImageProvider.getInstance().getFacetLinkIcon();
        }
        return null;
    }
}

